/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import jakarta.persistence.EnumType;
import jakarta.persistence.TemporalType;
import org.hibernate.AssertionFailure;
import org.hibernate.Incubating;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public interface JdbcTypeIndicators {
    public static final int NO_COLUMN_LENGTH = -1;
    public static final int NO_COLUMN_PRECISION = -1;
    public static final int NO_COLUMN_SCALE = -1;

    default public boolean isNationalized() {
        return false;
    }

    default public boolean isLob() {
        return false;
    }

    default public EnumType getEnumeratedType() {
        return EnumType.ORDINAL;
    }

    default public TemporalType getTemporalPrecision() {
        return null;
    }

    default public boolean isPreferJavaTimeJdbcTypesEnabled() {
        return this.getCurrentBaseSqlTypeIndicators().isPreferJavaTimeJdbcTypesEnabled();
    }

    default public boolean isPreferNativeEnumTypesEnabled() {
        return this.getCurrentBaseSqlTypeIndicators().isPreferNativeEnumTypesEnabled();
    }

    default public int getPreferredSqlTypeCodeForBoolean() {
        return this.resolveJdbcTypeCode(this.getCurrentBaseSqlTypeIndicators().getPreferredSqlTypeCodeForBoolean());
    }

    default public int getPreferredSqlTypeCodeForDuration() {
        return this.resolveJdbcTypeCode(this.getCurrentBaseSqlTypeIndicators().getPreferredSqlTypeCodeForDuration());
    }

    default public int getPreferredSqlTypeCodeForUuid() {
        return this.resolveJdbcTypeCode(this.getCurrentBaseSqlTypeIndicators().getPreferredSqlTypeCodeForUuid());
    }

    default public int getPreferredSqlTypeCodeForInstant() {
        return this.resolveJdbcTypeCode(this.getCurrentBaseSqlTypeIndicators().getPreferredSqlTypeCodeForInstant());
    }

    default public int getPreferredSqlTypeCodeForArray() {
        return this.resolveJdbcTypeCode(this.getCurrentBaseSqlTypeIndicators().getPreferredSqlTypeCodeForArray());
    }

    default public long getColumnLength() {
        return -1L;
    }

    default public int getColumnPrecision() {
        return -1;
    }

    default public int getColumnScale() {
        return -1;
    }

    @Incubating
    default public Integer getExplicitJdbcTypeCode() {
        return this.getPreferredSqlTypeCodeForArray();
    }

    default public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
        return this.getCurrentBaseSqlTypeIndicators().getDefaultTimeZoneStorageStrategy();
    }

    default public JdbcType getJdbcType(int jdbcTypeCode) {
        return this.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(jdbcTypeCode);
    }

    default public int resolveJdbcTypeCode(int jdbcTypeCode) {
        return jdbcTypeCode;
    }

    public TypeConfiguration getTypeConfiguration();

    private JdbcTypeIndicators getCurrentBaseSqlTypeIndicators() {
        return this.getTypeConfiguration().getCurrentBaseSqlTypeIndicators();
    }

    public static int getZonedTimeSqlType(TimeZoneStorageStrategy storageStrategy) {
        switch (storageStrategy) {
            case NATIVE: {
                return 2013;
            }
            case COLUMN: 
            case NORMALIZE: {
                return 92;
            }
            case NORMALIZE_UTC: {
                return 3007;
            }
        }
        throw new AssertionFailure("unknown time zone storage strategy");
    }

    public static int getZonedTimestampSqlType(TimeZoneStorageStrategy storageStrategy) {
        switch (storageStrategy) {
            case NATIVE: {
                return 2014;
            }
            case COLUMN: 
            case NORMALIZE: {
                return 93;
            }
            case NORMALIZE_UTC: {
                return 3003;
            }
        }
        throw new AssertionFailure("unknown time zone storage strategy");
    }

    default public int getDefaultZonedTimeSqlType() {
        return JdbcTypeIndicators.getZonedTimeSqlType(this.getDefaultTimeZoneStorageStrategy());
    }

    default public int getDefaultZonedTimestampSqlType() {
        TemporalType temporalPrecision = this.getTemporalPrecision();
        switch (temporalPrecision == null ? TemporalType.TIMESTAMP : temporalPrecision) {
            case TIME: {
                return JdbcTypeIndicators.getZonedTimeSqlType(this.getDefaultTimeZoneStorageStrategy());
            }
            case DATE: {
                return 91;
            }
            case TIMESTAMP: {
                return JdbcTypeIndicators.getZonedTimestampSqlType(this.getDefaultTimeZoneStorageStrategy());
            }
        }
        throw new IllegalArgumentException("Unexpected jakarta.persistence.TemporalType : " + temporalPrecision);
    }

    public Dialect getDialect();
}

