/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.embeddable.AggregateEmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableInitializerImpl;
import org.hibernate.sql.results.graph.embeddable.internal.NestedRowProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class AggregateEmbeddableInitializerImpl
extends EmbeddableInitializerImpl {
    private final int[] aggregateValuesArrayPositions;

    public AggregateEmbeddableInitializerImpl(AggregateEmbeddableResultGraphNode resultDescriptor, BasicFetch<?> discriminatorFetch, InitializerParent<?> parent, AssemblerCreationState creationState, boolean isResultInitializer) {
        super(resultDescriptor, discriminatorFetch, parent, creationState, isResultInitializer);
        this.aggregateValuesArrayPositions = resultDescriptor.getAggregateValuesArrayPositions();
    }

    @Override
    public void startLoading(RowProcessingState rowProcessingState) {
        super.startLoading(NestedRowProcessingState.wrap(this, rowProcessingState));
    }

    public int[] getAggregateValuesArrayPositions() {
        return this.aggregateValuesArrayPositions;
    }

    public Object[] getJdbcValues(RowProcessingState processingState) {
        int[] aggregateValuesArrayPositions = this.getAggregateValuesArrayPositions();
        Object[] jdbcValue = (Object[])processingState.getJdbcValue(aggregateValuesArrayPositions[0]);
        for (int i = 1; i < aggregateValuesArrayPositions.length && jdbcValue != null; ++i) {
            jdbcValue = (Object[])jdbcValue[aggregateValuesArrayPositions[i]];
        }
        return jdbcValue;
    }
}

