/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.JsonJdbcType;

public class H2JsonJdbcType
extends JsonJdbcType {
    public static final H2JsonJdbcType INSTANCE = new H2JsonJdbcType(null);

    protected H2JsonJdbcType(EmbeddableMappingType embeddableMappingType) {
        super(embeddableMappingType);
    }

    @Override
    public String toString() {
        return "FormatJsonJdbcType";
    }

    @Override
    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new H2JsonJdbcType(mappingType);
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                String json = ((H2JsonJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                st.setBytes(index, json.getBytes(StandardCharsets.UTF_8));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                String json = ((H2JsonJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                st.setBytes(name, json.getBytes(StandardCharsets.UTF_8));
            }
        };
    }
}

