/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.idp;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.Profile;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.IdentityProviderStorageProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.infinispan.CachedCount;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.RealmCacheSession;
import org.keycloak.models.cache.infinispan.idp.CachedIdentityProvider;
import org.keycloak.models.cache.infinispan.idp.CachedIdentityProviderMapper;
import org.keycloak.models.cache.infinispan.idp.IdentityProviderListQuery;
import org.keycloak.organization.OrganizationProvider;

public class InfinispanIdentityProviderStorageProvider
implements IdentityProviderStorageProvider {
    private static final String IDP_COUNT_KEY_SUFFIX = ".idp.count";
    private static final String IDP_ALIAS_KEY_SUFFIX = ".idp.alias";
    private static final String IDP_ORG_ID_KEY_SUFFIX = ".idp.orgId";
    private static final String IDP_LOGIN_SUFFIX = ".idp.login";
    private final KeycloakSession session;
    private final IdentityProviderStorageProvider idpDelegate;
    private final RealmCacheSession realmCache;
    private final long startupRevision;

    public InfinispanIdentityProviderStorageProvider(KeycloakSession session) {
        this.session = session;
        this.idpDelegate = (IdentityProviderStorageProvider)session.getProvider(IdentityProviderStorageProvider.class, "jpa");
        this.realmCache = (RealmCacheSession)session.getProvider(CacheRealmProvider.class);
        this.startupRevision = this.realmCache.getCache().getCurrentCounter();
    }

    private static String cacheKeyIdpCount(RealmModel realm) {
        return realm.getId() + IDP_COUNT_KEY_SUFFIX;
    }

    private static String cacheKeyIdpAlias(RealmModel realm, String alias) {
        return realm.getId() + "." + alias + IDP_ALIAS_KEY_SUFFIX;
    }

    private static String cacheKeyIdpMapperAliasName(RealmModel realm, String alias, String name) {
        return realm.getId() + "." + alias + ".idp.alias." + name;
    }

    public static String cacheKeyOrgId(RealmModel realm, String orgId) {
        return realm.getId() + "." + orgId + IDP_ORG_ID_KEY_SUFFIX;
    }

    public static String cacheKeyForLogin(RealmModel realm, IdentityProviderStorageProvider.FetchMode fetchMode) {
        return realm.getId() + ".idp.login." + String.valueOf(fetchMode);
    }

    public IdentityProviderModel create(IdentityProviderModel model) {
        this.registerCountInvalidation();
        this.registerIDPLoginInvalidation(model);
        return this.idpDelegate.create(model);
    }

    public void update(IdentityProviderModel model) {
        IdentityProviderModel idpById = this.getById(model.getInternalId());
        this.registerIDPInvalidation(idpById);
        this.registerIDPLoginInvalidationOnUpdate(idpById, model);
        this.idpDelegate.update(model);
    }

    public boolean remove(String alias) {
        String cacheKey = InfinispanIdentityProviderStorageProvider.cacheKeyIdpAlias(this.getRealm(), alias);
        IdentityProviderModel storedIdp = this.idpDelegate.getByAlias(alias);
        if (this.isInvalid(cacheKey)) {
            this.registerIDPInvalidation(storedIdp);
        } else {
            CachedIdentityProvider cached = this.realmCache.getCache().get(cacheKey, CachedIdentityProvider.class);
            if (cached != null) {
                this.registerIDPInvalidation(cached.getIdentityProvider());
            }
        }
        this.registerCountInvalidation();
        this.registerIDPLoginInvalidation(storedIdp);
        return this.idpDelegate.remove(alias);
    }

    public void removeAll() {
        this.registerCountInvalidation();
        this.idpDelegate.removeAll();
    }

    public IdentityProviderModel getById(String internalId) {
        if (internalId == null) {
            return null;
        }
        CachedIdentityProvider cached = this.realmCache.getCache().get(internalId, CachedIdentityProvider.class);
        String realmId = this.getRealm().getId();
        if (cached != null && !cached.getRealm().equals(realmId)) {
            cached = null;
        }
        if (cached == null) {
            Long loaded = this.realmCache.getCache().getCurrentRevision(internalId);
            IdentityProviderModel model = this.idpDelegate.getById(internalId);
            if (model == null) {
                return null;
            }
            if (this.isInvalid(internalId)) {
                return this.createOrganizationAwareIdentityProviderModel(model);
            }
            cached = new CachedIdentityProvider(loaded, this.getRealm(), internalId, model);
            this.realmCache.getCache().addRevisioned(cached, this.realmCache.getStartupRevision());
        } else if (this.isInvalid(internalId)) {
            return this.createOrganizationAwareIdentityProviderModel(this.idpDelegate.getById(internalId));
        }
        return this.createOrganizationAwareIdentityProviderModel(cached.getIdentityProvider());
    }

    public IdentityProviderModel getByAlias(String alias) {
        String cacheKey = InfinispanIdentityProviderStorageProvider.cacheKeyIdpAlias(this.getRealm(), alias);
        if (this.isInvalid(cacheKey)) {
            return this.createOrganizationAwareIdentityProviderModel(this.idpDelegate.getByAlias(alias));
        }
        CachedIdentityProvider cached = this.realmCache.getCache().get(cacheKey, CachedIdentityProvider.class);
        if (cached == null) {
            Long loaded = this.realmCache.getCache().getCurrentRevision(cacheKey);
            IdentityProviderModel model = this.idpDelegate.getByAlias(alias);
            if (model == null) {
                return null;
            }
            cached = new CachedIdentityProvider(loaded, this.getRealm(), cacheKey, model);
            this.realmCache.getCache().addRevisioned(cached, this.realmCache.getStartupRevision());
        }
        return this.createOrganizationAwareIdentityProviderModel(cached.getIdentityProvider());
    }

    public Stream<IdentityProviderModel> getByOrganization(String orgId, Integer first, Integer max) {
        Set<String> cached;
        RealmModel realm = this.getRealm();
        String cacheKey = InfinispanIdentityProviderStorageProvider.cacheKeyOrgId(realm, orgId);
        if (this.isInvalid(cacheKey) || this.isInvalid(orgId)) {
            return this.idpDelegate.getByOrganization(orgId, first, max).map(this::createOrganizationAwareIdentityProviderModel);
        }
        RealmCacheManager cache = this.realmCache.getCache();
        IdentityProviderListQuery query = cache.get(cacheKey, IdentityProviderListQuery.class);
        String searchKey = String.valueOf(Optional.ofNullable(first).orElse(-1)) + "." + String.valueOf(Optional.ofNullable(max).orElse(-1));
        if (query == null) {
            loaded = cache.getCurrentRevision(cacheKey);
            cached = this.idpDelegate.getByOrganization(orgId, first, max).map(IdentityProviderModel::getInternalId).collect(Collectors.toSet());
            query = new IdentityProviderListQuery(loaded, cacheKey, realm, searchKey, cached);
            cache.addRevisioned(query, this.startupRevision);
        } else {
            cached = query.getIDPs(searchKey);
            if (cached == null) {
                cache.invalidateObject(cacheKey);
                loaded = cache.getCurrentRevision(cacheKey);
                cached = this.idpDelegate.getByOrganization(orgId, first, max).map(IdentityProviderModel::getInternalId).collect(Collectors.toSet());
                query = new IdentityProviderListQuery(loaded, cacheKey, realm, searchKey, cached, query);
                cache.addRevisioned(query, cache.getCurrentCounter());
            }
        }
        HashSet<IdentityProviderModel> identityProviders = new HashSet<IdentityProviderModel>();
        for (String id : cached) {
            IdentityProviderModel idp = this.session.identityProviders().getById(id);
            if (idp == null) {
                this.realmCache.registerInvalidation(cacheKey);
                return this.idpDelegate.getByOrganization(orgId, first, max).map(this::createOrganizationAwareIdentityProviderModel);
            }
            identityProviders.add(idp);
        }
        return identityProviders.stream();
    }

    public Stream<IdentityProviderModel> getForLogin(IdentityProviderStorageProvider.FetchMode mode, String organizationId) {
        Set<String> cached;
        String searchKey;
        String cacheKey = InfinispanIdentityProviderStorageProvider.cacheKeyForLogin(this.getRealm(), mode);
        if (this.isInvalid(cacheKey)) {
            return this.idpDelegate.getForLogin(mode, organizationId).map(this::createOrganizationAwareIdentityProviderModel);
        }
        RealmCacheManager cache = this.realmCache.getCache();
        IdentityProviderListQuery query = cache.get(cacheKey, IdentityProviderListQuery.class);
        String string = searchKey = organizationId != null ? organizationId : "";
        if (query == null) {
            loaded = cache.getCurrentRevision(cacheKey);
            cached = this.idpDelegate.getForLogin(mode, organizationId).map(IdentityProviderModel::getInternalId).collect(Collectors.toSet());
            query = new IdentityProviderListQuery(loaded, cacheKey, this.getRealm(), searchKey, cached);
            cache.addRevisioned(query, this.startupRevision);
        } else {
            cached = query.getIDPs(searchKey);
            if (cached == null) {
                cache.invalidateObject(cacheKey);
                loaded = cache.getCurrentRevision(cacheKey);
                cached = this.idpDelegate.getForLogin(mode, organizationId).map(IdentityProviderModel::getInternalId).collect(Collectors.toSet());
                query = new IdentityProviderListQuery(loaded, cacheKey, this.getRealm(), searchKey, cached, query);
                cache.addRevisioned(query, cache.getCurrentCounter());
            }
        }
        HashSet<IdentityProviderModel> identityProviders = new HashSet<IdentityProviderModel>();
        for (String id : cached) {
            IdentityProviderModel idp = this.session.identityProviders().getById(id);
            if (idp == null) {
                this.realmCache.registerInvalidation(cacheKey);
                return this.idpDelegate.getForLogin(mode, organizationId).map(this::createOrganizationAwareIdentityProviderModel);
            }
            identityProviders.add(idp);
        }
        return identityProviders.stream();
    }

    public Stream<String> getByFlow(String flowId, String search, Integer first, Integer max) {
        return this.idpDelegate.getByFlow(flowId, search, first, max);
    }

    public Stream<IdentityProviderModel> getAllStream(Map<String, String> attrs, Integer first, Integer max) {
        return this.idpDelegate.getAllStream(attrs, first, max).map(this::createOrganizationAwareIdentityProviderModel);
    }

    public long count() {
        String cacheKey = InfinispanIdentityProviderStorageProvider.cacheKeyIdpCount(this.getRealm());
        CachedCount cached = this.realmCache.getCache().get(cacheKey, CachedCount.class);
        if (cached != null && !this.isInvalid(cacheKey)) {
            return cached.getCount();
        }
        Long loaded = this.realmCache.getCache().getCurrentRevision(cacheKey);
        long count = this.idpDelegate.count();
        cached = new CachedCount(loaded, this.getRealm(), cacheKey, count);
        this.realmCache.getCache().addRevisioned(cached, this.realmCache.getStartupRevision());
        return count;
    }

    public void close() {
        this.idpDelegate.close();
    }

    public IdentityProviderMapperModel createMapper(IdentityProviderMapperModel model) {
        return this.idpDelegate.createMapper(model);
    }

    public void updateMapper(IdentityProviderMapperModel model) {
        this.registerIDPMapperInvalidation(model);
        this.idpDelegate.updateMapper(model);
    }

    public boolean removeMapper(IdentityProviderMapperModel model) {
        this.registerIDPMapperInvalidation(model);
        return this.idpDelegate.removeMapper(model);
    }

    public void removeAllMappers() {
        this.idpDelegate.removeAllMappers();
    }

    public IdentityProviderMapperModel getMapperById(String id) {
        CachedIdentityProviderMapper cached = this.realmCache.getCache().get(id, CachedIdentityProviderMapper.class);
        String realmId = this.getRealm().getId();
        if (cached != null && !cached.getRealm().equals(realmId)) {
            cached = null;
        }
        if (cached == null) {
            Long loaded = this.realmCache.getCache().getCurrentRevision(id);
            IdentityProviderMapperModel model = this.idpDelegate.getMapperById(id);
            if (model == null) {
                return null;
            }
            if (this.isInvalid(id)) {
                return model;
            }
            cached = new CachedIdentityProviderMapper(loaded, this.getRealm(), id, model);
            this.realmCache.getCache().addRevisioned(cached, this.realmCache.getStartupRevision());
        } else if (this.isInvalid(id)) {
            return this.idpDelegate.getMapperById(id);
        }
        return cached.getIdentityProviderMapper();
    }

    public IdentityProviderMapperModel getMapperByName(String identityProviderAlias, String name) {
        String cacheKey = InfinispanIdentityProviderStorageProvider.cacheKeyIdpMapperAliasName(this.getRealm(), identityProviderAlias, name);
        if (this.isInvalid(cacheKey)) {
            return this.idpDelegate.getMapperByName(identityProviderAlias, name);
        }
        CachedIdentityProviderMapper cached = this.realmCache.getCache().get(cacheKey, CachedIdentityProviderMapper.class);
        if (cached == null) {
            Long loaded = this.realmCache.getCache().getCurrentRevision(cacheKey);
            IdentityProviderMapperModel model = this.idpDelegate.getMapperByName(identityProviderAlias, name);
            if (model == null) {
                return null;
            }
            cached = new CachedIdentityProviderMapper(loaded, this.getRealm(), cacheKey, model);
            this.realmCache.getCache().addRevisioned(cached, this.realmCache.getStartupRevision());
        }
        return cached.getIdentityProviderMapper();
    }

    public Stream<IdentityProviderMapperModel> getMappersStream(Map<String, String> options, Integer first, Integer max) {
        return this.idpDelegate.getMappersStream(options, first, max);
    }

    public Stream<IdentityProviderMapperModel> getMappersByAliasStream(String identityProviderAlias) {
        return this.idpDelegate.getMappersByAliasStream(identityProviderAlias);
    }

    private void registerIDPInvalidation(IdentityProviderModel idp) {
        this.realmCache.registerInvalidation(idp.getInternalId());
        this.realmCache.registerInvalidation(InfinispanIdentityProviderStorageProvider.cacheKeyIdpAlias(this.getRealm(), idp.getAlias()));
    }

    private void registerCountInvalidation() {
        this.realmCache.registerInvalidation(InfinispanIdentityProviderStorageProvider.cacheKeyIdpCount(this.getRealm()));
    }

    private void registerIDPMapperInvalidation(IdentityProviderMapperModel mapper) {
        if (mapper.getId() == null) {
            throw new ModelException("Identity Provider Mapper does not exist");
        }
        this.realmCache.registerInvalidation(mapper.getId());
        this.realmCache.registerInvalidation(InfinispanIdentityProviderStorageProvider.cacheKeyIdpMapperAliasName(this.getRealm(), mapper.getIdentityProviderAlias(), mapper.getName()));
    }

    private void registerIDPLoginInvalidation(IdentityProviderModel idp) {
        if (IdentityProviderStorageProvider.LoginFilter.getLoginPredicate().test(idp)) {
            for (IdentityProviderStorageProvider.FetchMode mode : IdentityProviderStorageProvider.FetchMode.values()) {
                this.realmCache.registerInvalidation(InfinispanIdentityProviderStorageProvider.cacheKeyForLogin(this.getRealm(), mode));
            }
        }
    }

    private void registerIDPLoginInvalidationOnUpdate(IdentityProviderModel original, IdentityProviderModel updated) {
        if (!IdentityProviderStorageProvider.LoginFilter.getLoginPredicate().test(original) && !IdentityProviderStorageProvider.LoginFilter.getLoginPredicate().test(updated)) {
            return;
        }
        if (IdentityProviderStorageProvider.LoginFilter.getLoginPredicate().test(original) && IdentityProviderStorageProvider.LoginFilter.getLoginPredicate().test(updated) && Objects.equals(original.getOrganizationId(), updated.getOrganizationId())) {
            return;
        }
        for (IdentityProviderStorageProvider.FetchMode mode : IdentityProviderStorageProvider.FetchMode.values()) {
            this.realmCache.registerInvalidation(InfinispanIdentityProviderStorageProvider.cacheKeyForLogin(this.getRealm(), mode));
        }
    }

    private RealmModel getRealm() {
        RealmModel realm = this.session.getContext().getRealm();
        if (realm == null) {
            throw new IllegalArgumentException("Session not bound to a realm");
        }
        return realm;
    }

    private boolean isInvalid(String cacheKey) {
        return this.realmCache.isInvalid(cacheKey);
    }

    private IdentityProviderModel createOrganizationAwareIdentityProviderModel(IdentityProviderModel idp) {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
            return idp;
        }
        return new IdentityProviderModel(idp){

            public boolean isEnabled() {
                if (this.getOrganizationId() != null) {
                    OrganizationProvider provider = (OrganizationProvider)InfinispanIdentityProviderStorageProvider.this.session.getProvider(OrganizationProvider.class);
                    OrganizationModel org = provider == null ? null : provider.getById(this.getOrganizationId());
                    return org != null && provider.isEnabled() && org.isEnabled() && super.isEnabled();
                }
                return super.isEnabled();
            }
        };
    }
}

