/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;

public final class ImmutableList {
    private ImmutableList() {
    }

    public static <T> List<T> copyOf(List<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return ImmutableList.of(list.get(0));
        }
        if (list.size() == 2) {
            return ImmutableList.of(list.get(0), list.get(1));
        }
        return new ImmutableArrayList(list.toArray());
    }

    @SafeVarargs
    public static <T> List<T> of(T ... elements) {
        switch (elements.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return ImmutableList.of(elements[0]);
            }
            case 2: {
                return ImmutableList.of(elements[0], elements[1]);
            }
        }
        return new ImmutableArrayList(elements);
    }

    public static <E> List<E> of(E element) {
        return Collections.singletonList(element);
    }

    public static <E> List<E> of(E e1, E e2) {
        return new ImmutableList2<E>(e1, e2);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private static IndexOutOfBoundsException indexOutOfBound(int index, int size) {
        return new IndexOutOfBoundsException("Index " + index + " is out of bounds, list size: " + size);
    }

    static class ImmutableArrayList<E>
    extends AbstractList<E> {
        private final Object[] elements;

        ImmutableArrayList(Object[] elements) {
            this.elements = elements;
        }

        @Override
        public E get(int index) {
            if (index < 0 || index >= this.elements.length) {
                throw ImmutableList.indexOutOfBound(index, this.size());
            }
            return (E)this.elements[index];
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public Iterator<E> iterator() {
            return new Itr(this.elements.length, 0);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new Itr(this.elements.length, 0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new Itr(this.elements.length, index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || fromIndex > toIndex) {
                throw ImmutableList.indexOutOfBound(fromIndex, this.size());
            }
            if (toIndex > this.elements.length) {
                throw ImmutableList.indexOutOfBound(toIndex, this.size());
            }
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new ImmutableArrayList<E>(Arrays.copyOfRange(this.elements, fromIndex, toIndex));
        }

        @Override
        public String toString() {
            return Arrays.toString(this.elements);
        }

        @Override
        public boolean isEmpty() {
            return this.elements.length == 0;
        }

        @Override
        public Spliterator<E> spliterator() {
            return Spliterators.spliterator(this, 1296);
        }

        private final class Itr
        implements ListIterator<E> {
            private int cursor;
            private final int size;

            Itr(int size, int position) {
                this.size = size;
                this.cursor = position;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < this.size;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return ImmutableArrayList.this.elements[this.cursor++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            @Override
            public E previous() {
                if (this.hasPrevious()) {
                    return ImmutableArrayList.this.elements[--this.cursor];
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class ImmutableList2<E>
    extends AbstractList<E> {
        private final E e0;
        private final E e1;

        ImmutableList2(E e0, E e1) {
            this.e0 = e0;
            this.e1 = e1;
        }

        @Override
        public E get(int index) {
            if (index == 0) {
                return this.e0;
            }
            if (index == 1) {
                return this.e1;
            }
            throw ImmutableList.indexOutOfBound(index, 2);
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new Itr();
        }

        @Override
        public ListIterator<E> listIterator() {
            return new Itr();
        }

        private final class Itr
        implements ListIterator<E> {
            private byte cursor = 0;

            private Itr() {
            }

            @Override
            public boolean hasNext() {
                return this.cursor < 2;
            }

            @Override
            public E next() {
                if (this.cursor == 0) {
                    this.cursor = (byte)(this.cursor + 1);
                    return ImmutableList2.this.e0;
                }
                if (this.cursor == 1) {
                    this.cursor = (byte)(this.cursor + 1);
                    return ImmutableList2.this.e1;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            @Override
            public E previous() {
                if (this.cursor == 2) {
                    this.cursor = (byte)(this.cursor - 1);
                    return ImmutableList2.this.e1;
                }
                if (this.cursor == 1) {
                    this.cursor = (byte)(this.cursor - 1);
                    return ImmutableList2.this.e0;
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static final class Builder<T> {
        private List<T> elements = new ArrayList<T>();

        private Builder() {
        }

        public Builder<T> add(T element) {
            this.elements.add(element);
            return this;
        }

        public Builder<T> addAll(Collection<T> elements) {
            this.elements.addAll(elements);
            return this;
        }

        public List<T> build() {
            return ImmutableList.copyOf(this.elements);
        }
    }
}

