/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Position;

public class BufferingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferingManager.class);
    private final Timer timer = new HashedWheelTimer();
    private final Callback callback;
    private final long threshold;
    private final Map<Long, TreeSet<Holder>> buffer = new HashMap<Long, TreeSet<Holder>>();

    public BufferingManager(Config config, Callback callback) {
        this.callback = callback;
        this.threshold = config.getLong(Keys.SERVER_BUFFERING_THRESHOLD);
    }

    private Timeout scheduleTimeout(Holder holder) {
        return this.timer.newTimeout(timeout -> {
            LOGGER.debug("released {}", (Object)holder.position.getFixTime());
            Map<Long, TreeSet<Holder>> map = this.buffer;
            synchronized (map) {
                this.buffer.get(holder.position.getDeviceId()).remove(holder);
            }
            holder.context.executor().execute(() -> this.callback.onReleased(holder.context, holder.position));
        }, this.threshold, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(ChannelHandlerContext context, Position position) {
        if (this.threshold > 0L) {
            Map<Long, TreeSet<Holder>> map = this.buffer;
            synchronized (map) {
                LOGGER.debug("queued {}", (Object)position.getFixTime());
                TreeSet queue = this.buffer.computeIfAbsent(position.getDeviceId(), k -> new TreeSet());
                Holder holder = new Holder(context, position);
                holder.timeout = this.scheduleTimeout(holder);
                queue.add(holder);
                queue.tailSet(holder, false).forEach(h -> {
                    h.timeout.cancel();
                    h.timeout = this.scheduleTimeout((Holder)h);
                });
            }
        } else {
            this.callback.onReleased(context, position);
        }
    }

    public static interface Callback {
        public void onReleased(ChannelHandlerContext var1, Position var2);
    }

    private static final class Holder
    implements Comparable<Holder> {
        private final ChannelHandlerContext context;
        private final Position position;
        private Timeout timeout;

        private Holder(ChannelHandlerContext context, Position position) {
            this.context = context;
            this.position = position;
        }

        private int compareTime(Date left, Date right) {
            if (left != null && right != null) {
                return left.compareTo(right);
            }
            return 0;
        }

        @Override
        public int compareTo(Holder other) {
            int fixTimeResult = this.compareTime(this.position.getFixTime(), other.position.getFixTime());
            if (fixTimeResult != 0) {
                return fixTimeResult;
            }
            int deviceTimeResult = this.compareTime(this.position.getDeviceTime(), other.position.getDeviceTime());
            if (deviceTimeResult != 0) {
                return deviceTimeResult;
            }
            return this.position.getServerTime().compareTo(other.position.getServerTime());
        }
    }
}

