/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.relateng.NodeSection;
import org.locationtech.jts.operation.relateng.RelateEdge;

class RelateNode {
    private Coordinate nodePt;
    private ArrayList<RelateEdge> edges = new ArrayList();

    public RelateNode(Coordinate pt) {
        this.nodePt = pt;
    }

    public Coordinate getCoordinate() {
        return this.nodePt;
    }

    public List<RelateEdge> getEdges() {
        return this.edges;
    }

    public void addEdges(List<NodeSection> nss) {
        for (NodeSection ns : nss) {
            this.addEdges(ns);
        }
    }

    public void addEdges(NodeSection ns) {
        switch (ns.dimension()) {
            case 1: {
                this.addLineEdge(ns.isA(), ns.getVertex(0));
                this.addLineEdge(ns.isA(), ns.getVertex(1));
                break;
            }
            case 2: {
                RelateEdge e0 = this.addAreaEdge(ns.isA(), ns.getVertex(0), false);
                RelateEdge e1 = this.addAreaEdge(ns.isA(), ns.getVertex(1), true);
                int index0 = this.edges.indexOf(e0);
                int index1 = this.edges.indexOf(e1);
                this.updateEdgesInArea(ns.isA(), index0, index1);
                this.updateIfAreaPrev(ns.isA(), index0);
                this.updateIfAreaNext(ns.isA(), index1);
            }
        }
    }

    private void updateEdgesInArea(boolean isA, int indexFrom, int indexTo) {
        int index = RelateNode.nextIndex(this.edges, indexFrom);
        while (index != indexTo) {
            RelateEdge edge = this.edges.get(index);
            edge.setAreaInterior(isA);
            index = RelateNode.nextIndex(this.edges, index);
        }
    }

    private void updateIfAreaPrev(boolean isA, int index) {
        int indexPrev = RelateNode.prevIndex(this.edges, index);
        RelateEdge edgePrev = this.edges.get(indexPrev);
        if (edgePrev.isInterior(isA, 1)) {
            RelateEdge edge = this.edges.get(index);
            edge.setAreaInterior(isA);
        }
    }

    private void updateIfAreaNext(boolean isA, int index) {
        int indexNext = RelateNode.nextIndex(this.edges, index);
        RelateEdge edgeNext = this.edges.get(indexNext);
        if (edgeNext.isInterior(isA, 2)) {
            RelateEdge edge = this.edges.get(index);
            edge.setAreaInterior(isA);
        }
    }

    private RelateEdge addLineEdge(boolean isA, Coordinate dirPt) {
        return this.addEdge(isA, dirPt, 1, false);
    }

    private RelateEdge addAreaEdge(boolean isA, Coordinate dirPt, boolean isForward) {
        return this.addEdge(isA, dirPt, 2, isForward);
    }

    private RelateEdge addEdge(boolean isA, Coordinate dirPt, int dim, boolean isForward) {
        if (dirPt == null) {
            return null;
        }
        if (this.nodePt.equals2D(dirPt)) {
            return null;
        }
        int insertIndex = -1;
        for (int i = 0; i < this.edges.size(); ++i) {
            RelateEdge e = this.edges.get(i);
            int comp = e.compareToEdge(dirPt);
            if (comp == 0) {
                e.merge(isA, dirPt, dim, isForward);
                return e;
            }
            if (comp != 1) continue;
            insertIndex = i;
            break;
        }
        RelateEdge e = RelateEdge.create(this, dirPt, isA, dim, isForward);
        if (insertIndex < 0) {
            this.edges.add(e);
        } else {
            this.edges.add(insertIndex, e);
        }
        return e;
    }

    public void finish(boolean isAreaInteriorA, boolean isAreaInteriorB) {
        this.finishNode(true, isAreaInteriorA);
        this.finishNode(false, isAreaInteriorB);
    }

    private void finishNode(boolean isA, boolean isAreaInterior) {
        if (isAreaInterior) {
            RelateEdge.setAreaInterior(this.edges, isA);
        } else {
            int startIndex = RelateEdge.findKnownEdgeIndex(this.edges, isA);
            this.propagateSideLocations(isA, startIndex);
        }
    }

    private void propagateSideLocations(boolean isA, int startIndex) {
        int currLoc = this.edges.get(startIndex).location(isA, 1);
        int index = RelateNode.nextIndex(this.edges, startIndex);
        while (index != startIndex) {
            RelateEdge e = this.edges.get(index);
            e.setUnknownLocations(isA, currLoc);
            currLoc = e.location(isA, 1);
            index = RelateNode.nextIndex(this.edges, index);
        }
    }

    private static int prevIndex(ArrayList<RelateEdge> list, int index) {
        if (index > 0) {
            return index - 1;
        }
        return list.size() - 1;
    }

    private static int nextIndex(List<RelateEdge> list, int i) {
        if (i >= list.size() - 1) {
            return 0;
        }
        return i + 1;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Node[" + WKTWriter.toPoint(this.nodePt) + "]:");
        buf.append("\n");
        for (RelateEdge e : this.edges) {
            buf.append(e.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public boolean hasExteriorEdge(boolean isA) {
        for (RelateEdge e : this.edges) {
            if (2 != e.location(isA, 1) && 2 != e.location(isA, 2)) continue;
            return true;
        }
        return false;
    }
}

