/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.buffer;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jdk.jfr.consumer.RecordedEvent;

public final class DirectBufferStatisticsHandler
implements RecordedEventHandler {
    private static final String METRIC_NAME_USAGE = "jvm.buffer.memory.usage";
    private static final String METRIC_NAME_LIMIT = "jvm.buffer.memory.limit";
    private static final String METRIC_NAME_COUNT = "jvm.buffer.count";
    private static final String METRIC_DESCRIPTION_USAGE = "Measure of memory used by buffers.";
    private static final String METRIC_DESCRIPTION_LIMIT = "Measure of total memory capacity of buffers.";
    private static final String METRIC_DESCRIPTION_COUNT = "Number of buffers in the pool.";
    private static final String COUNT = "count";
    private static final String MAX_CAPACITY = "maxCapacity";
    private static final String MEMORY_USED = "memoryUsed";
    private static final String EVENT_NAME = "jdk.DirectBufferStatistics";
    public static final AttributeKey<String> ATTR_BUFFER_POOL = AttributeKey.stringKey((String)"jvm.buffer.pool.name");
    private static final Attributes ATTR = Attributes.of(ATTR_BUFFER_POOL, (Object)"direct");
    private final List<AutoCloseable> observables = new ArrayList<AutoCloseable>();
    private volatile long usage = 0L;
    private volatile long limit = 0L;
    private volatile long count = 0L;

    public DirectBufferStatisticsHandler(Meter meter) {
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder(METRIC_NAME_USAGE).setDescription(METRIC_DESCRIPTION_USAGE).setUnit("By").buildWithCallback(measurement -> measurement.record(this.usage, ATTR)));
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder(METRIC_NAME_LIMIT).setDescription(METRIC_DESCRIPTION_LIMIT).setUnit("By").buildWithCallback(measurement -> measurement.record(this.limit, ATTR)));
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder(METRIC_NAME_COUNT).setDescription(METRIC_DESCRIPTION_COUNT).setUnit("{buffer}").buildWithCallback(measurement -> measurement.record(this.count, ATTR)));
    }

    @Override
    public void accept(RecordedEvent ev) {
        if (ev.hasField(COUNT)) {
            this.count = ev.getLong(COUNT);
        }
        if (ev.hasField(MAX_CAPACITY)) {
            this.limit = ev.getLong(MAX_CAPACITY);
        }
        if (ev.hasField(MEMORY_USED)) {
            this.usage = ev.getLong(MEMORY_USED);
        }
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.BUFFER_METRICS;
    }

    @Override
    public Optional<Duration> getPollingDuration() {
        return Optional.of(Duration.ofSeconds(1L));
    }

    @Override
    public void close() {
        RecordedEventHandler.closeObservables(this.observables);
    }
}

