/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectMessages;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class PropertyNamingStrategyFactory {
    private static final String JSONB_TRANSLATE_NAME = "translateName";
    private static final String JACKSON_TRANSLATE = "translate";
    private static final String JACKSON_TRANSLATE_ENUM = "convertEnumToExternalName";
    private static final List<String> knownMethods = Arrays.asList("translateName", "translate", "convertEnumToExternalName");
    private static final Map<String, UnaryOperator<String>> STRATEGY_CACHE = new ConcurrentHashMap<String, UnaryOperator<String>>();

    private PropertyNamingStrategyFactory() {
    }

    public static UnaryOperator<String> getStrategy(String configValue, ClassLoader loader) {
        return STRATEGY_CACHE.computeIfAbsent(configValue, key -> PropertyNamingStrategyFactory.create(configValue, loader));
    }

    private static UnaryOperator<String> create(String configValue, ClassLoader loader) {
        Object strategy;
        Class<?> strategyType;
        switch (configValue) {
            case "IDENTITY": {
                return propertyName -> propertyName;
            }
            case "LOWER_CASE_WITH_DASHES": {
                return new ConfigurableNamingStrategy(Character::toLowerCase, '-');
            }
            case "LOWER_CASE_WITH_UNDERSCORES": {
                return new ConfigurableNamingStrategy(Character::toLowerCase, '_');
            }
            case "UPPER_CAMEL_CASE": {
                return PropertyNamingStrategyFactory.camelCaseStrategy();
            }
            case "UPPER_CAMEL_CASE_WITH_SPACES": {
                UnaryOperator<String> camelCase = PropertyNamingStrategyFactory.camelCaseStrategy();
                ConfigurableNamingStrategy space = new ConfigurableNamingStrategy(UnaryOperator.identity(), ' ');
                return propertyName -> (String)camelCase.apply((String)space.apply(propertyName));
            }
            case "CASE_INSENSITIVE": {
                return propertyName -> propertyName;
            }
        }
        try {
            strategyType = loader.loadClass(configValue);
            strategy = strategyType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw DataObjectMessages.msg.invalidPropertyNamingStrategyWithCause(configValue, e);
        }
        return Arrays.stream(strategyType.getMethods()).filter(PropertyNamingStrategyFactory::isStringUnaryOperator).filter(method -> knownMethods.contains(method.getName())).map(method -> propertyName -> {
            try {
                return (String)method.invoke(strategy, propertyName);
            }
            catch (Exception e) {
                throw DataObjectMessages.msg.invalidPropertyNamingStrategyWithCause(configValue, e);
            }
        }).findFirst().orElseThrow(() -> DataObjectMessages.msg.invalidPropertyNamingStrategy(configValue));
    }

    private static boolean isStringUnaryOperator(Method method) {
        if (!String.class.equals(method.getReturnType())) {
            return false;
        }
        if (method.getParameterCount() != 1) {
            return false;
        }
        return String.class.equals(method.getParameterTypes()[0]);
    }

    private static UnaryOperator<String> camelCaseStrategy() {
        return propertyName -> Character.toUpperCase(propertyName.charAt(0)) + (propertyName.length() > 1 ? propertyName.substring(1) : "");
    }

    private static class ConfigurableNamingStrategy
    implements UnaryOperator<String> {
        private final Function<Character, Character> converter;
        private final char separator;

        public ConfigurableNamingStrategy(UnaryOperator<Character> wordConverter, char sep) {
            this.converter = wordConverter;
            this.separator = sep;
        }

        @Override
        public String apply(String propertyName) {
            StringBuilder global = new StringBuilder();
            StringBuilder current = new StringBuilder();
            for (int i = 0; i < propertyName.length(); ++i) {
                char c = propertyName.charAt(i);
                if (Character.isUpperCase(c)) {
                    char transformed = this.converter.apply(Character.valueOf(c)).charValue();
                    if (current.length() > 0) {
                        global.append((CharSequence)current).append(this.separator);
                        current.setLength(0);
                    }
                    current.append(transformed);
                    continue;
                }
                current.append(c);
            }
            if (current.length() > 0) {
                global.append((CharSequence)current);
            } else {
                global.setLength(global.length() - 1);
            }
            return global.toString();
        }
    }
}

