/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.postgresql.runtime.graal;

import io.quarkus.jdbc.postgresql.runtime.graal.DomHelper;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public final class SQLXMLFeature
implements Feature {
    private final AtomicBoolean triggered = new AtomicBoolean(false);
    private static final boolean log = Boolean.getBoolean("io.quarkus.jdbc.postgresql.graalvm.diagnostics");

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(DomHelper.class, (Object)new DomHelper());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class pgSQLXMLClass = access.findClassByName("io.quarkus.jdbc.postgresql.runtime.graal.PgSQLXML");
        try {
            Method triggerMethod = pgSQLXMLClass.getMethod("setResult", Class.class);
            access.registerReachabilityHandler(this::identifiedXMLProcessingInDriver, new Object[]{triggerMethod});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void identifiedXMLProcessingInDriver(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        boolean needsEnablingYet = this.triggered.compareAndSet(false, true);
        if (needsEnablingYet) {
            if (log) {
                System.out.println("Quarkus' automatic feature for GraalVM native images: enabling support for XML processing in the PostgreSQL JDBC driver");
            }
            DomHelper.enableXmlProcessing();
        }
    }
}

