/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TipsOfTheDayUsagesCollector;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipPanel;
import com.intellij.ide.util.TipUiSettings;
import com.intellij.ide.util.TipsFeedback;
import com.intellij.ide.util.TipsSortingResult;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TipDialog
extends DialogWrapper {
    private final TipPanel myTipPanel;
    private final boolean myShowingOnStartup;
    private final boolean myShowActions;
    private boolean showRequestScheduled;

    TipDialog(@Nullable Project project, @NotNull TipsSortingResult sortingResult) {
        if (sortingResult == null) {
            TipDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.showRequestScheduled = false;
        this.setModal(false);
        this.setTitle(IdeBundle.message((String)"title.tip.of.the.day", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.myTipPanel = new TipPanel(project, sortingResult, this.getDisposable());
        this.myTipPanel.addPropertyChangeListener(TipPanel.CURRENT_TIP_KEY.toString(), event -> {
            if (this.showRequestScheduled) {
                this.showRequestScheduled = false;
                this.show();
            } else {
                this.adjustSizeToContent();
            }
        });
        boolean bl = this.myShowActions = sortingResult.getTips().size() > 1;
        if (this.myShowActions) {
            this.setDoNotAskOption(this.myTipPanel);
        }
        this.myShowingOnStartup = this.myTipPanel.isToBeShown();
        this.init();
    }

    public void showWhenTipInstalled() {
        this.showRequestScheduled = true;
    }

    private void adjustSizeToContent() {
        if (this.isDisposed()) {
            return;
        }
        Dimension prefSize = this.getPreferredSize();
        Dimension minSize = this.getRootPane().getMinimumSize();
        int height = Math.max(prefSize.height, minSize.height);
        this.setSize(prefSize.width, height);
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            TipDialog.$$$reportNull$$$0(1);
        }
        return dialogStyle;
    }

    protected JComponent createSouthPanel() {
        JComponent component = super.createSouthPanel();
        component.setBorder((Border)JBUI.Borders.empty((int)13, (int)24, (int)15, (int)24));
        UIUtil.setBackgroundRecursively((Component)component, (Color)TipUiSettings.getPanelBackground());
        String previousTipKey = "PreviousTip";
        component.getInputMap(1).put(KeyStroke.getKeyStroke(10, 64), previousTipKey);
        component.getActionMap().put(previousTipKey, this.myTipPanel.myPreviousTipAction);
        return component;
    }

    public void doCancelAction() {
        super.doCancelAction();
        TipsOfTheDayUsagesCollector.triggerDialogClosed(this.myShowingOnStartup);
        Map<String, Boolean> tipIdToLikenessState = this.myTipPanel.getTipIdToLikenessStateMap();
        for (Map.Entry<String, Boolean> pair : tipIdToLikenessState.entrySet()) {
            String tipId = pair.getKey();
            Boolean likenessState = pair.getValue();
            TipsFeedback feedback = TipsFeedback.getInstance();
            feedback.setLikenessState(tipId, likenessState);
            if (likenessState == null) continue;
            feedback.scheduleFeedbackSending(tipId, likenessState);
        }
    }

    protected Action @NotNull [] createActions() {
        if (!this.myShowActions) {
            Action[] actionArray = new Action[]{this.getCancelAction()};
            if (actionArray == null) {
                TipDialog.$$$reportNull$$$0(2);
            }
            return actionArray;
        }
        if (Registry.is((String)"ide.show.open.button.in.tip.dialog")) {
            Action[] actionArray = new Action[]{new OpenTipsAction(), this.myTipPanel.myPreviousTipAction, this.myTipPanel.myNextTipAction, this.getCancelAction()};
            if (actionArray == null) {
                TipDialog.$$$reportNull$$$0(3);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.myTipPanel.myPreviousTipAction, this.myTipPanel.myNextTipAction, this.getCancelAction()};
        if (actionArray == null) {
            TipDialog.$$$reportNull$$$0(4);
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        return this.myTipPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPreferredFocusedComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortingResult";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/TipDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/TipDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private final class OpenTipsAction
    extends AbstractAction {
        private static final String LAST_OPENED_TIP_PATH = "last.opened.tip.path";

        OpenTipsAction() {
            super(IdeBundle.message((String)"action.open.tip", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualFile[] virtualFileArray;
            VirtualFile lastOpenedTip;
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createMultipleFilesNoJarsDescriptor().withExtensionFilter(FileTypeManager.getInstance().getStdFileType("HTML"));
            String value = propertiesComponent.getValue(LAST_OPENED_TIP_PATH);
            VirtualFile virtualFile = lastOpenedTip = value != null ? LocalFileSystem.getInstance().findFileByPath(value) : null;
            if (lastOpenedTip != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = lastOpenedTip;
            } else {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
            }
            VirtualFile[] pathToSelect = virtualFileArray;
            VirtualFile[] choose = FileChooserFactory.getInstance().createFileChooser(descriptor, null, (Component)TipDialog.this.myTipPanel).choose(null, pathToSelect);
            if (choose.length > 0) {
                ArrayList<TipAndTrickBean> tips = new ArrayList<TipAndTrickBean>();
                for (VirtualFile file : choose) {
                    TipAndTrickBean tip = new TipAndTrickBean();
                    tip.fileName = file.getPath();
                    tip.featureId = null;
                    tips.add(tip);
                    propertiesComponent.setValue(LAST_OPENED_TIP_PATH, file.getPath());
                }
                TipDialog.this.myTipPanel.setTips(TipsSortingResult.create(tips));
            }
        }
    }
}

