/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.IconManager;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.NullableFunction;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.impl.DomApplicationComponent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DomFileIconProvider
extends IconProvider {
    private final int gistVersion = DomApplicationComponent.getInstance().getCumulativeVersion(false);
    private final PsiFileGist<DomTag> DOM_FILE_DESCRIPTION = GistManager.getInstance().newPsiFileGist("DOM_FILE_DESCRIPTION", this.gistVersion, (DataExternalizer)new DomFileDescriptionTagExternalizer(), (NullableFunction)new NullableFunction<PsiFile, DomTag>(){

        @Nullable
        public DomTag fun(PsiFile file) {
            if (file instanceof XmlFile) {
                return 1.findDomFileDescription((XmlFile)file);
            }
            return null;
        }

        @Nullable
        private static DomTag findDomFileDescription(@NotNull XmlFile file) {
            PsiFile originalFile;
            if (file == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!((originalFile = file.getOriginalFile()) instanceof XmlFile)) {
                return null;
            }
            return (DomTag)AstLoadingFilter.forceAllowTreeLoading((PsiFile)originalFile, () -> {
                DomFileDescription<?> description = DomManager.getDomManager(originalFile.getProject()).getDomFileDescription((XmlFile)originalFile);
                if (description != null) {
                    return new DomTag(description.getRootTagName(), description.getRootElementClass().getName());
                }
                return null;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/xml/DomFileIconProvider$1", "findDomFileDescription"));
        }
    });

    DomFileIconProvider() {
    }

    public boolean isDumbAware() {
        return true;
    }

    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            DomFileIconProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)element;
            DomTag tag = (DomTag)this.DOM_FILE_DESCRIPTION.getFileData((PsiFile)xmlFile);
            if (tag == null) {
                return null;
            }
            DomFileDescription<?> restored = DomFileIconProvider.restoreDomFileDescription(tag);
            if (restored == null) {
                return null;
            }
            Icon fileIcon = restored.getFileIcon(xmlFile, flags);
            if (fileIcon != null) {
                return IconManager.getInstance().createLayeredIcon((Iconable)element, fileIcon, ElementBase.transformFlags((PsiElement)element, (int)flags));
            }
        }
        return null;
    }

    @Nullable
    private static DomFileDescription<?> restoreDomFileDescription(@NotNull DomTag tag) {
        if (tag == null) {
            DomFileIconProvider.$$$reportNull$$$0(1);
        }
        Set<DomFileDescription<?>> descriptionsForTag = DomApplicationComponent.getInstance().getFileDescriptions(tag.rootTagName());
        for (DomFileDescription<?> description : descriptionsForTag) {
            if (!tag.rootElementClass().equals(description.getRootElementClass().getName())) continue;
            return description;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/xml/DomFileIconProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreDomFileDescription";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DomFileDescriptionTagExternalizer
    implements DataExternalizer<DomTag> {
        private DomFileDescriptionTagExternalizer() {
        }

        public void save(@NotNull DataOutput out, DomTag value) throws IOException {
            if (out == null) {
                DomFileDescriptionTagExternalizer.$$$reportNull$$$0(0);
            }
            out.writeUTF(value.rootTagName());
            out.writeUTF(value.rootElementClass());
        }

        public DomTag read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                DomFileDescriptionTagExternalizer.$$$reportNull$$$0(1);
            }
            String rootTagName = in.readUTF();
            String rootElementClass = in.readUTF();
            return new DomTag(rootTagName, rootElementClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/xml/DomFileIconProvider$DomFileDescriptionTagExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record DomTag(@NotNull String rootTagName, @NotNull String rootElementClass) {
        @NotNull
        private final String rootTagName;
        @NotNull
        private final String rootElementClass;

        private DomTag(@NotNull String rootTagName, @NotNull String rootElementClass) {
            if (rootTagName == null) {
                DomTag.$$$reportNull$$$0(0);
            }
            if (rootElementClass == null) {
                DomTag.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public String rootTagName() {
            String string = this.rootTagName;
            if (string == null) {
                DomTag.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String rootElementClass() {
            String string = this.rootElementClass;
            if (string == null) {
                DomTag.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootTagName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootElementClass";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xml/DomFileIconProvider$DomTag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xml/DomFileIconProvider$DomTag";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rootTagName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rootElementClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

