/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.bidi.support;

import com.ibm.icu.text.Bidi;
import com.ibm.icu.text.BidiRun;
import com.openhtmltopdf.bidi.BidiSplitter;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.bidi.BidiTextRun;

public class ICUBidiSplitter
implements BidiSplitter {
    private Bidi bidi = new Bidi();

    @Override
    public void setParagraph(String paragraph, byte defaultDirection) {
        this.bidi.setPara(paragraph, defaultDirection, null);
    }

    @Override
    public int countTextRuns() {
        return this.bidi.countRuns();
    }

    @Override
    public BidiTextRun getVisualRun(int runIndex) {
        BidiRun run = this.bidi.getVisualRun(runIndex);
        BidiTextRun textRun = new BidiTextRun(run.getStart(), run.getLength(), run.getDirection());
        return textRun;
    }

    @Override
    public byte getBaseDirection(String paragraph) {
        return Bidi.getBaseDirection((CharSequence)paragraph);
    }

    public static class ICUBidiSplitterFactory
    implements BidiSplitterFactory {
        @Override
        public BidiSplitter createBidiSplitter() {
            return new ICUBidiSplitter();
        }
    }
}

