"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLRoutesService = void 0;
exports.registerMLRoutes = registerMLRoutes;
var _configSchema = require("@osd/config-schema");
var _common = require("../../common");
var _helpers = require("./helpers");
var _helpers2 = require("../utils/helpers");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
/**
 * Server-side routes to process ml-plugin-related node API calls and execute the
 * corresponding API calls against the OpenSearch cluster.
 */
function registerMLRoutes(router, mlRoutesService) {
  router.post({
    path: _common.SEARCH_MODELS_NODE_API_PATH,
    validate: {
      body: _configSchema.schema.any()
    }
  }, mlRoutesService.searchModels);
  router.post({
    path: `${_common.BASE_NODE_API_PATH}/{data_source_id}/model/search`,
    validate: {
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        data_source_id: _configSchema.schema.string()
      })
    }
  }, mlRoutesService.searchModels);
  router.post({
    path: _common.SEARCH_CONNECTORS_NODE_API_PATH,
    validate: {
      body: _configSchema.schema.any()
    }
  }, mlRoutesService.searchConnectors);
  router.post({
    path: `${_common.BASE_NODE_API_PATH}/{data_source_id}/connector/search`,
    validate: {
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        data_source_id: _configSchema.schema.string()
      })
    }
  }, mlRoutesService.searchConnectors);
}
class MLRoutesService {
  constructor(client, dataSourceEnabled) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    _defineProperty(this, "searchModels", async (context, req, res) => {
      const body = req.body;
      try {
        const {
          data_source_id = ''
        } = req.params;
        const callWithRequest = (0, _helpers2.getClientBasedOnDataSource)(context, this.dataSourceEnabled, req, data_source_id, this.client);
        const modelsResponse = await callWithRequest('mlClient.searchModels', {
          body
        });
        const modelHits = modelsResponse.hits.hits;
        const modelDict = (0, _helpers.getModelsFromResponses)(modelHits);
        return res.ok({
          body: {
            models: modelDict
          }
        });
      } catch (err) {
        return (0, _helpers.generateCustomError)(res, err);
      }
    });
    _defineProperty(this, "searchConnectors", async (context, req, res) => {
      const body = req.body;
      try {
        const {
          data_source_id = ''
        } = req.params;
        const callWithRequest = (0, _helpers2.getClientBasedOnDataSource)(context, this.dataSourceEnabled, req, data_source_id, this.client);
        const connectorsResponse = await callWithRequest('mlClient.searchConnectors', {
          body
        });
        const connectorHits = connectorsResponse.hits.hits;
        const connectorDict = (0, _helpers.getConnectorsFromResponses)(connectorHits);
        return res.ok({
          body: {
            connectors: connectorDict
          }
        });
      } catch (err) {
        return (0, _helpers.generateCustomError)(res, err);
      }
    });
    this.client = client;
    this.dataSourceEnabled = dataSourceEnabled;
  }
}
exports.MLRoutesService = MLRoutesService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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