"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OllyChatService = void 0;
var _constants = require("../../utils/constants");
var _get_agent = require("../../routes/get_agent");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
const MEMORY_ID_FIELD = 'memory_id';
const INTERACTION_ID_FIELDS = ['parent_message_id', 'parent_interaction_id'];
class OllyChatService {
  constructor(opensearchClientTransport) {
    this.opensearchClientTransport = opensearchClientTransport;
  }
  async getRootAgent() {
    return await (0, _get_agent.getAgentIdByConfigName)(_constants.ROOT_AGENT_CONFIG_ID, this.opensearchClientTransport);
  }
  async requestAgentRun(payload) {
    if (payload.memory_id) {
      OllyChatService.abortControllers.set(payload.memory_id, new AbortController());
    }
    const rootAgentId = await this.getRootAgent();
    return await this.callExecuteAgentAPI(payload, rootAgentId);
  }
  async callExecuteAgentAPI(payload, rootAgentId) {
    try {
      var _agentFrameworkRespon;
      const agentFrameworkResponse = await this.opensearchClientTransport.request({
        method: 'POST',
        path: `${_constants.ML_COMMONS_BASE_API}/agents/${rootAgentId}/_execute`,
        body: {
          parameters: payload
        }
      }, {
        /**
         * It is time-consuming for LLM to generate final answer
         * Give it a large timeout window
         */
        requestTimeout: 5 * 60 * 1000,
        /**
         * Do not retry
         */
        maxRetries: 0
      });
      const outputBody = (_agentFrameworkRespon = agentFrameworkResponse.body.inference_results) === null || _agentFrameworkRespon === void 0 || (_agentFrameworkRespon = _agentFrameworkRespon[0]) === null || _agentFrameworkRespon === void 0 ? void 0 : _agentFrameworkRespon.output;
      const conversationIdItem = outputBody === null || outputBody === void 0 ? void 0 : outputBody.find(item => item.name === MEMORY_ID_FIELD);
      const interactionIdItem = outputBody === null || outputBody === void 0 ? void 0 : outputBody.find(item => INTERACTION_ID_FIELDS.includes(item.name));
      return {
        /**
         * Interactions will be stored in Agent framework,
         * thus we do not need to return the latest message back.
         */
        messages: [],
        conversationId: (conversationIdItem === null || conversationIdItem === void 0 ? void 0 : conversationIdItem.result) || '',
        interactionId: (interactionIdItem === null || interactionIdItem === void 0 ? void 0 : interactionIdItem.result) || ''
      };
    } catch (error) {
      throw error;
    } finally {
      if (payload.memory_id) {
        OllyChatService.abortControllers.delete(payload.memory_id);
      }
    }
  }
  async requestLLM(payload) {
    var _input$context;
    const {
      input,
      conversationId
    } = payload;
    let llmInput = input.content;
    if ((_input$context = input.context) !== null && _input$context !== void 0 && _input$context.content) {
      var _input$context2;
      llmInput = `Based on the context: ${(_input$context2 = input.context) === null || _input$context2 === void 0 ? void 0 : _input$context2.content}, answer question: ${input.content}`;
    }
    const parametersPayload = {
      question: llmInput,
      verbose: false
    };
    if (input.promptPrefix) {
      parametersPayload['prompt.prefix'] = input.promptPrefix;
    }
    if (conversationId) {
      parametersPayload.memory_id = conversationId;
    }
    return await this.requestAgentRun(parametersPayload);
  }
  async regenerate(payload) {
    const {
      conversationId,
      interactionId
    } = payload;
    const parametersPayload = {
      memory_id: conversationId,
      regenerate_interaction_id: interactionId,
      verbose: false
    };
    return await this.requestAgentRun(parametersPayload);
  }
  abortAgentExecution(conversationId) {
    if (OllyChatService.abortControllers.has(conversationId)) {
      var _OllyChatService$abor;
      (_OllyChatService$abor = OllyChatService.abortControllers.get(conversationId)) === null || _OllyChatService$abor === void 0 || _OllyChatService$abor.abort();
    }
  }
}
exports.OllyChatService = OllyChatService;
_defineProperty(OllyChatService, "abortControllers", new Map());
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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