"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AssistantPluginSetup", {
  enumerable: true,
  get: function () {
    return _types.AssistantPluginSetup;
  }
});
Object.defineProperty(exports, "AssistantPluginStart", {
  enumerable: true,
  get: function () {
    return _types.AssistantPluginStart;
  }
});
Object.defineProperty(exports, "MessageParser", {
  enumerable: true,
  get: function () {
    return _types.MessageParser;
  }
});
exports.plugin = exports.config = void 0;
var _plugin = require("./plugin");
var _config = require("../common/types/config");
var _types = require("./types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const config = exports.config = {
  exposeToBrowser: {
    chat: true,
    incontextInsight: true,
    next: true,
    text2viz: true,
    alertInsight: true,
    smartAnomalyDetector: true,
    branding: true
  },
  schema: _config.configSchema
};
const plugin = initContext => new _plugin.AssistantPlugin(initContext);
exports.plugin = plugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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