/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jhotdraw.gui.plaf.palette.PaletteLabelUI;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;

public class PaletteFontChooserPreviewPanel
extends JPanel {
    private JLabel previewLabel;

    public PaletteFontChooserPreviewPanel() {
        this.initComponents();
        this.previewLabel.setUI((LabelUI)PaletteLabelUI.createUI(this.previewLabel));
        this.previewLabel.setBackground(Color.WHITE);
        this.previewLabel.setForeground(Color.BLACK);
        this.previewLabel.setOpaque(true);
        this.setPreferredSize(new Dimension(100, 50));
        this.setMinimumSize(new Dimension(100, 50));
    }

    public void setSelectedFont(Font font) {
        if (font == null) {
            this.previewLabel.setText((String)PaletteLookAndFeel.getInstance().get("FontChooser.nothingSelected"));
            this.previewLabel.setFont(this.getFont());
        } else {
            this.previewLabel.setText(this.beautifyName(font.getFontName()));
            this.previewLabel.setFont(font.deriveFont(24.0f));
        }
    }

    private String beautifyName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = string.charAt(0);
        stringBuilder.append(c);
        for (int i = 1; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c != ' ' && c != '-' && Character.isUpperCase(c2) && !Character.isUpperCase(c) || Character.isDigit(c2) && !Character.isDigit(c)) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(c2);
            c = c2;
        }
        string = stringBuilder.toString();
        return string;
    }

    private void initComponents() {
        this.previewLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.previewLabel.setHorizontalAlignment(0);
        this.add((Component)this.previewLabel, "Center");
    }
}

