/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.StreamExecutorHelper;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class CloudSolrStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    protected String zkHost;
    protected String collection;
    protected ModifiableSolrParams params;
    protected Map<String, String> fieldMappings;
    protected StreamComparator comp;
    private boolean trace;
    protected transient Map<String, Tuple> eofTuples;
    protected transient List<TupleStream> solrStreams;
    protected transient TreeSet<TupleWrapper> tuples;
    protected transient StreamContext streamContext;

    protected CloudSolrStream() {
    }

    public CloudSolrStream(String zkHost, String collectionName, SolrParams params) throws IOException {
        this.init(collectionName, zkHost, params);
    }

    public CloudSolrStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter aliasExpression = factory.getNamedOperand(expression, "aliases");
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (expression.getParameters().size() != 1 + namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - unknown operands found", expression));
        }
        if (0 == namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        ModifiableSolrParams mParams = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("aliases")) continue;
            mParams.add(namedParam.getName(), new String[]{namedParam.getParameter().toString().trim()});
        }
        if (null != aliasExpression && aliasExpression.getParameter() instanceof StreamExpressionValue) {
            this.fieldMappings = new HashMap<String, String>();
            for (String mapping : ((StreamExpressionValue)aliasExpression.getParameter()).getValue().split(",")) {
                String[] parts = mapping.trim().split("=");
                if (2 != parts.length) {
                    throw new IOException(String.format(Locale.ROOT, "invalid expression %s - alias expected of the format origName=newName", expression));
                }
                this.fieldMappings.put(parts[0], parts[1]);
            }
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        this.init(collectionName, zkHost, (SolrParams)mParams);
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression("search");
        if (this.collection.indexOf(44) > -1) {
            expression.addParameter("\"" + this.collection + "\"");
        } else {
            expression.addParameter(this.collection);
        }
        for (Map.Entry param : this.params.getMap().entrySet()) {
            for (String val : (String[])param.getValue()) {
                expression.addParameter(new StreamExpressionNamedParameter((String)param.getKey(), val.replace("\"", "\\\"")));
            }
        }
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        if (null != this.fieldMappings && 0 != this.fieldMappings.size()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> mapping : this.fieldMappings.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(mapping.getKey());
                sb.append("=");
                sb.append(mapping.getValue());
            }
            expression.addParameter(new StreamExpressionNamedParameter("aliases", sb.toString()));
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName("search");
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        if (null != this.params) {
            ModifiableSolrParams mParams = new ModifiableSolrParams((SolrParams)this.params);
            child.setExpression(mParams.getMap().entrySet().stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), Arrays.toString((Object[])e.getValue()))).collect(Collectors.joining(",")));
        }
        explanation.addChild(child);
        return explanation;
    }

    void init(String collectionName, String zkHost, SolrParams params) throws IOException {
        this.zkHost = zkHost;
        this.collection = collectionName;
        this.params = new ModifiableSolrParams(params);
        if (params.get("q") == null) {
            throw new IOException("q param expected for search function");
        }
        if (params.getParams("fl") == null) {
            throw new IOException("fl param expected for search function");
        }
        String fls = String.join((CharSequence)",", params.getParams("fl"));
        if (params.getParams("sort") == null) {
            throw new IOException("sort param expected for search function");
        }
        String sorts = String.join((CharSequence)",", params.getParams("sort"));
        this.comp = this.parseComp(sorts, fls);
    }

    public void setFieldMappings(Map<String, String> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
    }

    @Override
    public void open() throws IOException {
        this.tuples = new TreeSet();
        this.solrStreams = new ArrayList<TupleStream>();
        this.eofTuples = Collections.synchronizedMap(new HashMap());
        this.constructStreams();
        this.openStreams();
    }

    public Map<String, Tuple> getEofTuples() {
        return this.eofTuples;
    }

    @Override
    public List<TupleStream> children() {
        return this.solrStreams;
    }

    private StreamComparator parseComp(String sort, String fl) throws IOException {
        String[] fls = fl.split(",");
        HashSet<String> fieldSet = new HashSet<String>();
        for (String f : fls) {
            fieldSet.add(f.trim());
        }
        String[] sorts = sort.split(",");
        StreamComparator[] comps = new StreamComparator[sorts.length];
        for (int i = 0; i < sorts.length; ++i) {
            String s = sorts[i];
            String[] spec = s.trim().split("\\s+");
            if (spec.length != 2) {
                throw new IOException("Invalid sort spec:" + s);
            }
            String fieldName = spec[0].trim();
            String order = spec[1].trim();
            if (!fieldSet.contains(spec[0])) {
                throw new IOException("Fields in the sort spec must be included in the field list:" + spec[0]);
            }
            if (null != this.fieldMappings && this.fieldMappings.containsKey(fieldName)) {
                fieldName = this.fieldMappings.get(fieldName);
            }
            comps[i] = new FieldComparator(fieldName, order.equalsIgnoreCase("asc") ? ComparatorOrder.ASCENDING : ComparatorOrder.DESCENDING);
        }
        if (comps.length > 1) {
            return new MultipleFieldComparator(comps);
        }
        return comps[0];
    }

    public static Slice[] getSlices(String collectionName, CloudSolrClient cloudSolrClient, boolean checkAlias) throws IOException {
        ClusterState clusterState;
        Slice[] slices;
        Stream<String> allCollections = Arrays.stream(collectionName.split(","));
        if (checkAlias) {
            allCollections = allCollections.flatMap(col -> cloudSolrClient.getClusterStateProvider().resolveAlias(col).stream());
        }
        if ((slices = (Slice[])allCollections.map(arg_0 -> CloudSolrStream.lambda$getSlices$2(clusterState = cloudSolrClient.getClusterState(), arg_0)).filter(Objects::nonNull).flatMap(docCol -> Arrays.stream(docCol.getActiveSlicesArr())).toArray(Slice[]::new)).length == 0) {
            throw new IOException("Slices not found for " + collectionName);
        }
        return slices;
    }

    protected void constructStreams() throws IOException {
        ModifiableSolrParams mParams = this.adjustParams(new ModifiableSolrParams((SolrParams)this.params));
        mParams.set("distrib", new String[]{"false"});
        try {
            Stream<SolrStream> streamOfSolrStream;
            if (this.streamContext != null && this.streamContext.get("shards") != null) {
                List<String> shards = CloudSolrStream.getShards(this.zkHost, this.collection, this.streamContext, (SolrParams)mParams);
                if (shards.isEmpty()) {
                    throw new IOException("No shards available from ZooKeeper: " + this.zkHost);
                }
                streamOfSolrStream = shards.stream().map(s -> new SolrStream((String)s, (SolrParams)mParams));
            } else {
                List<Replica> replicas = CloudSolrStream.getReplicas(this.zkHost, this.collection, this.streamContext, (SolrParams)mParams);
                if (replicas.isEmpty()) {
                    throw new IOException("No replicas available from ZooKeeper: " + this.zkHost);
                }
                streamOfSolrStream = replicas.stream().map(r -> new SolrStream(r.getBaseUrl(), (SolrParams)mParams, r.getCoreName()));
            }
            streamOfSolrStream.forEach(ss -> {
                if (this.streamContext != null) {
                    ss.setStreamContext(this.streamContext);
                    if (this.streamContext.isLocal()) {
                        ss.setDistrib(false);
                    }
                }
                ss.setFieldMappings(this.fieldMappings);
                this.solrStreams.add((TupleStream)ss);
            });
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void openStreams() throws IOException {
        List tasks = this.solrStreams.stream().map(s -> new StreamOpener((SolrStream)s, this.comp)).collect(Collectors.toUnmodifiableList());
        List results = StreamExecutorHelper.submitAllAndAwaitAggregatingExceptions(tasks, "CloudSolrStream").stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        this.tuples.addAll(results);
    }

    @Override
    public void close() throws IOException {
        if (this.solrStreams != null) {
            for (TupleStream solrStream : this.solrStreams) {
                solrStream.close();
            }
        }
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.comp;
    }

    @Override
    public Tuple read() throws IOException {
        return this._read();
    }

    protected Tuple _read() throws IOException {
        TupleWrapper tw = this.tuples.pollFirst();
        if (tw != null) {
            Tuple t = tw.getTuple();
            if (this.trace) {
                t.put("_COLLECTION_", this.collection);
            }
            if (tw.next()) {
                this.tuples.add(tw);
            }
            return t;
        }
        Tuple tuple = Tuple.EOF();
        if (this.trace) {
            tuple.put("_COLLECTION_", this.collection);
        }
        return tuple;
    }

    protected ModifiableSolrParams adjustParams(ModifiableSolrParams params) {
        return params;
    }

    private static /* synthetic */ DocCollection lambda$getSlices$2(ClusterState clusterState, String c) {
        return clusterState.getCollectionOrNull(c, true);
    }

    protected class StreamOpener
    implements Callable<TupleWrapper> {
        private final SolrStream stream;
        private final StreamComparator comp;

        public StreamOpener(SolrStream stream, StreamComparator comp) {
            this.stream = stream;
            this.comp = comp;
        }

        @Override
        public TupleWrapper call() throws Exception {
            this.stream.open();
            TupleWrapper wrapper = new TupleWrapper(this.stream, this.comp);
            if (wrapper.next()) {
                return wrapper;
            }
            return null;
        }
    }

    protected class TupleWrapper
    implements Comparable<TupleWrapper> {
        private Tuple tuple;
        private final SolrStream stream;
        private final StreamComparator comp;

        public TupleWrapper(SolrStream stream, StreamComparator comp) {
            this.stream = stream;
            this.comp = comp;
        }

        @Override
        public int compareTo(TupleWrapper w) {
            if (this == w) {
                return 0;
            }
            int i = this.comp.compare(this.tuple, w.tuple);
            if (i == 0) {
                return 1;
            }
            return i;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return Objects.hash(this.tuple);
        }

        public Tuple getTuple() {
            return this.tuple;
        }

        public boolean next() throws IOException {
            this.tuple = this.stream.read();
            if (this.tuple.EOF) {
                CloudSolrStream.this.eofTuples.put(this.stream.getBaseUrl(), this.tuple);
            }
            return !this.tuple.EOF;
        }
    }
}

