/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.impl.SolrZkClientTimeout;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.cloud.SolrZkClient;

public class ClusterTool
extends ToolBase {
    public ClusterTool() {
        this(CLIO.getOutStream());
    }

    public ClusterTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "cluster";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder().longOpt("property").hasArg().argName("PROPERTY").required(true).desc("Name of the Cluster property to apply the action to, such as: 'urlScheme'.").build(), Option.builder().longOpt("value").hasArg().argName("VALUE").required(false).desc("Set the property to this value.").build(), SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        String propertyName = cli.getOptionValue("property");
        String propertyValue = cli.getOptionValue("value");
        String zkHost = SolrCLI.getZkHost(cli);
        if (!ZkController.checkChrootPath(zkHost, true)) {
            throw new IllegalStateException("A chroot was specified in zkHost but the znode doesn't exist.");
        }
        try (SolrZkClient zkClient = new SolrZkClient.Builder().withUrl(zkHost).withTimeout(SolrZkClientTimeout.DEFAULT_ZK_CLIENT_TIMEOUT, TimeUnit.MILLISECONDS).build();){
            ClusterProperties props = new ClusterProperties(zkClient);
            try {
                props.setClusterProperty(propertyName, (Object)propertyValue);
            }
            catch (IOException ex) {
                throw new Exception("Unable to set the cluster property due to following error : " + ex.getLocalizedMessage());
            }
        }
    }
}

