/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Iterable;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPPublicKeyRingCollection
implements Iterable<PGPPublicKeyRing> {
    private Map pubRings = new HashMap();
    private List order = new ArrayList();

    private PGPPublicKeyRingCollection(Map map, List list) {
        this.pubRings = map;
        this.order = list;
    }

    public PGPPublicKeyRingCollection(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    public PGPPublicKeyRingCollection(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        Object object;
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream, keyFingerPrintCalculator);
        while ((object = pGPObjectFactory.nextObject()) != null) {
            if (!(object instanceof PGPPublicKeyRing)) {
                throw new PGPException(object.getClass().getName() + " found where PGPPublicKeyRing expected");
            }
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)object;
            Long l = new Long(pGPPublicKeyRing.getPublicKey().getKeyID());
            this.pubRings.put(l, pGPPublicKeyRing);
            this.order.add(l);
        }
    }

    public PGPPublicKeyRingCollection(Collection<PGPPublicKeyRing> collection) throws IOException, PGPException {
        for (PGPPublicKeyRing pGPPublicKeyRing : collection) {
            Long l = new Long(pGPPublicKeyRing.getPublicKey().getKeyID());
            this.pubRings.put(l, pGPPublicKeyRing);
            this.order.add(l);
        }
    }

    public int size() {
        return this.order.size();
    }

    public Iterator<PGPPublicKeyRing> getKeyRings() {
        return this.pubRings.values().iterator();
    }

    public Iterator<PGPPublicKeyRing> getKeyRings(String string) throws PGPException {
        return this.getKeyRings(string, false, false);
    }

    public Iterator<PGPPublicKeyRing> getKeyRings(String string, boolean bl) throws PGPException {
        return this.getKeyRings(string, bl, false);
    }

    public Iterator<PGPPublicKeyRing> getKeyRings(String string, boolean bl, boolean bl2) throws PGPException {
        Iterator<PGPPublicKeyRing> iterator = this.getKeyRings();
        ArrayList<PGPPublicKeyRing> arrayList = new ArrayList<PGPPublicKeyRing>();
        if (bl2) {
            string = Strings.toLowerCase((String)string);
        }
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = iterator.next();
            Iterator<String> iterator2 = pGPPublicKeyRing.getPublicKey().getUserIDs();
            while (iterator2.hasNext()) {
                String string2 = iterator2.next();
                if (bl2) {
                    string2 = Strings.toLowerCase((String)string2);
                }
                if (bl) {
                    if (string2.indexOf(string) <= -1) continue;
                    arrayList.add(pGPPublicKeyRing);
                    continue;
                }
                if (!string2.equals(string)) continue;
                arrayList.add(pGPPublicKeyRing);
            }
        }
        return arrayList.iterator();
    }

    public PGPPublicKey getPublicKey(long l) throws PGPException {
        Iterator<PGPPublicKeyRing> iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = iterator.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(l);
            if (pGPPublicKey == null) continue;
            return pGPPublicKey;
        }
        return null;
    }

    public PGPPublicKeyRing getPublicKeyRing(long l) throws PGPException {
        Long l2 = new Long(l);
        if (this.pubRings.containsKey(l2)) {
            return (PGPPublicKeyRing)this.pubRings.get(l2);
        }
        Iterator<PGPPublicKeyRing> iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = iterator.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(l);
            if (pGPPublicKey == null) continue;
            return pGPPublicKeyRing;
        }
        return null;
    }

    public PGPPublicKey getPublicKey(byte[] byArray) throws PGPException {
        Iterator<PGPPublicKeyRing> iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = iterator.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(byArray);
            if (pGPPublicKey == null) continue;
            return pGPPublicKey;
        }
        return null;
    }

    public PGPPublicKeyRing getPublicKeyRing(byte[] byArray) throws PGPException {
        Iterator<PGPPublicKeyRing> iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = iterator.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(byArray);
            if (pGPPublicKey == null) continue;
            return pGPPublicKeyRing;
        }
        return null;
    }

    public Iterator<PGPPublicKey> getKeysWithSignaturesBy(long l) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        Iterator<PGPPublicKeyRing> iterator = this.iterator();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = iterator.next();
            Iterator<PGPPublicKey> iterator2 = pGPPublicKeyRing.getKeysWithSignaturesBy(l);
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next());
            }
        }
        return arrayList.iterator();
    }

    public boolean contains(long l) throws PGPException {
        return this.getPublicKey(l) != null;
    }

    public boolean contains(byte[] byArray) throws PGPException {
        return this.getPublicKey(byArray) != null;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        Iterator iterator = this.order.iterator();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)this.pubRings.get(iterator.next());
            pGPPublicKeyRing.encode(bCPGOutputStream);
        }
    }

    public static PGPPublicKeyRingCollection addPublicKeyRing(PGPPublicKeyRingCollection pGPPublicKeyRingCollection, PGPPublicKeyRing pGPPublicKeyRing) {
        Long l = new Long(pGPPublicKeyRing.getPublicKey().getKeyID());
        if (pGPPublicKeyRingCollection.pubRings.containsKey(l)) {
            throw new IllegalArgumentException("Collection already contains a key with a keyID for the passed in ring.");
        }
        HashMap<Long, PGPPublicKeyRing> hashMap = new HashMap<Long, PGPPublicKeyRing>(pGPPublicKeyRingCollection.pubRings);
        ArrayList<Long> arrayList = new ArrayList<Long>(pGPPublicKeyRingCollection.order);
        hashMap.put(l, pGPPublicKeyRing);
        arrayList.add(l);
        return new PGPPublicKeyRingCollection(hashMap, arrayList);
    }

    public static PGPPublicKeyRingCollection removePublicKeyRing(PGPPublicKeyRingCollection pGPPublicKeyRingCollection, PGPPublicKeyRing pGPPublicKeyRing) {
        Long l = new Long(pGPPublicKeyRing.getPublicKey().getKeyID());
        if (!pGPPublicKeyRingCollection.pubRings.containsKey(l)) {
            throw new IllegalArgumentException("Collection does not contain a key with a keyID for the passed in ring.");
        }
        HashMap hashMap = new HashMap(pGPPublicKeyRingCollection.pubRings);
        ArrayList arrayList = new ArrayList(pGPPublicKeyRingCollection.order);
        hashMap.remove(l);
        for (int i = 0; i < arrayList.size(); ++i) {
            Long l2 = (Long)arrayList.get(i);
            if (l2.longValue() != l.longValue()) continue;
            arrayList.remove(i);
            break;
        }
        return new PGPPublicKeyRingCollection(hashMap, arrayList);
    }

    public Iterator<PGPPublicKeyRing> iterator() {
        return this.pubRings.values().iterator();
    }
}

