/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.text;

import org.pentaho.reporting.libraries.fonts.text.Spacing;

public final class Glyph {
    private static final int[] EMPTY_EXTRA_CHARS = new int[0];
    public static final int SPACE_CHAR = 0;
    public static final int LETTER = 1;
    private int codepoint;
    private int breakWeight;
    private int classification;
    private Spacing spacing;
    private int width;
    private int height;
    private int baseLine;
    private int kerning;
    private int[] extraChars;

    public Glyph(int n, int n2, int n3, Spacing spacing, int n4, int n5, int n6, int n7, int[] nArray) {
        this.spacing = spacing == null ? Spacing.EMPTY_SPACING : spacing;
        this.extraChars = nArray == null ? EMPTY_EXTRA_CHARS : (int[])nArray.clone();
        this.baseLine = n6;
        this.codepoint = n;
        this.breakWeight = n2;
        this.width = n4;
        this.height = n5;
        this.classification = n3;
        this.kerning = n7;
    }

    public int getClassification() {
        return this.classification;
    }

    public int[] getExtraChars() {
        return (int[])this.extraChars.clone();
    }

    public int getBaseLine() {
        return this.baseLine;
    }

    public int getCodepoint() {
        return this.codepoint;
    }

    public int getBreakWeight() {
        return this.breakWeight;
    }

    public Spacing getSpacing() {
        return this.spacing;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getKerning() {
        return this.kerning;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Glyph glyph = (Glyph)object;
        if (this.breakWeight != glyph.breakWeight) {
            return false;
        }
        if (this.codepoint != glyph.codepoint) {
            return false;
        }
        if (this.height != glyph.height) {
            return false;
        }
        if (this.kerning != glyph.kerning) {
            return false;
        }
        if (this.width != glyph.width) {
            return false;
        }
        return this.spacing.equals((Object)glyph.spacing);
    }

    public int hashCode() {
        int n = this.codepoint;
        n = 29 * n + this.breakWeight;
        n = 29 * n + this.spacing.hashCode();
        n = 29 * n + this.width;
        n = 29 * n + this.height;
        n = 29 * n + this.kerning;
        return n;
    }

    public String toString() {
        return this.getClass().getName() + "={codepoint='" + (char)(this.codepoint & 0xFFFF) + ", extra-chars=" + this.extraChars.length + '}';
    }
}

