/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.Engine;
import io.quarkus.qute.ErrorCode;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Results;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateException;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class LoopSectionHelper
implements SectionHelper {
    private static final String DEFAULT_ALIAS = "it";
    private static final String ELSE = "else";
    private static final String ALIAS = "alias";
    private static final String ITERABLE = "iterable";
    private final String alias;
    private final Expression iterable;
    private final SectionBlock elseBlock;
    private final Engine engine;
    private final String metadataPrefix;

    LoopSectionHelper(SectionHelperFactory.SectionInitContext context, String metadataPrefix) {
        this.alias = context.getParameterOrDefault(ALIAS, DEFAULT_ALIAS);
        this.metadataPrefix = Factory.prefixValue(this.alias, metadataPrefix);
        this.iterable = Objects.requireNonNull(context.getExpression(ITERABLE));
        this.elseBlock = context.getBlock(ELSE);
        this.engine = context.getEngine();
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        return context.resolutionContext().evaluate(this.iterable).thenCompose(it -> {
            if (it == null) {
                return ResultNode.NOOP;
            }
            ArrayList<CompletionStage<ResultNode>> results = new ArrayList<CompletionStage<ResultNode>>(LoopSectionHelper.extractSize(it));
            Iterator<?> iterator = this.extractIterator(it);
            int idx = 0;
            while (iterator.hasNext()) {
                results.add(this.nextElement(iterator.next(), idx++, iterator.hasNext(), context));
            }
            if (results.isEmpty()) {
                if (this.elseBlock != null) {
                    return context.execute(this.elseBlock, context.resolutionContext());
                }
                return ResultNode.NOOP;
            }
            if (results.size() == 1) {
                return (CompletionStage)results.get(0);
            }
            return Results.process(results);
        });
    }

    private static int extractSize(Object it) {
        if (it instanceof AbstractCollection) {
            AbstractCollection collection = (AbstractCollection)it;
            return collection.size();
        }
        if (it instanceof AbstractMap) {
            AbstractMap map = (AbstractMap)it;
            return map.size();
        }
        if (it.getClass().isArray()) {
            return Array.getLength(it);
        }
        if (it instanceof Integer) {
            Integer integer = (Integer)it;
            return integer;
        }
        if (it instanceof Long) {
            Long longValue = (Long)it;
            return longValue.intValue();
        }
        if (it instanceof Collection) {
            Collection collection = (Collection)it;
            return collection.size();
        }
        if (it instanceof Map) {
            Map map = (Map)it;
            return map.size();
        }
        return 10;
    }

    private Iterator<?> extractIterator(Object it) {
        if (it instanceof AbstractCollection) {
            AbstractCollection col = (AbstractCollection)it;
            return col.iterator();
        }
        if (it instanceof AbstractMap) {
            AbstractMap map = (AbstractMap)it;
            return map.entrySet().iterator();
        }
        if (it instanceof Integer) {
            Integer integer = (Integer)it;
            return IntStream.rangeClosed(1, integer).iterator();
        }
        if (it instanceof Long) {
            Long longValue = (Long)it;
            return LongStream.rangeClosed(1L, longValue).iterator();
        }
        if (it.getClass().isArray()) {
            int length = Array.getLength(it);
            ArrayList<Object> elements = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                elements.add(Array.get(it, i));
            }
            return elements.iterator();
        }
        if (it instanceof Iterable) {
            Iterable iterable = (Iterable)it;
            return iterable.iterator();
        }
        if (it instanceof Iterator) {
            Iterator iterator = (Iterator)it;
            return iterator;
        }
        if (it instanceof Map) {
            Map map = (Map)it;
            return map.entrySet().iterator();
        }
        if (it instanceof Stream) {
            Stream stream = (Stream)it;
            return ((Stream)stream.sequential()).iterator();
        }
        TemplateException.Builder builder = Results.isNotFound(it) ? this.engine.error("Iteration error - \\{{expr}} not found, use \\{{expr}.orEmpty} to ignore this error").code(Code.ITERABLE_NOT_FOUND).argument("expr", this.iterable.toOriginalString()).origin(this.iterable.getOrigin()) : this.engine.error("Iteration error - \\{{expr}} resolved to [{clazz}] which is not iterable").code(Code.NOT_AN_ITERABLE).argument("expr", this.iterable.toOriginalString()).argument("clazz", it.getClass().getName()).origin(this.iterable.getOrigin());
        throw builder.build();
    }

    CompletionStage<ResultNode> nextElement(Object element, int index, boolean hasNext, SectionHelper.SectionResolutionContext context) {
        ResolutionContext child = context.resolutionContext().createChild(new IterationElement(element, index, hasNext), null);
        return context.execute(child);
    }

    public static class Factory
    implements SectionHelperFactory<LoopSectionHelper> {
        public static final String ITERATION_METADATA_PREFIX_ALIAS_QM = "<alias?>";
        public static final String ITERATION_METADATA_PREFIX_ALIAS_UNDERSCORE = "<alias_>";
        public static final String ITERATION_METADATA_PREFIX_NONE = "<none>";
        public static final String HINT_ELEMENT = "<loop-element>";
        public static final String HINT_PREFIX = "<loop#";
        private static final String IN = "in";
        private final String metadataPrefix;

        public Factory() {
            this(ITERATION_METADATA_PREFIX_ALIAS_UNDERSCORE);
        }

        public Factory(String metadataPrefix) {
            Objects.requireNonNull(metadataPrefix, "Iteration metadata must not be null");
            this.metadataPrefix = metadataPrefix.isBlank() || metadataPrefix.equals(ITERATION_METADATA_PREFIX_NONE) ? null : metadataPrefix;
        }

        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of("for", "each");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(LoopSectionHelper.ALIAS, "$empty$").addParameter(IN, "$empty$").addParameter(Parameter.builder(LoopSectionHelper.ITERABLE).optional()).build();
        }

        @Override
        public List<String> getBlockLabels() {
            return Collections.singletonList(LoopSectionHelper.ELSE);
        }

        @Override
        public LoopSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            return new LoopSectionHelper(context, this.metadataPrefix);
        }

        @Override
        public Scope initializeBlock(Scope previousScope, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                String iterable = block.getParameters().get(LoopSectionHelper.ITERABLE);
                if (iterable == null) {
                    iterable = "this";
                }
                previousScope.setLastPartHint(HINT_ELEMENT);
                Expression iterableExpr = block.addExpression(LoopSectionHelper.ITERABLE, iterable);
                previousScope.setLastPartHint(null);
                String alias = block.getParameters().get(LoopSectionHelper.ALIAS);
                if (iterableExpr.hasTypeInfo()) {
                    alias = alias.equals("$empty$") ? LoopSectionHelper.DEFAULT_ALIAS : alias;
                    Scope newScope = new Scope(previousScope);
                    newScope.putBinding(alias, alias + HINT_PREFIX + iterableExpr.getGeneratedId() + ">");
                    String prefix = Factory.prefixValue(alias, this.metadataPrefix);
                    this.putMetadataBinding(newScope, prefix, "count", Integer.class.getName());
                    this.putMetadataBinding(newScope, prefix, "index", Integer.class.getName());
                    this.putMetadataBinding(newScope, prefix, "indexParity", String.class.getName());
                    this.putMetadataBinding(newScope, prefix, "hasNext", Boolean.class.getName());
                    this.putMetadataBinding(newScope, prefix, "isLast", Boolean.class.getName());
                    this.putMetadataBinding(newScope, prefix, "isFirst", Boolean.class.getName());
                    this.putMetadataBinding(newScope, prefix, "odd", Boolean.class.getName());
                    this.putMetadataBinding(newScope, prefix, "isOdd", Boolean.class.getName());
                    this.putMetadataBinding(newScope, prefix, "even", Boolean.class.getName());
                    this.putMetadataBinding(newScope, prefix, "isEven", Boolean.class.getName());
                    return newScope;
                }
                Scope newScope = new Scope(previousScope);
                newScope.putBinding(alias, null);
                return newScope;
            }
            return previousScope;
        }

        private void putMetadataBinding(Scope scope, String prefix, String name, String typeName) {
            scope.putBinding((String)(prefix != null ? prefix + name : name), Expressions.typeInfoFrom(typeName) + "<metadata>");
        }

        static String prefixValue(String alias, String metadataPrefix) {
            if (metadataPrefix == null || ITERATION_METADATA_PREFIX_NONE.equals(metadataPrefix)) {
                return null;
            }
            if (ITERATION_METADATA_PREFIX_ALIAS_UNDERSCORE.equals(metadataPrefix)) {
                return alias + "_";
            }
            if (ITERATION_METADATA_PREFIX_ALIAS_QM.equals(metadataPrefix)) {
                return alias + "?";
            }
            return metadataPrefix;
        }
    }

    static enum Code implements ErrorCode
    {
        ITERABLE_NOT_FOUND,
        NOT_AN_ITERABLE;


        @Override
        public String getName() {
            return "LOOP_" + this.name();
        }
    }

    class IterationElement
    implements Mapper {
        static final CompletedStage<Object> EVEN = CompletedStage.of("even");
        static final CompletedStage<Object> ODD = CompletedStage.of("odd");
        final CompletedStage<Object> element;
        final int index;
        final boolean hasNext;

        public IterationElement(Object element, int index, boolean hasNext) {
            this.element = CompletedStage.of(element);
            this.index = index;
            this.hasNext = hasNext;
        }

        @Override
        public CompletionStage<Object> getAsync(String key) {
            if (LoopSectionHelper.this.alias.equals(key)) {
                return this.element;
            }
            if (LoopSectionHelper.this.metadataPrefix != null && !key.startsWith(LoopSectionHelper.this.metadataPrefix)) {
                return Results.notFound(key);
            }
            int keyStartIndex = LoopSectionHelper.this.metadataPrefix == null ? 0 : LoopSectionHelper.this.metadataPrefix.length();
            switch (key.length() - keyStartIndex) {
                case 3: {
                    if (key.indexOf("odd", keyStartIndex) == keyStartIndex) {
                        return (this.index + 1) % 2 != 0 ? Results.TRUE : Results.FALSE;
                    }
                    return Results.notFound(key);
                }
                case 4: {
                    if (key.indexOf("even", keyStartIndex) == keyStartIndex) {
                        return (this.index + 1) % 2 == 0 ? Results.TRUE : Results.FALSE;
                    }
                    return Results.notFound(key);
                }
                case 5: {
                    if (key.indexOf("count", keyStartIndex) == keyStartIndex) {
                        return CompletedStage.of(this.index + 1);
                    }
                    if (key.indexOf("index", keyStartIndex) == keyStartIndex) {
                        return CompletedStage.of(this.index);
                    }
                    if (key.indexOf("isOdd", keyStartIndex) == keyStartIndex) {
                        return (this.index + 1) % 2 != 0 ? Results.TRUE : Results.FALSE;
                    }
                    return Results.notFound(key);
                }
                case 6: {
                    if (key.indexOf("isEven", keyStartIndex) == keyStartIndex) {
                        return (this.index + 1) % 2 == 0 ? Results.TRUE : Results.FALSE;
                    }
                    if (key.indexOf("isLast", keyStartIndex) == keyStartIndex) {
                        return this.hasNext ? Results.FALSE : Results.TRUE;
                    }
                    return Results.notFound(key);
                }
                case 7: {
                    if (key.indexOf("hasNext", keyStartIndex) == keyStartIndex) {
                        return this.hasNext ? Results.TRUE : Results.FALSE;
                    }
                    if (key.indexOf("isFirst", keyStartIndex) == keyStartIndex) {
                        return this.index == 0 ? Results.TRUE : Results.FALSE;
                    }
                    return Results.notFound(key);
                }
                case 11: {
                    if (key.indexOf("indexParity", keyStartIndex) == keyStartIndex) {
                        return (this.index + 1) % 2 == 0 ? EVEN : ODD;
                    }
                    return Results.notFound(key);
                }
            }
            return Results.notFound(key);
        }

        @Override
        public Set<String> mappedKeys() {
            if (LoopSectionHelper.this.metadataPrefix != null) {
                return Set.of(LoopSectionHelper.this.alias, LoopSectionHelper.this.metadataPrefix + "count", LoopSectionHelper.this.metadataPrefix + "index", LoopSectionHelper.this.metadataPrefix + "indexParity", LoopSectionHelper.this.metadataPrefix + "hasNext", LoopSectionHelper.this.metadataPrefix + "isLast", LoopSectionHelper.this.metadataPrefix + "isFirst", LoopSectionHelper.this.metadataPrefix + "isOdd", LoopSectionHelper.this.metadataPrefix + "odd", LoopSectionHelper.this.metadataPrefix + "isEven", LoopSectionHelper.this.metadataPrefix + "even");
            }
            return Set.of(LoopSectionHelper.this.alias, "count", "index", "indexParity", "hasNext", "isLast", "isFirst", "isOdd", "odd", "isEven", "even");
        }
    }
}

