/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import javax.annotation.Nullable;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationState;
import org.gradle.internal.operations.DefaultBuildOperationRunner;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationProgressDetails;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.internal.time.Clock;

public class BuildOperationProgressEventListenerAdapter
implements DefaultBuildOperationRunner.BuildOperationExecutionListener {
    private final BuildOperationListener buildOperationListener;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final Clock clock;
    private ProgressLogger progressLogger;
    private ProgressLogger statusProgressLogger;

    public BuildOperationProgressEventListenerAdapter(BuildOperationListener buildOperationListener, ProgressLoggerFactory progressLoggerFactory, Clock clock) {
        this.buildOperationListener = buildOperationListener;
        this.progressLoggerFactory = progressLoggerFactory;
        this.clock = clock;
    }

    public void start(BuildOperationDescriptor descriptor, BuildOperationState operationState) {
        this.buildOperationListener.started(descriptor, new OperationStartEvent(operationState.getStartTime()));
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(DefaultBuildOperationRunner.class, descriptor);
        this.progressLogger = progressLogger.start(descriptor.getDisplayName(), descriptor.getProgressDisplayName());
    }

    public void progress(BuildOperationDescriptor descriptor, String status) {
        if (this.statusProgressLogger == null) {
            this.statusProgressLogger = this.progressLoggerFactory.newOperation(DefaultBuildOperationRunner.class, this.progressLogger);
            this.statusProgressLogger.start(descriptor.getDisplayName(), status);
        } else {
            this.statusProgressLogger.progress(status);
        }
    }

    public void progress(BuildOperationDescriptor descriptor, long progress, long total, String units, String status) {
        this.progress(descriptor, status);
        this.buildOperationListener.progress(descriptor.getId(), new OperationProgressEvent(this.clock.getCurrentTime(), (Object)new OperationProgressDetails(progress, total, units)));
    }

    public void stop(BuildOperationDescriptor descriptor, BuildOperationState operationState, @Nullable BuildOperationState parent, DefaultBuildOperationRunner.ReadableBuildOperationContext context) {
        if (this.statusProgressLogger != null) {
            this.statusProgressLogger.completed();
        }
        this.progressLogger.completed(context.getStatus(), context.getFailure() != null);
        this.buildOperationListener.finished(descriptor, new OperationFinishEvent(operationState.getStartTime(), this.clock.getCurrentTime(), context.getFailure(), context.getResult()));
    }

    public void close(BuildOperationDescriptor descriptor, BuildOperationState operationState) {
    }
}

