/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.dispatch;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;

public class ReflectionDispatch
implements Dispatch<MethodInvocation> {
    private final Object target;

    public ReflectionDispatch(Object target) {
        this.target = target;
    }

    @Override
    public void dispatch(MethodInvocation message) {
        try {
            Method method = message.getMethod();
            method.setAccessible(true);
            method.invoke(this.target, message.getArguments());
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
        }
        catch (Throwable throwable) {
            throw UncheckedException.throwAsUncheckedException((Throwable)throwable);
        }
    }
}

