---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              fractions, symbole de fraction, barre de fraction, 
              symbole de division, opérateurs mathématiques, obèle
---

# Comment obtenir une fraction ?

## Avec le trait de fraction

LaTeX propose la commande mathématique `\frac{⟨numérateur⟩}{⟨dénominateur⟩}`.
Voici un exemple qui montre que la fraction présente moins 
d'espacement vertical lorsqu'elle se retrouve au sein d'une ligne de texte.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Une fraction en formule :
\[\frac{\alpha}{6 + \sqrt{2}} = \frac{1+\sqrt{2}}{1+\frac{\beta-1}{4}}\]
ou dans le texte $\frac{\alpha}{6 + \sqrt{2}}$ afin d'illustrer la manière 
dont la fraction est compressée dans le texte.
\end{document}
```

La notation fractionnaire dispose d'une variante pour des fractions 
très simples, le trait de fraction oblique, permettant une présentation 
plus agréable dans un texte. Cette variante est détaillée dans la question 
"[](/4_domaines_specialises/mathematiques/structures/fractions/composer_le_ratio_a_sur_b_avec_des_espaces_corrects)".


## Avec un obèle

La notation fractionnaire est la plus courante, mais n'oublions pas 
qu'il existe une autre notation "en ligne", avec un [obèle](wpfr:Obèle) :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\large $6 \div 3 = 2$
\end{document}
```


:::{sources}
- [Is there a way to produce this division symbol ? ÷](https://tex.stackexchange.com/q/108035),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::