# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.security import SecurityCenter

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-security
# USAGE
    python create_update_gcp_credentials_connector_subscription_example.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SecurityCenter(
        credential=DefaultAzureCredential(),
        subscription_id="20ff7fc3-e762-44dd-bd96-b71116dcdc23",
    )

    response = client.connectors.create_or_update(
        connector_name="gcp_dev",
        connector_setting={
            "properties": {
                "authenticationDetails": {
                    "authProviderX509CertUrl": "https://www.googleapis.com/oauth2/v1/certs",
                    "authUri": "https://accounts.google.com/o/oauth2/auth",
                    "authenticationType": "gcpCredentials",
                    "clientEmail": "asc-135@asc-project-1234.iam.gserviceaccount.com",
                    "clientId": "105889053725632919854",
                    "clientX509CertUrl": "https://www.googleapis.com/robot/v1/metadata/x509/asc-135%40asc-project-1234.iam.gserviceaccount.com",
                    "organizationId": "AscDemoOrg",
                    "privateKey": "******",
                    "privateKeyId": "6efg587hra2568as34d22326b044cc20dc2af",
                    "projectId": "asc-project-1234",
                    "tokenUri": "https://oauth2.googleapis.com/token",
                    "type": "service_account",
                },
                "hybridComputeSettings": {"autoProvision": "Off"},
            }
        },
    )
    print(response)


# x-ms-original-file: specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/Connectors/CreateUpdateGcpCredentialsConnectorSubscription_example.json
if __name__ == "__main__":
    main()
