/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi;

import com.sourceforge.knecs.dsm.dsi.DSIProperty;
import com.sourceforge.knecs.dsm.dsi.InternalServerErrorException;
import com.sourceforge.knecs.dsm.dsi.StatusException;
import com.sourceforge.knecs.dsm.util.DAVResource;
import com.sourceforge.knecs.dsm.util.ResourceList;
import com.sourceforge.knecs.security.auth.AuthEvent;
import com.sourceforge.knecs.security.auth.AuthEventListener;
import com.sourceforge.knecs.security.auth.ExplicitAuthListener;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import com.sourceforge.knecs.util.UrlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.util.QName;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.methods.MkcolMethod;
import org.apache.webdav.lib.methods.PropPatchMethod;
import org.apache.webdav.lib.methods.SearchMethod;
import org.apache.webdav.lib.methods.SemanticSearchMethod;
import org.apache.webdav.lib.properties.AclProperty;

public class DSI {
    public static final int DEPTH_0 = 0;
    public static final int DEPTH_1 = 1;
    public static final int DEPTH_INFINITY = Integer.MAX_VALUE;
    public static final int SERVERERROR_MIN = 500;
    public static final int SERVERERROR_MAX = 599;
    public static final int DEADLOCK_CODE = 508;
    public static final int IOEX_CODE = 600;
    public static final int UNK_CODE = 601;
    public static final int ILLARG_CODE = 602;
    private Logger mLogger = null;
    private WebdavResource mWebdavResource = null;
    private String mServer = "";
    private String mPath = "";
    private String mQuery = "";
    private AuthEventListener mAuthListener = null;
    private AuthEvent mAE = new AuthEvent();

    public DSI(String url) {
        this.mLogger = LoggerUtils.getLogger(this);
        this.mLogger.finer("DSI constructor " + url);
        this.setURL(url);
    }

    public DSI(String url, AuthEventListener l) {
        this.mLogger = LoggerUtils.getLogger(this);
        this.mLogger.finer("DSI constructor " + url);
        this.setAuthListener(l);
        this.setURL(url);
    }

    public DSI(String url, String user, String password) {
        this.mLogger = LoggerUtils.getLogger(this);
        this.mLogger.finer("DSI constructor " + url);
        this.setAuthListener(new ExplicitAuthListener(user, password));
        this.setURL(url);
        if (this.mWebdavResource != null) {
            HttpURL httpurl = this.mWebdavResource.getHttpURL();
            try {
                httpurl.setUserinfo(user, password);
            }
            catch (Exception e) {
                this.mLogger.severe(LoggerUtils.getStackTrace(e));
            }
        }
    }

    public void setAuthListener(AuthEventListener l) {
        this.mAuthListener = l;
    }

    public String getURL() {
        return this.mServer + this.mPath;
    }

    public String getServer() {
        return this.mServer;
    }

    public String getPath() {
        return this.mPath;
    }

    public void setURL(String newUrl) {
        this.mLogger.entering("DSI", "setURL", newUrl);
        boolean serverChange = this.mWebdavResource == null;
        try {
            String prevServer = this.mServer;
            this.parseUrl(newUrl);
            if (serverChange |= !prevServer.equals(this.mServer)) {
                HttpURL httpURL = null;
                String url = this.mServer + this.mPath;
                if (this.mQuery.length() > 0) {
                    url = url + "?" + this.mQuery;
                }
                if (this.mServer.startsWith("https")) {
                    this.mLogger.info("***Using HTTPS");
                    httpURL = new HttpsURL(url);
                } else {
                    httpURL = new HttpURL(url);
                }
                WebdavResource.setDefaultAction(1);
                this.mLogger.fine("creating new webdav resource");
                this.mWebdavResource = new WebdavResource(httpURL);
                this.mLogger.fine("mWebdavResource = " + this.mWebdavResource);
            } else {
                this.mWebdavResource.setPath(this.mPath);
            }
        }
        catch (Exception ex) {
            this.mLogger.severe("OhOh - exception in setURL(): " + ex.getMessage());
            this.mLogger.severe(LoggerUtils.getStackTrace(ex));
        }
        this.mLogger.exiting("DSI", "setURL");
    }

    public String moveTo(String path) {
        String newpath = path.startsWith("/") ? this.normalize(path) : (path.equals("..") ? this.normalize(this.mPath + "/../") : this.normalize(this.mPath + "/" + path));
        if (newpath != null) {
            this.setURL(this.mServer + newpath);
        }
        return this.mPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean check401Retry(int status) throws StatusException {
        boolean ret = false;
        this.mLogger.entering("DSI", "check401Retry" + status);
        if (status == 401) {
            if (status == 401 && this.mAuthListener != null && this.mAE.getRetryCount() < AuthEvent.MAX_RETRIES) {
                this.mAE.incrementRetryCount();
                if (!this.mAuthListener.authEventRequest(this.mAE)) throw new StatusException(401, "Too many retries");
                HttpURL httpurl = this.mWebdavResource.getHttpURL();
                try {
                    ret = true;
                    httpurl.setUserinfo(this.mAE.getUser(), this.mAE.getPassword());
                }
                catch (Exception e) {
                    this.mLogger.severe(LoggerUtils.getStackTrace(e));
                }
            }
        } else if (status == 508) {
            ret = true;
            this.mLogger.warning("Deadlock status detected - falling through to retry");
        }
        this.mLogger.exiting("DSI", "check401Retry");
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleExceptions(Exception ex) throws StatusException {
        block11: {
            this.mLogger.info("handleExceptions");
            this.mLogger.entering("DSI", "handleExceptions");
            if (ex instanceof HttpException) {
                HttpException he = (HttpException)ex;
                this.mLogger.info("****HttpException " + he.getReasonCode() + " " + he.getMessage());
                if (he.getReasonCode() == 401 && this.mAuthListener != null && this.mAE.getRetryCount() < AuthEvent.MAX_RETRIES) {
                    this.mAE.incrementRetryCount();
                    if (this.mAuthListener.authEventRequest(this.mAE)) {
                        HttpURL httpurl = this.mWebdavResource.getHttpURL();
                        try {
                            httpurl.setUserinfo(this.mAE.getUser(), this.mAE.getPassword());
                        }
                        catch (Exception e) {
                            this.mLogger.severe(LoggerUtils.getStackTrace(e));
                        }
                        break block11;
                    } else {
                        if (he.getReasonCode() >= 500 && he.getReasonCode() <= 599) {
                            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
                        }
                        throw new StatusException(he.getReasonCode(), he.getMessage());
                    }
                }
                int status = this.mWebdavResource.getStatusCode();
                if (status == 508) {
                    this.mLogger.warning("Deadlock status detected - falling through to retry");
                    break block11;
                } else {
                    if (status >= 500 && status <= 599) {
                        throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
                    }
                    throw new StatusException(status, this.mWebdavResource.getStatusMessage());
                }
            }
            if (ex instanceof IOException) {
                IOException iox = (IOException)ex;
                this.mLogger.info("IOException " + iox.getMessage() + " " + this.getPath());
                this.mLogger.severe(LoggerUtils.getStackTrace(ex));
                throw new StatusException(600, iox);
            }
            this.mLogger.info("Unknown exception " + ex.getMessage() + " " + ex.getClass().toString() + " " + this.getPath());
            this.mLogger.severe(LoggerUtils.getStackTrace(ex));
            throw new StatusException(601, ex);
        }
        this.mLogger.exiting("DSI", "handleExceptions");
    }

    protected boolean threeZeroOneHack() throws StatusException {
        boolean ret = false;
        int status = this.mWebdavResource.getStatusCode();
        if (status == 301) {
            if (!this.mPath.endsWith("/")) {
                try {
                    this.mWebdavResource.setPath(this.mPath + "/");
                    this.mPath = this.mPath + "/";
                    ret = true;
                }
                catch (Exception ex) {
                    this.mLogger.severe("Unable to add trailing / to: " + this.mPath);
                }
            }
        } else if (status == 400 && this.mPath.endsWith("/")) {
            try {
                this.mWebdavResource.setPath(this.mPath.substring(0, this.mPath.length() - 1));
                this.mPath = this.mPath.substring(0, this.mPath.length() - 1);
                ret = true;
            }
            catch (Exception ex) {
                this.mLogger.severe("Unable to remove trailing / to: " + this.mPath);
            }
        }
        return ret;
    }

    public boolean exists() throws StatusException {
        int status;
        this.mLogger.entering("DSI", "exists");
        boolean ret = false;
        this.mAE.reset();
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                this.mWebdavResource.headMethod();
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) <= 200 && status <= 299) {
            ret = true;
        } else if (status == 404) {
            ret = false;
        } else {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "exists");
        return ret;
    }

    public File getDataSet() throws StatusException {
        Object ret = null;
        try {
            File tmp = File.createTempFile("DSI", null);
            return this.getDataSet(tmp.getName());
        }
        catch (IOException iox) {
            throw new StatusException(600, iox);
        }
    }

    public String getDataSetAsString() throws StatusException {
        int status;
        this.mLogger.entering("DSI", "getDataSetAsString");
        String ret = null;
        this.mAE.reset();
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                ret = this.mWebdavResource.getMethodDataAsString();
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "getDataSetAsString");
        return ret;
    }

    public InputStream getDataSetAsFIS() throws StatusException {
        int status;
        this.mLogger.entering("DSI", "getDataSetAsFIS");
        InputStream ret = null;
        this.mAE.reset();
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                ret = this.mWebdavResource.getMethodData();
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "getDataSetAsFIS");
        return ret;
    }

    public InputStream getDataSet(Hashtable responseHeaders) throws StatusException {
        this.mLogger.entering("DSI", "getDataSet(with headers)");
        InputStream ret = null;
        this.mAE.reset();
        int status = 416;
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                GetMethod gmethod = new GetMethod(URIUtil.encodePathQuery(this.getPath()));
                status = this.myexecute(gmethod, null);
                if (this.check401Retry(status)) continue;
                ret = gmethod.getResponseBodyAsStream();
                Header[] headers = gmethod.getResponseHeaders();
                for (int idx = 0; idx < headers.length; ++idx) {
                    String key = headers[idx].getName();
                    String value = headers[idx].getValue();
                    responseHeaders.put(key, value);
                }
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if (status >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "getContentRange");
        return ret;
    }

    public File getDataSet(String filename, Hashtable extraHdrs) throws StatusException {
        File file = null;
        this.mAE.reset();
        int status = 500;
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                file = new File(filename);
                GetMethod gmethod = new GetMethod(URIUtil.encodePathQuery(this.getPath()));
                status = this.myexecute(gmethod, extraHdrs);
                this.saveResponseToFile(gmethod, file);
                if (this.check401Retry(status)) continue;
                break;
            }
            catch (Exception ex) {
                try {
                    file.delete();
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                file = null;
                this.handleExceptions(ex);
            }
        }
        if (status >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "getDataSet");
        return file;
    }

    public InputStream getDataSetAsContentRange(int start, int size) throws StatusException {
        this.mLogger.entering("DSI", "getDataSetAsFIS");
        InputStream ret = null;
        this.mAE.reset();
        int status = 416;
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                GetMethod gmethod = new GetMethod(URIUtil.encodePathQuery(this.getPath()));
                StringBuffer buf = new StringBuffer("bytes=");
                buf.append(start);
                buf.append("-");
                buf.append(start + size - 1);
                gmethod.setRequestHeader("Range", new String(buf));
                HttpClient client = this.mWebdavResource.retrieveSessionInstance();
                client.executeMethod(gmethod);
                ret = gmethod.getResponseBodyAsStream();
                status = gmethod.getStatusCode();
                if (this.check401Retry(status)) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if (status >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "getContentRange");
        return ret;
    }

    public File getDataSet(String filenameToReturn) throws StatusException {
        int status;
        this.mLogger.entering("DSI", "getDataSet");
        File file = null;
        this.mAE.reset();
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                file = new File(filenameToReturn);
                this.mWebdavResource.getMethod(file);
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                try {
                    file.delete();
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                file = null;
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "getDataSet");
        return file;
    }

    public void putDataSet(File file) throws StatusException {
        this.putDataSet(file, null);
    }

    public void putDataSet(File file, Hashtable extrahdrs) throws StatusException {
        this.mLogger.entering("DSI", "putDataSet");
        String filename = file.getName();
        if (!file.exists()) {
            try {
                file = File.createTempFile(filename, null);
            }
            catch (IOException iox) {
                throw new StatusException(600, iox);
            }
        }
        this.mAE.reset();
        int status = 500;
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                if (extrahdrs != null) {
                    PutMethod method = new PutMethod(URIUtil.encodePathQuery(this.getPath()));
                    long fileLength = file.length();
                    method.setRequestContentLength(fileLength <= Integer.MAX_VALUE ? (int)fileLength : -1);
                    method.setRequestBody(new FileInputStream(file));
                    status = this.myexecute(method, extrahdrs);
                } else {
                    this.mWebdavResource.putMethod(file);
                    status = this.mWebdavResource.getStatusCode();
                }
                if (this.check401Retry(status)) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if (status >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "putDataSet");
    }

    public void putDataSet(String data) throws StatusException {
        this.putDataSet(data, null);
    }

    public void putDataSet(String data, Hashtable extraHdrs) throws StatusException {
        this.mLogger.entering("DSI", "putDataSet");
        this.mAE.reset();
        int status = 500;
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                if (extraHdrs != null) {
                    PutMethod method = new PutMethod(URIUtil.encodePathQuery(this.getPath()));
                    method.setRequestBody(data);
                    status = this.myexecute(method, extraHdrs);
                } else {
                    if (data != null && data.length() > 0) {
                        this.mWebdavResource.putMethod(data);
                    } else {
                        this.mWebdavResource.putMethod(" ");
                    }
                    status = this.mWebdavResource.getStatusCode();
                }
                if (this.check401Retry(status)) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if (status >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "putDataSet");
    }

    public void putDataSet(InputStream data) throws StatusException {
        this.putDataSet(data, null);
    }

    public void putDataSet(InputStream data, Hashtable extraHdrs) throws StatusException {
        this.mLogger.entering("DSI", "putDataSet");
        this.mAE.reset();
        int status = 500;
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                if (extraHdrs != null) {
                    PutMethod method = new PutMethod(URIUtil.encodePathQuery(this.getPath()));
                    method.setRequestContentLength(-1);
                    method.setRequestBody(data);
                    status = this.myexecute(method, extraHdrs);
                } else {
                    this.mWebdavResource.putMethod(data);
                    status = this.mWebdavResource.getStatusCode();
                }
                if (this.check401Retry(status)) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if (status >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "putDataSet");
    }

    public void putDataSetWithProps(File dataFile, Hashtable properties) throws StatusException {
        this.mLogger.entering("DSI", "putDataSetWithProps");
        this.putDataSet(dataFile);
        this.putMetaData(properties);
        this.mLogger.exiting("DSI", "putDataSetWithProps");
    }

    private Enumeration queryMetaData(Vector properties, int depth) throws StatusException {
        int status;
        this.mLogger.entering("DSI", "queryMetaData");
        Enumeration returnEnum = null;
        if (depth != 0 && depth != 1 && depth != Integer.MAX_VALUE) {
            this.mLogger.severe("Bad value for depth in queryMetaData " + depth);
            throw new StatusException(602, "Bad value for depth sent to queryMetaData");
        }
        if (properties != null) {
            properties = this.formatPropertyNames(properties);
        }
        this.mAE.reset();
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                if (properties != null) {
                    this.mLogger.fine("mWebdavResource = " + this.mWebdavResource);
                    returnEnum = this.mWebdavResource.propfindMethod(depth, properties);
                } else {
                    returnEnum = this.mWebdavResource.propfindMethod(depth);
                }
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.mLogger.severe(LoggerUtils.getStackTrace(ex));
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "queryMetaData");
        return returnEnum;
    }

    public Enumeration queryMetaTriples(Vector properties) throws StatusException {
        int status;
        this.mLogger.entering("DSI", "queryMetaTriples");
        Enumeration returnEnum = null;
        if (properties != null) {
            properties = this.formatPropertyNames(properties);
        }
        this.mAE.reset();
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                returnEnum = properties != null ? this.mWebdavResource.mGetMethod(properties) : this.mWebdavResource.mGetMethod();
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.mLogger.severe(LoggerUtils.getStackTrace(ex));
                ex.printStackTrace();
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "queryMetaTriples");
        return returnEnum;
    }

    public void putMetaTriple(NSProperty propKey, Object value) throws StatusException {
        this.putMetaTriple(null, propKey, value);
    }

    public void putMetaTriple(URI uri, NSProperty propKey, Object value) throws StatusException {
        int status;
        this.mLogger.entering("DSI", "putMetaTriple");
        this.mAE.reset();
        String namespace = propKey.getNamespaceURI();
        if (namespace != null && namespace.trim().length() == 0) {
            namespace = "DAV:";
        }
        PropertyName slidePN = new PropertyName(namespace, propKey.getLocalName());
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                if (uri != null) {
                    this.mWebdavResource.mPutMethod(uri, slidePN, value, true);
                } else {
                    this.mWebdavResource.mPutMethod(slidePN, value, true);
                }
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "putMetaTriple");
    }

    public void putMetaTriple(Hashtable properties) throws StatusException {
        this.putMetaTriple((URI)null, properties);
    }

    public void putMetaTriple(URI uri, Hashtable properties) throws StatusException {
        int status;
        this.mLogger.entering("DSI", "putMetaTriple");
        this.mAE.reset();
        Hashtable tmp = new Hashtable();
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            NSProperty p = (NSProperty)keys.nextElement();
            Object value = properties.get(p);
            String namespace = p.getNamespaceURI();
            if (namespace != null && namespace.trim().length() == 0) {
                namespace = "DAV:";
            }
            PropertyName slidePN = new PropertyName(namespace, p.getLocalName());
            tmp.put(slidePN, value);
        }
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                if (uri != null) {
                    this.mWebdavResource.mPutMethod(uri, tmp, true);
                } else {
                    this.mWebdavResource.mPutMethod(tmp, true);
                }
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "putMetaTriple");
    }

    public void removeMetaTriple(NSProperty propKey, String value) throws StatusException {
        int status;
        this.mLogger.entering("DSI", "removeMetaTriple");
        this.mAE.reset();
        String namespace = propKey.getNamespaceURI();
        if (namespace != null && namespace.trim().length() == 0) {
            namespace = "DAV:";
        }
        PropertyName slidePN = new PropertyName(namespace, propKey.getLocalName());
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                this.mWebdavResource.mDeleteMethod(slidePN, value, true);
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "removeMetaTriple");
    }

    public void removeMetaTriple(URI uri, NSProperty propKey, String value) throws StatusException {
        int status;
        this.mLogger.entering("DSI", "removeMetaTriple");
        this.mAE.reset();
        PropertyName slidePN = null;
        if (propKey != null) {
            String namespace = propKey.getNamespaceURI();
            if (namespace != null && namespace.trim().length() == 0) {
                namespace = "DAV:";
            }
            slidePN = new PropertyName(namespace, propKey.getLocalName());
        }
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                if (uri != null) {
                    this.mWebdavResource.mDeleteMethod(uri, slidePN, value, true);
                } else {
                    this.mWebdavResource.mDeleteMethod(slidePN, value, true);
                }
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "removeMetaTriple");
    }

    public void removeMetaData(Vector propkeys) throws StatusException {
        this.mLogger.entering("DSI", "removeMetaData");
        int status = 500;
        this.mAE.reset();
        PropPatchMethod method = null;
        try {
            method = new PropPatchMethod(URIUtil.encodePathQuery(this.getPath()));
        }
        catch (URIException ex) {
            throw new StatusException(602, ex);
        }
        for (int idx = 0; idx < propkeys.size(); ++idx) {
            Object obj = propkeys.elementAt(idx);
            if (!(obj instanceof NSProperty)) {
                this.mLogger.severe("Property keys must be NSProperty objects." + obj.getClass().getName());
                throw new StatusException(602, "Property keys must be of type NSProperty" + obj.getClass().getName());
            }
            NSProperty prop = (NSProperty)propkeys.elementAt(idx);
            method.addPropertyToRemove(prop.getLocalName(), "x", prop.getNamespaceURI());
        }
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                status = this.myexecute(method, null);
                if (this.check401Retry(status)) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if (status >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "putMetaData");
    }

    public Hashtable getMetaData(Vector propKeys) throws StatusException {
        Hashtable ret = null;
        this.mLogger.entering("DSI", "getMetaData");
        Enumeration results = this.queryMetaData(propKeys, 0);
        while (results.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)results.nextElement();
            Enumeration properties = response.getProperties();
            ret = this.propEnumToHashtable(properties);
        }
        this.mLogger.exiting("DSI", "getMetaData");
        return ret;
    }

    public Hashtable getMetaData(Vector propKeys, int depth) throws StatusException {
        Hashtable<String, Hashtable> resultHash = null;
        this.mLogger.entering("DSI", "getMetaData");
        Enumeration results = this.queryMetaData(propKeys, depth);
        resultHash = new Hashtable<String, Hashtable>();
        while (results.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)results.nextElement();
            String key = response.getHref();
            try {
                key = URLDecoder.decode(key, "UTF-8");
                key = URLDecoder.decode(key, "UTF-8");
            }
            catch (Exception e) {
                this.mLogger.severe(e.toString());
                this.mLogger.severe(LoggerUtils.getStackTrace(e));
            }
            Enumeration properties = response.getProperties();
            Hashtable propcoll = this.propEnumToHashtable(properties);
            resultHash.put(key, propcoll);
        }
        this.mLogger.exiting("DSI", "getMetaData");
        return resultHash;
    }

    public Hashtable listCollection(Vector propKeys) throws StatusException {
        Hashtable<String, Hashtable> resultHash = new Hashtable<String, Hashtable>();
        Enumeration results = this.queryMetaData(propKeys, 1);
        int status = this.mWebdavResource.getStatusCode();
        if (status >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        Enumeration properties = null;
        Object property = null;
        ResponseEntity response = null;
        String httpURLPath = "";
        try {
            httpURLPath = this.mWebdavResource.getHttpURL().getPath();
            httpURLPath = URLDecoder.decode(httpURLPath, "UTF-8");
        }
        catch (Exception e) {
            this.mLogger.severe(e.toString());
            this.mLogger.severe(LoggerUtils.getStackTrace(e));
        }
        while (results.hasMoreElements()) {
            String key;
            response = (ResponseEntity)results.nextElement();
            boolean itself = false;
            String decodedKey = key = response.getHref();
            try {
                decodedKey = URLDecoder.decode(key, "UTF-8");
            }
            catch (Exception e) {
                this.mLogger.severe(e.toString());
                this.mLogger.severe(LoggerUtils.getStackTrace(e));
            }
            int compared = httpURLPath.compareToIgnoreCase(decodedKey);
            if (compared == 0 || compared == -1 && key.endsWith("/") || compared == 1 && httpURLPath.endsWith("/")) {
                itself = true;
            }
            if (itself) continue;
            properties = response.getProperties();
            resultHash.put(decodedKey, this.propEnumToHashtable(properties));
        }
        return resultHash;
    }

    public ResourceList getResources(Vector properties) throws StatusException {
        return this.getResources(properties, Integer.MAX_VALUE, false);
    }

    public ResourceList getResources(Vector properties, int depth) throws StatusException {
        return this.getResources(properties, depth, false);
    }

    public ResourceList getResources(Vector properties, int depth, boolean separateParent) throws StatusException {
        ResourceList ret = new ResourceList();
        String parentUrl = UrlUtils.formatURL(this.getURL());
        ret.setServer(this.mServer);
        Hashtable resources = this.getMetaData(properties, depth);
        if (resources != null) {
            Enumeration keys = resources.keys();
            while (keys.hasMoreElements()) {
                String resourceUrl = (String)keys.nextElement();
                DAVResource curResource = new DAVResource(resourceUrl, this.mServer);
                Hashtable curPropSet = (Hashtable)resources.get(resourceUrl);
                Iterator propit = curPropSet.keySet().iterator();
                while (propit.hasNext()) {
                    DSIProperty curProp = (DSIProperty)curPropSet.get(propit.next());
                    try {
                        curResource.putProperty(curProp);
                    }
                    catch (Exception ex) {}
                }
                if (separateParent && parentUrl.equals(UrlUtils.formatURL(curResource.getURL()))) {
                    ret.setParentDirectory(curResource);
                    continue;
                }
                ret.addElement(curResource);
            }
        }
        return ret;
    }

    protected String constructBasicDASL(Vector propsToReturn, Vector propsToSearch, int depth, String value) throws StatusException {
        String ns;
        Object p;
        int idx;
        if (propsToReturn != null) {
            propsToReturn = this.formatPropertyNames(propsToReturn);
        }
        Hashtable<String, String> namespaces = new Hashtable<String, String>();
        StringBuffer buf = new StringBuffer();
        buf.append("<D:searchrequest");
        buf.append(" xmlns:D=\"DAV:\"");
        namespaces.put("DAV:", "D");
        buf.append(" xmlns:s=\"http://jakarta.apache.org/slide/\"");
        namespaces.put("http://jakarta.apache.org/slide/", "s");
        int nsCnt = 1;
        if (propsToReturn != null) {
            for (idx = 0; idx < propsToReturn.size(); ++idx) {
                p = (PropertyName)propsToReturn.get(idx);
                ns = ((QName)p).getNamespaceURI();
                if (namespaces.containsKey(ns)) continue;
                namespaces.put(ns, "n" + nsCnt);
                buf.append(" xmlns:n" + nsCnt + "=\"" + ns + "\"");
                ++nsCnt;
            }
        }
        if (propsToSearch != null) {
            for (idx = 0; idx < propsToSearch.size(); ++idx) {
                p = (NSProperty)propsToSearch.get(idx);
                ns = ((NSProperty)p).getNamespaceURI();
                if (namespaces.containsKey(ns)) continue;
                namespaces.put(ns, "n" + nsCnt);
                buf.append(" xmlns:n" + nsCnt + "=\"" + ns + "\"");
                ++nsCnt;
            }
        }
        buf.append(">");
        buf.append("<D:basicsearch>");
        buf.append("<D:select>");
        if (propsToReturn != null && propsToReturn.size() > 0) {
            buf.append("<D:prop>");
            for (idx = 0; idx < propsToReturn.size(); ++idx) {
                p = (PropertyName)propsToReturn.get(idx);
                buf.append("<" + namespaces.get(((QName)p).getNamespaceURI()) + ":" + ((QName)p).getLocalName() + "/>");
            }
            buf.append("</D:prop>");
        } else {
            buf.append("<D:allindexedprop/>");
        }
        buf.append("</D:select>");
        buf.append("<D:from>");
        buf.append("<D:scope>");
        buf.append("<D:href>" + this.getPath() + "</D:href>");
        buf.append("<D:depth>" + depth + "</D:depth>");
        buf.append("</D:scope>");
        buf.append("</D:from>");
        buf.append("<D:where>");
        if (propsToSearch != null && propsToSearch.size() > 0) {
            if (propsToSearch.size() == 1) {
                buf.append("<s:propcontains>");
                buf.append("<D:prop>");
                NSProperty p2 = (NSProperty)propsToSearch.get(0);
                buf.append("<" + namespaces.get(p2.getNamespaceURI()) + ":" + p2.getLocalName() + "/>");
                buf.append("</D:prop>");
                if (value != null && !value.equals("")) {
                    buf.append("<D:literal>" + value + "</D:literal>");
                } else {
                    buf.append("<D:literal>*</D:literal>");
                }
                buf.append("</s:propcontains>");
            } else {
                buf.append("<D:or>");
                for (idx = 0; idx < propsToSearch.size(); ++idx) {
                    buf.append("<s:propcontains>");
                    buf.append("<D:prop>");
                    p = (NSProperty)propsToSearch.get(idx);
                    buf.append("<" + namespaces.get(((NSProperty)p).getNamespaceURI()) + ":" + ((NSProperty)p).getLocalName() + "/>");
                    buf.append("</D:prop>");
                    if (value != null && !value.equals("")) {
                        buf.append("<D:literal>" + value + "</D:literal>");
                    } else {
                        buf.append("<D:literal>*</D:literal>");
                    }
                    buf.append("</s:propcontains>");
                }
                buf.append("</D:or>");
            }
        } else {
            buf.append("<s:propcontains>");
            buf.append("<D:prop><D:allindexedprop/></D:prop>");
            if (value != null && !value.equals("")) {
                buf.append("<D:literal>" + value + "</D:literal>");
            } else {
                buf.append("<D:literal>*</D:literal>");
            }
            buf.append("</s:propcontains>");
        }
        buf.append("</D:where>");
        buf.append("</D:basicsearch>");
        buf.append("</D:searchrequest>");
        return new String(buf);
    }

    public Hashtable searchMetaData(Vector propsToReturn, Vector propsToSearch, int depth, String value) throws StatusException {
        this.mLogger.entering("DSI", "searchMetaData");
        String query = this.constructBasicDASL(propsToReturn, propsToSearch, depth, value);
        return this.doDaslQuery(query, depth);
    }

    public Hashtable doDaslQuery(String query, int depth) throws StatusException {
        Object returnEnum = null;
        if (depth != 0 && depth != 1 && depth != Integer.MAX_VALUE) {
            this.mLogger.severe("Bad value for depth in queryMetaData " + depth);
            throw new StatusException(602, "Bad value for depth sent to queryMetaData");
        }
        this.mAE.reset();
        Hashtable<String, Hashtable> resultHash = null;
        int status = 207;
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                SearchMethod method = new SearchMethod(URIUtil.encodePathQuery(this.getPath()), query);
                status = this.myexecute(method, null);
                if (this.check401Retry(status)) continue;
                if (status < 200 || status >= 300) break;
                resultHash = new Hashtable<String, Hashtable>();
                Enumeration urls = method.getAllResponseURLs();
                while (urls.hasMoreElements()) {
                    String key = (String)urls.nextElement();
                    Enumeration results = method.getResponseProperties(key);
                    Hashtable propcoll = this.propEnumToHashtable(results);
                    resultHash.put(URLDecoder.decode(key, "UTF-8"), propcoll);
                }
                break;
            }
            catch (Exception ex) {
                this.mLogger.severe(LoggerUtils.getStackTrace(ex));
                this.handleExceptions(ex);
            }
        }
        if (status >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        return resultHash;
    }

    public String doDaslQueryAsString(String query) throws StatusException {
        String body = null;
        this.mAE.reset();
        int status = 207;
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                SemanticSearchMethod method = new SemanticSearchMethod(URIUtil.encodePathQuery(this.getPath()), query);
                status = this.myexecute(method, null);
                if (this.check401Retry(status)) continue;
                if (status < 200 || status >= 300) break;
                body = method.getResponseString();
                break;
            }
            catch (Exception ex) {
                this.mLogger.severe(LoggerUtils.getStackTrace(ex));
                this.handleExceptions(ex);
            }
        }
        if (status >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        return body;
    }

    public ResourceList searchResources(Vector properties) throws StatusException {
        return this.searchResources(properties, Integer.MAX_VALUE, false);
    }

    public ResourceList searchResources(Vector properties, int depth) throws StatusException {
        return this.searchResources(properties, depth, false);
    }

    public ResourceList searchResources(Vector properties, int depth, boolean separateParent) throws StatusException {
        Vector<NSProperty> where = new Vector<NSProperty>();
        where.add(new NSProperty("DAV::owner"));
        return this.searchResources(properties, where, depth, "*", separateParent);
    }

    public ResourceList searchResources(Vector propsToGet, Vector propsToSearch, int depth, String substrValue, boolean separateParent) throws StatusException {
        Hashtable resources = this.searchMetaData(propsToGet, propsToSearch, depth, substrValue);
        return this.hashtable2ResourceList(resources, separateParent);
    }

    protected ResourceList hashtable2ResourceList(Hashtable resources, boolean separateParent) {
        ResourceList ret = new ResourceList();
        String parentUrl = UrlUtils.formatURL(this.getURL());
        ret.setServer(this.mServer);
        if (resources != null) {
            Enumeration keys = resources.keys();
            while (keys.hasMoreElements()) {
                String resourceUrl = (String)keys.nextElement();
                DAVResource curResource = new DAVResource(resourceUrl, this.mServer);
                Hashtable curPropSet = (Hashtable)resources.get(resourceUrl);
                Iterator propit = curPropSet.keySet().iterator();
                while (propit.hasNext()) {
                    DSIProperty curProp = (DSIProperty)curPropSet.get(propit.next());
                    try {
                        curResource.putProperty(curProp);
                    }
                    catch (Exception ex) {}
                }
                if (separateParent && parentUrl.equals(UrlUtils.formatURL(curResource.getURL()))) {
                    ret.setParentDirectory(curResource);
                    continue;
                }
                ret.addElement(curResource);
            }
        }
        return ret;
    }

    public ResourceList searchResources(String query, int depth) throws StatusException {
        Hashtable resources = this.doDaslQuery(query, depth);
        return this.hashtable2ResourceList(resources, false);
    }

    public DSIProperty getMetaData(NSProperty propertyName) throws StatusException {
        Property prop;
        ResponseEntity response;
        Enumeration properties;
        DSIProperty ret = null;
        Vector<NSProperty> tmpPropVector = new Vector<NSProperty>();
        tmpPropVector.add(propertyName);
        Enumeration responses = this.queryMetaData(tmpPropVector, 0);
        if (responses != null && (properties = (response = (ResponseEntity)responses.nextElement()).getProperties()) != null && properties.hasMoreElements() && (prop = (Property)properties.nextElement()) != null) {
            ret = new DSIProperty((BaseProperty)prop);
        }
        return ret;
    }

    public Hashtable getMetaData() throws StatusException {
        int status;
        this.mLogger.entering("DSI", "getMetaData");
        Hashtable ret = null;
        Enumeration responses = null;
        this.mAE.reset();
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                responses = this.mWebdavResource.propfindMethod(0);
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        if (!responses.hasMoreElements()) {
            ret = new Hashtable();
            this.mLogger.severe("No response from getMetaData " + this.mWebdavResource.getStatusMessage());
        } else {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            Enumeration properties = response.getProperties();
            ret = this.propEnumToHashtable(properties);
        }
        this.mLogger.exiting("DSI", "getMetaData");
        return ret;
    }

    public void putMetaData(NSProperty propKey, String value) throws StatusException {
        int status;
        this.mLogger.entering("DSI", "putMetaData");
        this.mAE.reset();
        PropertyName slidePN = new PropertyName(propKey.getNamespaceURI(), propKey.getLocalName());
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                this.mWebdavResource.proppatchMethod(slidePN, value, true);
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "putMetaData");
    }

    public void putMetaData(Hashtable properties) throws StatusException {
        int status;
        this.mLogger.entering("DSI", "putMetaData");
        this.mAE.reset();
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                this.mWebdavResource.proppatchMethod(this.formatPropertyNames(properties), true);
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "putMetaData");
    }

    public String[] listCollection() throws StatusException {
        this.mLogger.entering("DSI", "listCollection");
        String[] list = null;
        Vector basic = this.listCollectionBasic();
        int size = basic.size();
        if (size > 0) {
            list = new String[size];
            for (int idx = 0; idx < size; ++idx) {
                String[] tmp = (String[])basic.get(idx);
                list[idx] = tmp[0];
            }
        }
        this.mLogger.exiting("DSI", "listCollection");
        return list;
    }

    public Vector listCollectionBasic() throws StatusException {
        this.mLogger.entering("DSI", "listCollectionBasic");
        Vector list = null;
        this.mAE.reset();
        int status = 500;
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                list = this.mWebdavResource.listBasic();
                status = this.mWebdavResource.getStatusCode();
                if (this.check401Retry(status)) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if (status >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "listCollectionBasic");
        return list;
    }

    public boolean isCollection() throws StatusException {
        String value;
        this.mLogger.entering("DSI", "isCollection");
        boolean ret = false;
        NSProperty rt = new NSProperty("DAV:", "resourcetype");
        DSIProperty dsiprop = this.getMetaData(rt);
        if (dsiprop != null && (value = dsiprop.getPropertyAsXMLString(true)).indexOf("collection") >= 0) {
            ret = true;
        }
        this.mLogger.exiting("DSI", "isCollection");
        return ret;
    }

    public void removeResource() throws StatusException {
        int status;
        this.mLogger.entering("DSI", "removeResource");
        this.mAE.reset();
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                this.mWebdavResource.deleteMethod();
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.mLogger.fine("DSI DELETE ERROR");
                this.mLogger.fine(LoggerUtils.getStackTrace(ex));
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "removeResource");
    }

    public String makeCollection(String subpath) throws StatusException {
        return this.makeCollection(subpath, null);
    }

    public String makeCollection(String subpath, Hashtable extraHdrs) throws StatusException {
        String ret = null;
        String newcol = subpath;
        this.mAE.reset();
        String slidePath = null;
        slidePath = !this.mPath.endsWith("/") ? this.mPath + "/" + newcol : this.mPath + newcol;
        int status = 500;
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                if (extraHdrs != null) {
                    MkcolMethod method = new MkcolMethod(URIUtil.encodePathQuery(slidePath));
                    status = this.myexecute(method, extraHdrs);
                } else {
                    this.mWebdavResource.mkcolMethod(slidePath);
                    status = this.mWebdavResource.getStatusCode();
                }
                if (this.check401Retry(status)) continue;
                break;
            }
            catch (Exception ex) {
                System.out.println("oh no" + ex.getMessage());
                this.handleExceptions(ex);
            }
        }
        if (status >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        ret = this.mServer + slidePath + "/";
        this.mLogger.info("makeCollection returning" + ret);
        return ret;
    }

    public String makeCollection(String subpath, boolean derive) throws StatusException {
        String newcol = subpath;
        DSIHelper helper = new DSIHelper(this);
        newcol = helper.makeCollection(newcol);
        helper = null;
        return newcol;
    }

    public String move(String dest) throws StatusException {
        int status;
        String ret = null;
        this.mLogger.entering("DSI", "move");
        String idest = dest;
        if (!dest.startsWith("/")) {
            String[] split = DSI.splitUrl(this.mPath);
            idest = dest.endsWith("/") ? split[0] + dest : split[0] + "/" + dest;
        }
        this.mAE.reset();
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                idest = this.normalize(idest);
                this.mWebdavResource.moveMethod(idest);
                ret = this.mServer + idest;
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.mLogger.warning("Move exception: " + this.mWebdavResource.getStatusCode());
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            this.mLogger.warning("Server error: " + status);
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "move");
        return ret;
    }

    public String copy(String dest) throws StatusException {
        int status;
        this.mLogger.entering("DSI", "copy");
        String ret = null;
        String idest = dest;
        if (!dest.startsWith("/")) {
            String[] split = DSI.splitUrl(this.mPath);
            idest = dest.endsWith("/") ? split[0] + dest : split[0] + "/" + dest;
        }
        this.mAE.reset();
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                idest = this.normalize(idest);
                this.mWebdavResource.copyMethod(idest);
                ret = this.mServer + idest;
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "copy");
        return ret;
    }

    public String makeUniqueName(String subpath) throws StatusException {
        String ret = subpath;
        String[] curnames = this.listCollection();
        HashSet<String> map = new HashSet<String>();
        if (curnames != null) {
            int idx;
            for (idx = 0; idx < curnames.length; ++idx) {
                map.add(curnames[idx]);
            }
            if (map.contains(subpath)) {
                for (idx = 0; idx < curnames.length + 1; ++idx) {
                    String tmp = subpath + "_" + idx;
                    if (map.contains(tmp)) continue;
                    ret = tmp;
                    break;
                }
            }
        }
        return ret;
    }

    public HttpClient getSessionInstance() throws StatusException {
        HttpClient client = null;
        try {
            client = this.mWebdavResource.retrieveSessionInstance();
        }
        catch (IOException iox) {
            this.mLogger.warning("IOException in getSessionInstance() " + iox.getMessage());
            throw new StatusException(600, iox);
        }
        return client;
    }

    public Cookie[] getCookies() {
        Cookie[] cookies = null;
        if (this.mWebdavResource != null) {
            try {
                HttpClient client = this.mWebdavResource.retrieveSessionInstance();
                HttpState state = client.getState();
                cookies = state.getCookies();
            }
            catch (IOException iox) {
                this.mLogger.warning("IOException in getCookies() " + iox.getMessage());
            }
        }
        return cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.mWebdavResource != null) {
            try {
                this.mWebdavResource.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.mWebdavResource = null;
            }
        }
    }

    public void putACL(Ace[] aces) throws StatusException {
        int status;
        this.mLogger.entering("DSI", "putACL");
        this.mAE.reset();
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                this.mWebdavResource.aclMethod(this.getPath(), aces);
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        if ((status = this.mWebdavResource.getStatusCode()) >= 500 && status <= 599) {
            throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
        }
        if (status < 200 || status > 299) {
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "putACL");
    }

    public AclProperty getACL() throws StatusException {
        this.mLogger.entering("DSI", "getACL");
        this.mAE.reset();
        AclProperty ret = null;
        int retry = 0;
        while (retry++ < AuthEvent.MAX_RETRIES) {
            try {
                ret = this.mWebdavResource.aclfindMethod();
                if (this.check401Retry(this.mWebdavResource.getStatusCode())) continue;
                break;
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        int status = this.mWebdavResource.getStatusCode();
        if (ret == null) {
            if (status >= 500 && status <= 599) {
                throw new InternalServerErrorException(this.mWebdavResource.getErrorPage());
            }
            throw new StatusException(status, this.mWebdavResource.getStatusMessage());
        }
        this.mLogger.exiting("DSI", "getACL");
        return ret;
    }

    protected int myexecute(HttpMethodBase method, Hashtable extraHdrs) throws IOException {
        HttpClient client = this.mWebdavResource.retrieveSessionInstance();
        if (extraHdrs != null) {
            this.addHeaders(method, extraHdrs);
        }
        return client.executeMethod(method);
    }

    protected void addHeaders(HttpMethodBase method, Hashtable extrahdrs) {
        Enumeration keys = extrahdrs.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            method.setRequestHeader(key, (String)extrahdrs.get(key));
        }
    }

    protected void saveResponseToFile(HttpMethodBase method, File file) throws IOException, FileNotFoundException {
        int status = method.getStatusCode();
        if (status >= 200 && status < 300) {
            int bytesRead;
            InputStream is = method.getResponseBodyAsStream();
            FileOutputStream fos = new FileOutputStream(file);
            byte[] buffer = new byte[65535];
            while ((bytesRead = is.read(buffer)) > 0) {
                fos.write(buffer, 0, bytesRead);
            }
            is.close();
            fos.close();
        }
    }

    public String getUser() {
        String ret = null;
        HttpURL httpurl = this.mWebdavResource.getHttpURL();
        try {
            ret = httpurl.getUser();
        }
        catch (Exception e) {
            this.mLogger.severe(e.toString());
        }
        return ret;
    }

    public static String[] splitUrl(String fullUrl) {
        int slash;
        String url = new String(fullUrl);
        String[] ret = new String[2];
        if ((url = url.trim()).endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if ((slash = url.lastIndexOf("/")) != -1) {
            ret[0] = url.substring(0, slash + 1);
            ret[1] = url.substring(slash + 1);
        } else {
            ret[0] = "";
            ret[1] = url;
        }
        return ret;
    }

    private void parseUrl(String urlstr) {
        String path = "";
        String server = "";
        String query = "";
        try {
            URL url = new URL(urlstr);
            path = url.getPath();
            query = url.getQuery();
            String protocol = url.getProtocol();
            String host = url.getHost();
            int port = url.getPort();
            if (protocol != null) {
                server = protocol;
            }
            if (host != null) {
                server = server + "://" + host;
            }
            if (port != -1) {
                server = server + ":" + port;
            }
        }
        catch (Exception ex) {
            this.mLogger.warning("Unable to parse url: " + urlstr + " " + ex.getMessage());
            path = urlstr;
        }
        this.mPath = this.fixDoubleSlash(path);
        if (server.length() > 0) {
            this.mServer = server;
        }
        if (query == null) {
            query = "";
        }
        this.mQuery = query;
        this.mLogger.fine("Parsing results: " + urlstr + "->" + this.mServer + " " + this.mPath + " " + this.mQuery);
    }

    public String normalize(String path) {
        int index;
        this.mLogger.info("START normalize" + path);
        if (path == null) {
            return null;
        }
        String normalized = this.fixDoubleSlash(path);
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return "/";
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        this.mLogger.info("END normalize" + normalized);
        return normalized;
    }

    public String fixDoubleSlash(String url) {
        int index;
        while ((index = url.indexOf("//")) >= 0) {
            url = url.substring(0, index) + url.substring(index + 1);
        }
        return url;
    }

    protected PropertyName formatPropertyName(NSProperty prop) {
        PropertyName ret = null;
        ret = prop.getNamespaceURI().equals("DAV") ? new PropertyName("DAV:", prop.getLocalName()) : new PropertyName(prop.getNamespaceURI(), prop.getLocalName());
        return ret;
    }

    protected Hashtable formatPropertyNames(Hashtable props) throws StatusException {
        Hashtable ret = new Hashtable();
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            Object obj = keys.nextElement();
            if (obj instanceof NSProperty) {
                NSProperty thisprop = (NSProperty)obj;
                PropertyName pname = this.formatPropertyName(thisprop);
                ret.put(pname, props.get(thisprop));
                continue;
            }
            this.mLogger.severe("Property keys must be NSProperty objects." + obj.getClass().getName());
            throw new StatusException(602, "Property keys must be of type NSProperty" + obj.getClass().getName());
        }
        return ret;
    }

    protected Vector formatPropertyNames(Vector propKeys) throws StatusException {
        Vector<PropertyName> propertyNames = new Vector<PropertyName>();
        for (int i = 0; i < propKeys.size(); ++i) {
            Object obj = propKeys.elementAt(i);
            if (!(obj instanceof NSProperty)) {
                this.mLogger.severe("Property keys must be NSProperty objects." + obj.getClass().getName());
                throw new StatusException(602, "Property keys must be of type NSProperty" + obj.getClass().getName());
            }
            PropertyName prop = this.formatPropertyName((NSProperty)propKeys.elementAt(i));
            propertyNames.addElement(prop);
        }
        return propertyNames;
    }

    protected Hashtable propEnumToHashtable(Enumeration properties) {
        Hashtable<NSProperty, DSIProperty> propcoll = new Hashtable<NSProperty, DSIProperty>();
        while (properties.hasMoreElements()) {
            Property prop = (Property)properties.nextElement();
            int status = prop.getStatusCode();
            if (status < 200 || status > 299) continue;
            if (prop instanceof BaseProperty) {
                DSIProperty altprop = new DSIProperty((BaseProperty)prop);
                NSProperty propName = altprop.getPropertyKey();
                propcoll.put(propName, altprop);
                continue;
            }
            this.mLogger.severe("Property is not of type BaseProperty");
        }
        return propcoll;
    }

    protected final class DSIHelper {
        private DSI mDSI = null;

        public DSIHelper(DSI dsi) {
            this.mDSI = dsi;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String makeCollection(String name) throws StatusException {
            String newcol = name;
            Class<DSIHelper> clazz = DSIHelper.class;
            synchronized (DSIHelper.class) {
                newcol = DSI.this.makeUniqueName(name);
                newcol = this.mDSI.makeCollection(newcol);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return newcol;
            }
        }
    }
}

