ITK Release 5.0 Release Candidiate 1
====================================

We are happy to announce the Insight Toolkit (ITK) Release Candidate 1! :tada:  As the first release candidate, the major advancements for ITK 5 have matured, and the community is encouraged to adopt the release candidate in ITK-based applications.

This release improves `Mesh` support in Python though simplification and extension of `Mesh` and `PointSet` wrapping. In general, this release makes improvements to the modernization of the toolkit staged in ITK 5.
The C++ range classes continue to advance, including the experimental [`itk::ImageBufferRange`](https://itk.org/Insight/Doxygen/html/classitk_1_1Experimental_1_1ImageBufferRange.html), [`itk::IndexRange`](https://itk.org/Insight/Doxygen/html/classitk_1_1Experimental_1_1IndexRange.html), and [`itk::ShapedImageNeighborhoodRange`](https://itk.org/Insight/Doxygen/html/classitk_1_1Experimental_1_1ShapedImageNeighborhoodRange.html). Our migration to GitHub was overwhelmingly successful, but it continues to improve. Pull requests now receive a helpful [CDash](https://www.cdash.org/) build analysis GitHub Check.

![GitHub CDash Build Analysis Check](https://user-images.githubusercontent.com/25432/52307170-dac19200-2967-11e9-926d-687b3ed45c91.png)

For an overview of ITK 5's transition to modern C++, performance-related changes, the new, Pythonic API, and the project's migration to GitHub, see the [ITK 5 Alpha 1: Modern C++](https://discourse.itk.org/t/itk-5-0-alpha-1-modern-c/843/7), [ITK 5 Alpha 2: Performance](https://discourse.itk.org/t/itk-5-0-alpha-2-performance/959), [ITK 5 Beta 1: Pythonic Interface](https://discourse.itk.org/t/itk-5-0-beta-1-pythonic-interface/1271), and [ITK 5 Beta 3: GitHub](https://discourse.itk.org/t/itk-5-0-beta-3-github/1504) release announcements.

Performance Improvements
----------------------------------------

- `N4BiasFieldCorrectionImageFilter` accelerated through `itk::ImageBufferRange` and other optimizations.
- Various modern C++ improvements related to default constructors, move operations, etc.

Documentation
------------------------------

- [ITK Software Guide PDF](https://itk.org/ItkSoftwareGuide.pdf) is now updated for ITK 5.
- `TransformIndexToPhysicalPoint` notation is improved.

Infrastructure
------------------------------

- Mesh IO classes, e.g. Gifti, OBJ, OFF, FreeSurfer, BYU, STL, are now split into separate modules for better modularity.
- A CDash build analysis summary and link is provided as a GitHub Check.
- Added new C++11 member functions from `std::vector` to `itk::VectorContainer`.

Third Party
----------------------------------------

- DCMTK 3.6.4 is now supported.
- `CanRead` is now faster for inspection of potential DICOM files, both with the GDCM and DCMTK DICOM backends.
- Eigen updated to 3.3.7.
- Improved support for integration of a system Eigen.
- Improved compatibility with system HDF5.

Python
-----------

- Wrapping for `Mesh` and `PointSet` classes was simplified and extended.
- `BinaryMaskToNarrowBandPointSetFilter` is now available in Python.
- Better `itk.Image` NumPy buffer management for advanced pipeline grafting.

To install the 5.0 Release Candidate 1 Python packages, run

```sh
python -m pip install --upgrade pip
python -m pip install --upgrade --pre itk
```

What's Next
--------------------

There are many more bug fixes and improvements not mentioned above. For more details, please see the change log below. Congratulations and thank you to everyone who contributed to this release.

The [ITK 5 Migration Guide](https://github.com/InsightSoftwareConsortium/ITK/blob/master/Documentation/ITK5MigrationGuide.md) is available to help transition a code base from ITK 4 to ITK 5. Please discuss your experiences on [Discourse](https://discourse.itk.org).

We are approaching the 5.0.0 final release! The next release will be the second ITK 5 release candidate; it is [scheduled for March](https://github.com/InsightSoftwareConsortium/ITK/milestone/4).

Enjoy ITK!

```
Changes from v5.0b03 to v5.0rc01
-----------------------------------------------

Bradley Lowekamp (2) @blowekamp:
      BUG: Use compatible ITKv4 computation
      BUG: Fix Ostu test to work with ITKv4 default options

Dženan Zukić (9) @dzenanz:
      ENH: updating ITKMontage module
      DOC: trying to fix the doxygen warning
      ENH: Updating Visual Studio debug visualizer definitions
      DOC: removing long outdated comment
      ENH: updating Montage module
      STYLE: minor fixes to release notes
      COMP: a fix for system double-conversion build
      ENH: updating Montage: fix double-conversion include directory
      ENH: update ITKMontage: Fix crash when setting tiles from memory

Eigen Upstream (1):
      Eigen3 2019-01-14 (16812519)

Francois Budin (1) @fbudin69500:
      BUG: Missing ITK_WRAP_rgba_* variables in WrapITKConfig.cmake.in

Hans Johnson (7) @hjmjohnson:
      STYLE: rm initializer list extra lines
      ENH: DCMTK 3.6.4 api changes accomodated
      ENH: Move default [con/de]strutor to .h
      COMP: Protected static function must be public
      PERF: GDCM & DCMTK CanRead fails very slowly for non-DICOM files.
      PERF: readability container size empty
      STYLE: Prefer = default to explicit constructor(){}

Jon Haitz Legarreta Gorroño (1) @jhlegarreta:
      DOC: Adjust the CoC Committee to the 01/09/2019 meeting decision.

Matthew McCormick (31) @thewtex:
      ENH: Update Azure Pipelines CI testing cache to 5.0b03
      DOC: Releasing ITK updates for 5.0b03
      BUG: Exercise BinaryMaskToNarrowBandPointSetFilterTest
      BUG: BinaryMaskToNarrowBandPointSetFilter GenerateData protected
      BUG: Remove unused FixedDensityFunction in JensenHavrdaChatvatTsallis
      BUG: Do not build/use PoolMultiThreader without WinThreads or PThreads
      BUG: ShapeDetectionLevelSetFilter outputs
      BUG: ShapeDetectionLevelSetFilter outputFileName
      COMP: Remove itk::ThreadPool::GetGlobalDefaultNumberOfThreadsByPlatform
      DOC: Add 5.0 Beta 3 release notes
      DOC: Fix link to UpdatingThirdParty.md in CONTRIBUTING.md
      ENH: Add wrapping for BinaryMaskToNarrowBandPointSetFilter
      COMP: Mark DCMTKImageIO::CanWriteFile argument as unused
      COMP: Fix Software Guide line length too long warnings
      COMP: Fix Software Guide line length too long warnings
      ENH: Use CompensatedSummation in point set metrics to improve robustness
      COMP: ShapedImageNeighborhoodRangeGTest array initialization
      ENH: Move Gifti Mesh IO into a separate module
      ENH: Consistency in wrapped mesh types
      PERF: Parallelize ManifoldParzenWidnowsPointSetFunction::SetInputPointSet
      ENH: Move OBJ Mesh IO into a separate module
      ENH: Migrate OFF IO into ITKIOMeshOFF
      ENH: Update IOSTL to 2019-01-16 master
      COMP: Do not use readNoPreambleDICOM with Emscripten
      BUG: Fix Azure Pipelines commit checkout
      BUG: Fix Azure Pipelines master checkout on Windows
      BUG: Default MeshIOBase PointDimension is 3
      ENH: Update IOMeshSTL remote module and update name
      ENH: Improve loading to help pyinstaller can analyze module dependencies
      COMP: Wrapping of VectorContainer and DefaultStaticMeshTraits
      ENH: Add legacy multi-frame DICOM MD5 content links

Niels Dekker (19) @N-Dekker:
      DOC: issue #273: SyNImageRegistrationMethod default member initializers
      STYLE: Small improvements ImageBase constructor, SetRequestedRegion, '\'
      COMP: Fix "unreachable code" MakeOutput RegistrationMethods
      PERF: N4BiasFieldCorrectionImageFilter implementation using ImageRange
      STYLE: Renamed ImageRange to ImageBufferRange
      PERF: Remove SystemInformation data from ResourceProbe, fix issue #350
      STYLE: Remove dynamic_cast from CastToSTLContainer(), add noexcept
      PERF: N4BiasFieldCorrectionImageFilter adds points + weights ~20% faster
      PERF: Fast assign point data, weights BSplineScatteredData filter
      COMP: ImageBufferRange iterator same as const_iterator, for const image
      PERF: BSplineDecompositionImageFilter now calls ImageAlgorithm::Copy
      ENH: Add default-constructor and empty() to ShapedImageNeighborhoodRange
      ENH: Made ShapedImageNeighborhoodRange assignable and tested copy + move
      STYLE: C++ "Rule of Zero" for iterator classes of Range types
      PERF: Add fast noexcept move semantics to Neighborhood and its Allocator
      BUG: ResourceProbe::Reset() should set m_MaximumValue to lowest value
      BUG: Fixed MoveAssignedRangeHasSameIterators GTest of two range types
      STYLE: Move test utils default-constructed ranges to RangeGTestUtilities
      ENH: Add default-constructor and empty() to IndexRange

Pablo Hernandez-Cerdan (14) @phcerdan:
      DOC: Fix doxygen in SymmetricEigenAnalysis
      ENH: Python, wrap complex in NumericTraits
      ENH: Update IsotropicWavelets module
      BUG: Fix failure of ITK_EIGEN macro expansion
      ENH: Add test checking noexcept moves in FixedArray
      STYLE: Change EXPECT_EQ to EXPECT_TRUE|FALSE in CommonTypeTraitGTest
      ENH: Add python wrapping for std::pair and other int containers
      ENH: Add internal/external eigen3 libraries
      ENH: Update IsotropicWavelets
      ENH: Add new c++11 member functions of std::vector to itk::VectorContainer
      ENH: Simplify specialization of NumericTraits<std::complex<TComponent>>
      BUG: itkMatrix: Use NumericTraits::Zero instead of literal 0
      DOC: SoftwareGuide: improve TransformIndexToPhysicalPoint notation
      COMP: Fix multi-line comment warning generated by latex notation

Roman Grothausmann (1) @romangrothausmann:
      BUG: avoid overwriting output in 2nd run used for comparison in test:

Simon Rit (1) @SimonRit:
      BUG: python itk.Image returned by GetImageFromArray now manages its own buffer

@ihnorton (1):
      COMP: use HDF5 library names only to avoid abspaths w/ SYSTEM_HDF5
```
