#!/usr/bin/env bats

. ./resilience/shared_config

write_bad_policies() {
    policy_dir="/etc/crypto-policies/policies"
    cat > "${policy_dir}"/NULL.pol << EOF
mac = NULL
cipher = NULL
ssh_certs = NULL
group = NULL
key_exchange = NULL
EOF

    cat > "${policy_dir}"/NON_EXISTENT_TLS.pol << EOF
protocol@TLS = TLSv1.05
EOF

    cat > "${policy_dir}"/NON_EXISTENT_MAC.pol << EOF
mac = BIGMAC
EOF
}

setup_file() {
    mkdir -p /etc/crypto-policies/policies
    write_bad_policies
}

@test "Resilience test: NULL policy is rejected" {
    run update-crypto-policies --set NULL
    [ "$status" -ne 0 ]
    [[ "$output" == *"Error"* ]]
}

@test "Resilience test: NON_EXISTENT_TLS policy is rejected" {
    run update-crypto-policies --set NON_EXISTENT_TLS
    [ "$status" -ne 0 ]
    [[ "$output" == *"Error"* ]]
}

@test "Resilience test: NON_EXISTENT_MAC policy is rejected" {
    run update-crypto-policies --set NON_EXISTENT_MAC
    [ "$status" -ne 0 ]
    [[ "$output" == *"Error"* ]]
}
