from __future__ import absolute_import, division, print_function
import os
from libtbx import easy_run

pdb_str_1 = '''
CRYST1  230.463  123.139  153.201  90.00 131.05  90.00 C 1 2 1
SCALE1      0.004339  0.000000  0.003779        0.00000
SCALE2      0.000000  0.008121  0.000000        0.00000
SCALE3      0.000000  0.000000  0.008655        0.00000
ATOM      1  N   CYS A 861     -12.347 -25.689  76.808  1.00127.20           N
ATOM      2  CA  CYS A 861     -13.104 -25.567  78.048  1.00133.90           C
ATOM      3  C   CYS A 861     -14.052 -26.748  78.202  1.00134.10           C
ATOM      4  O   CYS A 861     -14.691 -27.168  77.239  1.00131.28           O
ATOM      5  CB  CYS A 861     -13.889 -24.252  78.073  1.00135.25           C
ATOM      6  SG  CYS A 861     -14.037 -23.445  79.699  1.00155.43           S
ATOM      7  N   CYS A 864     -17.542 -24.913  77.978  1.00139.78           N
ATOM      8  CA  CYS A 864     -17.949 -24.175  76.780  1.00132.76           C
ATOM      9  C   CYS A 864     -17.994 -25.041  75.522  1.00125.77           C
ATOM     10  O   CYS A 864     -18.762 -24.765  74.604  1.00125.97           O
ATOM     11  CB  CYS A 864     -17.017 -22.980  76.533  1.00134.20           C
ATOM     12  SG  CYS A 864     -16.835 -21.826  77.907  1.00126.17           S
ATOM     13  N   CYS A1054     -20.150 -20.841  82.906  1.00100.48           N
ATOM     14  CA  CYS A1054     -18.688 -20.783  82.915  1.00101.74           C
ATOM     15  C   CYS A1054     -18.182 -19.501  83.572  1.00103.40           C
ATOM     16  O   CYS A1054     -18.656 -18.409  83.261  1.00107.65           O
ATOM     17  CB  CYS A1054     -18.128 -20.893  81.493  1.00111.10           C
ATOM     18  SG  CYS A1054     -16.308 -20.868  81.398  1.00 99.22           S
ATOM     19  N   HIS A1060     -13.988 -16.716  77.115  1.00102.85           N
ATOM     20  CA  HIS A1060     -14.171 -17.807  76.158  1.00107.46           C
ATOM     21  C   HIS A1060     -14.871 -17.324  74.890  1.00101.11           C
ATOM     22  O   HIS A1060     -14.674 -17.888  73.814  1.00 96.36           O
ATOM     23  CB  HIS A1060     -14.975 -18.973  76.754  1.00122.04           C
ATOM     24  CG  HIS A1060     -14.199 -19.831  77.706  1.00131.75           C
ATOM     25  ND1 HIS A1060     -14.110 -19.567  79.055  1.00134.67           N
ATOM     26  CD2 HIS A1060     -13.424 -20.921  77.487  1.00136.31           C
ATOM     27  CE1 HIS A1060     -13.342 -20.474  79.633  1.00135.85           C
ATOM     28  NE2 HIS A1060     -12.911 -21.303  78.702  1.00135.21           N
TER
HETATM   29 ZN    ZN A2083     -15.163 -21.423  79.459  1.00340.34          Zn
END
'''

pdb_str_2 = """
ATOM  41609  N   ARG L 107     336.348 327.647 268.798  1.00 73.69           N
ATOM  41610  CA  ARG L 107     336.367 326.308 269.396  1.00 76.13           C
ATOM  41611  C   ARG L 107     337.373 325.330 268.764  1.00 75.15           C
ATOM  41612  O   ARG L 107     337.457 324.176 269.202  1.00 76.91           O
ATOM  41613  CB  ARG L 107     334.965 325.692 269.478  1.00 75.62           C
ATOM  41614  CG  ARG L 107     334.342 325.248 268.174  1.00 76.45           C
ATOM  41615  CD  ARG L 107     333.520 324.002 268.423  1.00 80.59           C
ATOM  41616  NE  ARG L 107     332.567 323.744 267.356  1.00 87.69           N
ATOM  41617  CZ  ARG L 107     331.720 322.715 267.332  1.00 96.82           C
ATOM  41618  NH1 ARG L 107     330.884 322.582 266.304  1.00102.01           N
ATOM  41619  NH2 ARG L 107     331.701 321.815 268.320  1.00 97.76           N
ATOM  41620  N   CYS L 108     338.113 325.778 267.745  1.00 68.92           N
ATOM  41621  CA  CYS L 108     339.312 325.068 267.300  1.00 64.76           C
ATOM  41622  C   CYS L 108     340.555 325.418 268.121  1.00 66.03           C
ATOM  41623  O   CYS L 108     341.588 324.784 267.939  1.00 66.50           O
ATOM  41624  CB  CYS L 108     339.571 325.286 265.807  1.00 60.82           C
ATOM  41625  SG  CYS L 108     338.793 324.031 264.774  1.00 56.51           S
ATOM  41680  N   ASN L 116     342.905 314.996 273.851  1.00112.83           N
ATOM  41681  CA  ASN L 116     344.311 315.272 274.097  1.00113.37           C
ATOM  41682  C   ASN L 116     344.432 316.763 274.355  1.00106.26           C
ATOM  41683  O   ASN L 116     343.923 317.563 273.570  1.00102.97           O
ATOM  41684  CB  ASN L 116     345.154 314.869 272.887  1.00121.54           C
ATOM  41685  CG  ASN L 116     346.648 315.017 273.127  1.00128.12           C
ATOM  41686  OD1 ASN L 116     347.393 315.391 272.221  1.00132.40           O
ATOM  41687  ND2 ASN L 116     347.094 314.722 274.346  1.00130.54           N
ATOM  41688  N   GLY L 117     345.092 317.133 275.451  1.00102.26           N
ATOM  41689  CA  GLY L 117     345.198 318.535 275.858  1.00101.43           C
ATOM  41690  C   GLY L 117     345.994 319.377 274.878  1.00 98.56           C
ATOM  41691  O   GLY L 117     347.182 319.633 275.090  1.00103.03           O
ATOM  41692  N   SER L 118     345.330 319.796 273.801  1.00 90.19           N
ATOM  41693  CA  SER L 118     345.968 320.564 272.726  1.00 84.20           C
ATOM  41694  C   SER L 118     344.932 321.312 271.890  1.00 75.48           C
ATOM  41695  O   SER L 118     343.741 321.265 272.172  1.00 77.84           O
ATOM  41696  CB  SER L 118     346.801 319.635 271.828  1.00 86.49           C
ATOM  41697  OG  SER L 118     345.989 318.943 270.892  1.00 87.95           O
ATOM  41698  N   THR L 119     345.406 321.995 270.860  1.00 68.21           N
ATOM  41699  CA  THR L 119     344.565 322.769 269.955  1.00 65.80           C
ATOM  41700  C   THR L 119     344.114 321.858 268.822  1.00 59.53           C
ATOM  41701  O   THR L 119     344.560 320.717 268.754  1.00 59.27           O
ATOM  41702  CB  THR L 119     345.388 323.979 269.462  1.00 72.06           C
ATOM  41703  OG1 THR L 119     345.624 324.869 270.569  1.00 76.28           O
ATOM  41704  CG2 THR L 119     344.722 324.746 268.346  1.00 72.28           C
ATOM  41705  N   CYS L 120     343.196 322.319 267.971  1.00 57.56           N
ATOM  41706  CA  CYS L 120     342.863 321.598 266.735  1.00 57.89           C
ATOM  41707  C   CYS L 120     344.051 321.463 265.784  1.00 59.16           C
ATOM  41708  O   CYS L 120     344.945 322.303 265.759  1.00 57.82           O
ATOM  41709  CB  CYS L 120     341.697 322.250 265.986  1.00 56.77           C
ATOM  41710  SG  CYS L 120     341.374 321.502 264.369  1.00 53.53           S
ATOM  41711  N   ILE L 121     344.035 320.383 265.006  1.00 61.55           N
ATOM  41712  CA  ILE L 121     345.070 320.108 264.011  1.00 62.65           C
ATOM  41713  C   ILE L 121     345.134 321.190 262.946  1.00 61.66           C
ATOM  41714  O   ILE L 121     346.214 321.514 262.462  1.00 61.29           O
ATOM  41715  CB  ILE L 121     344.869 318.724 263.337  1.00 64.79           C
ATOM  41716  CG1 ILE L 121     346.106 318.329 262.529  1.00 65.49           C
ATOM  41717  CG2 ILE L 121     343.629 318.694 262.442  1.00 64.60           C
ATOM  41718  CD1 ILE L 121     346.129 316.868 262.147  1.00 66.90           C
ATOM  41719  N   CYS L 122     343.982 321.748 262.588  1.00 64.24           N
ATOM  41720  CA  CYS L 122     343.921 322.801 261.579  1.00 68.72           C
ATOM  41721  C   CYS L 122     344.962 323.861 261.847  1.00 69.64           C
ATOM  41722  O   CYS L 122     345.597 324.371 260.927  1.00 73.06           O
ATOM  41723  CB  CYS L 122     342.536 323.448 261.549  1.00 70.95           C
ATOM  41724  SG  CYS L 122     342.155 324.561 262.930  1.00 73.02           S
ATOM  41725  N   ARG L 123     345.126 324.175 263.124  1.00 71.15           N
ATOM  41726  CA  ARG L 123     346.136 325.116 263.575  1.00 74.71           C
ATOM  41727  C   ARG L 123     347.595 324.736 263.284  1.00 70.94           C
ATOM  41728  O   ARG L 123     348.470 325.599 263.344  1.00 71.25           O
ATOM  41729  CB  ARG L 123     345.940 325.391 265.069  1.00 79.46           C
ATOM  41730  CG  ARG L 123     344.986 326.540 265.348  1.00 80.30           C
ATOM  41731  CD  ARG L 123     345.803 327.781 265.628  1.00 83.36           C
ATOM  41732  NE  ARG L 123     345.075 329.006 265.380  1.00 86.55           N
ATOM  41733  CZ  ARG L 123     344.805 329.490 264.173  1.00 92.39           C
ATOM  41734  NH1 ARG L 123     345.154 328.845 263.060  1.00 94.43           N
ATOM  41735  NH2 ARG L 123     344.154 330.635 264.076  1.00 96.56           N
ATOM  41736  N   VAL L 124     347.862 323.475 262.971  1.00 67.83           N
ATOM  41737  CA  VAL L 124     349.189 323.082 262.551  1.00 69.08           C
ATOM  41738  C   VAL L 124     349.362 323.546 261.125  1.00 69.73           C
ATOM  41739  O   VAL L 124     348.516 323.247 260.286  1.00 71.78           O
ATOM  41740  CB  VAL L 124     349.425 321.564 262.597  1.00 75.61           C
ATOM  41741  CG1 VAL L 124     350.888 321.265 262.304  1.00 80.89           C
ATOM  41742  CG2 VAL L 124     349.064 320.966 263.952  1.00 79.12           C
ATOM  41743  N   PRO L 125     350.451 324.280 260.839  1.00 74.22           N
ATOM  41744  CA  PRO L 125     350.681 324.672 259.444  1.00 79.19           C
ATOM  41745  C   PRO L 125     350.948 323.471 258.534  1.00 83.23           C
ATOM  41746  O   PRO L 125     351.794 322.636 258.864  1.00 79.01           O
ATOM  41747  CB  PRO L 125     351.903 325.605 259.516  1.00 78.87           C
ATOM  41748  CG  PRO L 125     352.460 325.483 260.892  1.00 76.89           C
ATOM  41749  CD  PRO L 125     351.408 324.899 261.776  1.00 74.88           C
ATOM  41750  N   ARG L 126     350.215 323.391 257.417  1.00 93.23           N
ATOM  41751  CA  ARG L 126     350.373 322.321 256.404  1.00103.77           C
ATOM  41752  C   ARG L 126     351.818 321.836 256.299  1.00108.83           C
ATOM  41753  O   ARG L 126     352.072 320.632 256.279  1.00107.99           O
ATOM  41754  CB  ARG L 126     349.884 322.789 255.015  1.00107.19           C
ATOM  41755  CG  ARG L 126     348.492 322.304 254.586  1.00105.56           C
ATOM  41756  CD  ARG L 126     347.848 323.272 253.583  1.00104.23           C
ATOM  41757  NE  ARG L 126     346.983 322.636 252.583  1.00101.59           N
ATOM  41758  CZ  ARG L 126     346.272 323.292 251.657  1.00 98.80           C
ATOM  41759  NH1 ARG L 126     346.287 324.629 251.594  1.00 95.11           N
ATOM  41760  NH2 ARG L 126     345.523 322.604 250.788  1.00 94.57           N
ATOM  41761  N   ALA L 127     352.743 322.794 256.242  1.00117.75           N
ATOM  41762  CA  ALA L 127     354.185 322.535 256.247  1.00128.16           C
ATOM  41763  C   ALA L 127     354.633 321.442 257.215  1.00132.82           C
ATOM  41764  O   ALA L 127     355.367 320.538 256.817  1.00139.14           O
ATOM  41765  CB  ALA L 127     354.945 323.821 256.551  1.00130.58           C
ATOM  41766  N   GLN L 128     354.181 321.515 258.468  1.00132.72           N
ATOM  41767  CA  GLN L 128     354.740 320.669 259.528  1.00136.88           C
ATOM  41768  C   GLN L 128     354.199 319.249 259.411  1.00142.70           C
ATOM  41769  O   GLN L 128     354.960 318.259 259.431  1.00147.09           O
ATOM  41770  CB  GLN L 128     354.424 321.259 260.902  1.00132.51           C
ATOM  41771  CG  GLN L 128     355.284 320.701 262.024  1.00132.58           C
ATOM  41772  CD  GLN L 128     355.031 321.381 263.359  1.00135.91           C
ATOM  41773  OE1 GLN L 128     354.731 322.576 263.421  1.00136.01           O
ATOM  41774  NE2 GLN L 128     355.158 320.620 264.440  1.00139.88           N
ATOM  41775  N   LEU L 129     352.879 319.186 259.255  1.00144.90           N
ATOM  41776  CA  LEU L 129     352.165 317.909 259.079  1.00148.05           C
ATOM  41777  C   LEU L 129     352.701 317.176 257.861  1.00160.65           C
ATOM  41778  O   LEU L 129     352.972 315.965 257.917  1.00169.37           O
ATOM  41779  CB  LEU L 129     350.666 318.131 258.881  1.00138.19           C
ATOM  41780  CG  LEU L 129     349.894 318.599 260.107  1.00131.29           C
ATOM  41781  CD1 LEU L 129     348.548 319.171 259.692  1.00128.46           C
ATOM  41782  CD2 LEU L 129     349.732 317.471 261.115  1.00131.02           C
ATOM  41783  N   GLU L 130     352.842 317.937 256.779  1.00168.55           N
ATOM  41784  CA  GLU L 130     353.342 317.410 255.501  1.00178.63           C
ATOM  41785  C   GLU L 130     354.727 316.810 255.692  1.00178.61           C
ATOM  41786  O   GLU L 130     355.008 315.700 255.213  1.00181.96           O
ATOM  41787  CB  GLU L 130     353.390 318.514 254.439  1.00192.08           C
ATOM  41788  CG  GLU L 130     353.832 318.059 253.052  1.00205.27           C
ATOM  41789  CD  GLU L 130     353.694 319.147 251.999  1.00216.41           C
ATOM  41790  OE1 GLU L 130     353.991 320.324 252.301  1.00219.33           O
ATOM  41791  OE2 GLU L 130     353.295 318.822 250.860  1.00221.86           O
ATOM  41792  N   GLU L 131     355.564 317.567 256.392  1.00184.22           N
ATOM  41793  CA  GLU L 131     356.945 317.166 256.684  1.00195.20           C
ATOM  41794  C   GLU L 131     356.957 315.838 257.434  1.00193.99           C
ATOM  41795  O   GLU L 131     357.723 314.922 257.095  1.00195.22           O
ATOM  41796  CB  GLU L 131     357.689 318.251 257.476  1.00203.89           C
ATOM  41797  CG  GLU L 131     359.202 318.071 257.527  1.00210.24           C
ATOM  41798  CD  GLU L 131     359.947 319.363 257.839  1.00211.87           C
ATOM  41799  OE1 GLU L 131     359.450 320.166 258.658  1.00213.20           O
ATOM  41800  OE2 GLU L 131     361.037 319.574 257.266  1.00209.81           O
ATOM  41801  N   GLU L 132     356.095 315.773 258.441  1.00198.20           N
ATOM  41802  CA  GLU L 132     355.953 314.582 259.288  1.00210.00           C
ATOM  41803  C   GLU L 132     355.590 313.372 258.434  1.00212.98           C
ATOM  41804  O   GLU L 132     356.179 312.289 258.581  1.00214.87           O
ATOM  41805  CB  GLU L 132     354.918 314.777 260.411  1.00219.10           C
ATOM  41806  CG  GLU L 132     355.523 315.116 261.768  1.00226.96           C
ATOM  41807  CD  GLU L 132     356.331 313.977 262.376  1.00231.60           C
ATOM  41808  OE1 GLU L 132     355.887 312.810 262.305  1.00231.32           O
ATOM  41809  OE2 GLU L 132     357.413 314.253 262.937  1.00234.06           O
ATOM  41810  N   ALA L 133     354.620 313.595 257.557  1.00219.78           N
ATOM  41811  CA  ALA L 133     354.121 312.563 256.643  1.00226.27           C
ATOM  41812  C   ALA L 133     355.263 312.032 255.779  1.00226.20           C
ATOM  41813  O   ALA L 133     355.428 310.813 255.617  1.00225.84           O
ATOM  41814  CB  ALA L 133     352.992 313.098 255.772  1.00230.45           C
ATOM  41815  N   ARG L 134     356.027 312.976 255.248  1.00224.89           N
ATOM  41816  CA  ARG L 134     357.175 312.679 254.384  1.00223.99           C
ATOM  41817  C   ARG L 134     358.174 311.797 255.127  1.00222.38           C
ATOM  41818  O   ARG L 134     358.663 310.790 254.589  1.00223.69           O
ATOM  41819  CB  ARG L 134     357.817 313.979 253.889  1.00227.22           C
ATOM  41820  CG  ARG L 134     358.955 313.807 252.896  1.00230.13           C
ATOM  41821  CD  ARG L 134     359.198 315.089 252.105  1.00232.93           C
ATOM  41822  NE  ARG L 134     360.621 315.406 251.973  1.00236.77           N
ATOM  41823  CZ  ARG L 134     361.384 315.953 252.924  1.00237.39           C
ATOM  41824  NH1 ARG L 134     360.890 316.255 254.127  1.00233.02           N
ATOM  41825  NH2 ARG L 134     362.669 316.195 252.672  1.00242.00           N
ATOM  41826  N   LYS L 135     358.447 312.202 256.361  1.00219.78           N
ATOM  41827  CA  LYS L 135     359.382 311.494 257.242  1.00219.95           C
ATOM  41828  C   LYS L 135     358.927 310.054 257.442  1.00216.67           C
ATOM  41829  O   LYS L 135     359.728 309.112 257.342  1.00217.41           O
ATOM  41830  CB  LYS L 135     359.537 312.198 258.597  1.00224.43           C
ATOM  41831  CG  LYS L 135     360.319 313.501 258.539  1.00235.13           C
ATOM  41832  CD  LYS L 135     361.820 313.265 258.445  1.00244.36           C
ATOM  41833  CE  LYS L 135     362.598 314.571 258.513  1.00250.04           C
ATOM  41834  NZ  LYS L 135     362.299 315.485 257.374  1.00251.38           N
ATOM  41835  N   LYS L 136     357.634 309.921 257.714  1.00216.69           N
ATOM  41836  CA  LYS L 136     357.000 308.621 257.949  1.00216.81           C
ATOM  41837  C   LYS L 136     357.030 307.659 256.752  1.00214.11           C
ATOM  41838  O   LYS L 136     357.563 306.548 256.836  1.00213.14           O
ATOM  41839  CB  LYS L 136     355.571 308.774 258.487  1.00220.08           C
ATOM  41840  CG  LYS L 136     355.512 309.381 259.888  1.00224.22           C
ATOM  41841  CD  LYS L 136     354.767 308.502 260.886  1.00228.88           C
ATOM  41842  CE  LYS L 136     353.275 308.441 260.599  1.00233.74           C
ATOM  41843  NZ  LYS L 136     352.538 307.685 261.651  1.00232.90           N
ATOM  41844  N   GLY L 137     356.456 308.128 255.646  1.00214.82           N
ATOM  41845  CA  GLY L 137     356.225 307.318 254.449  1.00217.82           C
ATOM  41846  C   GLY L 137     354.863 307.608 253.838  1.00218.27           C
ATOM  41847  O   GLY L 137     354.728 307.678 252.614  1.00219.44           O
ATOM  41848  N   THR L 138     353.856 307.771 254.700  1.00212.51           N
ATOM  41849  CA  THR L 138     352.483 308.087 254.276  1.00205.76           C
ATOM  41850  C   THR L 138     352.329 309.488 253.664  1.00189.06           C
ATOM  41851  O   THR L 138     353.228 310.326 253.750  1.00191.76           O
ATOM  41852  CB  THR L 138     351.476 307.928 255.446  1.00208.89           C
ATOM  41853  OG1 THR L 138     350.135 307.982 254.942  1.00211.23           O
ATOM  41854  CG2 THR L 138     351.662 309.017 256.516  1.00209.11           C
ATOM  41855  N   GLN L 139     351.170 309.716 253.050  1.00167.14           N
ATOM  41856  CA  GLN L 139     350.845 310.989 252.401  1.00156.67           C
ATOM  41857  C   GLN L 139     350.213 311.928 253.433  1.00153.10           C
ATOM  41858  O   GLN L 139     350.154 311.588 254.617  1.00150.87           O
ATOM  41859  CB  GLN L 139     349.913 310.752 251.202  1.00158.66           C
ATOM  41860  CG  GLN L 139     350.597 310.133 249.989  1.00167.24           C
ATOM  41861  CD  GLN L 139     350.944 308.664 250.170  1.00173.83           C
ATOM  41862  OE1 GLN L 139     351.970 308.325 250.761  1.00175.13           O
ATOM  41863  NE2 GLN L 139     350.095 307.784 249.648  1.00177.64           N
ATOM  41864  N   VAL L 140     349.758 313.106 252.995  1.00155.40           N
ATOM  41865  CA  VAL L 140     349.120 314.084 253.896  1.00154.21           C
ATOM  41866  C   VAL L 140     347.881 313.470 254.558  1.00136.02           C
ATOM  41867  O   VAL L 140     346.968 312.978 253.890  1.00127.48           O
ATOM  41868  CB  VAL L 140     348.764 315.414 253.180  1.00167.65           C
ATOM  41869  CG1 VAL L 140     347.959 316.337 254.099  1.00173.32           C
ATOM  41870  CG2 VAL L 140     350.031 316.121 252.705  1.00169.90           C
ATOM  41871  N   SER L 141     347.867 313.543 255.881  1.00123.31           N
ATOM  41872  CA  SER L 141     347.078 312.647 256.713  1.00119.75           C
ATOM  41873  C   SER L 141     345.648 313.110 256.960  1.00114.75           C
ATOM  41874  O   SER L 141     344.712 312.315 256.845  1.00111.46           O
ATOM  41875  CB  SER L 141     347.800 312.469 258.047  1.00124.39           C
ATOM  41876  OG  SER L 141     348.391 313.694 258.461  1.00124.59           O
ATOM  41877  N   PHE L 142     345.493 314.383 257.324  1.00107.21           N
ATOM  41878  CA  PHE L 142     344.184 314.954 257.656  1.00 99.09           C
ATOM  41879  C   PHE L 142     343.765 315.964 256.593  1.00 94.73           C
ATOM  41880  O   PHE L 142     344.612 316.585 255.948  1.00 92.13           O
ATOM  41881  CB  PHE L 142     344.212 315.598 259.057  1.00 95.68           C
ATOM  41882  CG  PHE L 142     344.079 317.094 259.049  1.00 92.98           C
ATOM  41883  CD1 PHE L 142     345.192 317.898 258.881  1.00 93.95           C
ATOM  41884  CD2 PHE L 142     342.836 317.697 259.202  1.00 93.03           C
ATOM  41885  CE1 PHE L 142     345.076 319.280 258.863  1.00 94.14           C
ATOM  41886  CE2 PHE L 142     342.711 319.075 259.178  1.00 92.77           C
ATOM  41887  CZ  PHE L 142     343.834 319.870 259.009  1.00 92.90           C
ATOM  41888  N   HIS L 143     342.455 316.132 256.441  1.00 97.02           N
ATOM  41889  CA  HIS L 143     341.885 317.071 255.482  1.00102.86           C
ATOM  41890  C   HIS L 143     341.237 318.249 256.187  1.00104.68           C
ATOM  41891  O   HIS L 143     341.656 319.391 255.994  1.00109.67           O
ATOM  41892  CB  HIS L 143     340.882 316.349 254.597  1.00107.27           C
ATOM  41893  CG  HIS L 143     341.479 315.195 253.864  1.00114.98           C
ATOM  41894  ND1 HIS L 143     341.960 315.303 252.577  1.00121.22           N
ATOM  41895  CD2 HIS L 143     341.709 313.919 254.249  1.00116.63           C
ATOM  41896  CE1 HIS L 143     342.444 314.135 252.194  1.00125.37           C
ATOM  41897  NE2 HIS L 143     342.308 313.280 253.191  1.00123.46           N
ATOM  41898  N   GLN L 144     340.232 317.968 257.011  1.00102.51           N
ATOM  41899  CA  GLN L 144     339.503 319.006 257.740  1.00102.14           C
ATOM  41900  C   GLN L 144     339.005 318.462 259.070  1.00 98.63           C
ATOM  41901  O   GLN L 144     338.713 317.270 259.190  1.00 99.59           O
ATOM  41902  CB  GLN L 144     338.342 319.541 256.899  1.00105.77           C
ATOM  41903  CG  GLN L 144     337.423 318.467 256.332  1.00110.01           C
ATOM  41904  CD  GLN L 144     336.457 318.994 255.283  1.00114.88           C
ATOM  41905  OE1 GLN L 144     335.969 318.235 254.444  1.00115.67           O
ATOM  41906  NE2 GLN L 144     336.175 320.294 255.322  1.00116.87           N
ATOM  41907  N   CYS L 145     338.912 319.344 260.063  1.00 94.97           N
ATOM  41908  CA  CYS L 145     338.541 318.949 261.422  1.00 92.47           C
ATOM  41909  C   CYS L 145     337.032 318.807 261.564  1.00 88.78           C
ATOM  41910  O   CYS L 145     336.270 319.314 260.742  1.00 89.04           O
ATOM  41911  CB  CYS L 145     339.074 319.959 262.435  1.00 93.38           C
ATOM  41912  SG  CYS L 145     338.049 321.426 262.672  1.00 97.07           S
ATOM  41913  N   VAL L 146     336.612 318.122 262.618  1.00 89.59           N
ATOM  41914  CA  VAL L 146     335.190 317.849 262.835  1.00 97.99           C
ATOM  41915  C   VAL L 146     334.398 319.000 263.462  1.00 96.68           C
ATOM  41916  O   VAL L 146     333.166 318.953 263.489  1.00 97.13           O
ATOM  41917  CB  VAL L 146     334.960 316.565 263.666  1.00109.04           C
ATOM  41918  CG1 VAL L 146     335.631 315.371 262.988  1.00111.68           C
ATOM  41919  CG2 VAL L 146     335.413 316.732 265.119  1.00111.82           C
ATOM  41920  N   HIS L 147     335.088 320.021 263.962  1.00 95.17           N
ATOM  41921  CA  HIS L 147     334.418 321.215 264.480  1.00 96.80           C
ATOM  41922  C   HIS L 147     333.901 322.099 263.346  1.00 93.23           C
ATOM  41923  O   HIS L 147     332.735 322.503 263.326  1.00 90.92           O
ATOM  41924  CB  HIS L 147     335.378 322.028 265.338  1.00101.07           C
ATOM  41925  CG  HIS L 147     335.863 321.300 266.546  1.00105.50           C
ATOM  41926  ND1 HIS L 147     335.020 320.908 267.562  1.00109.67           N
ATOM  41927  CD2 HIS L 147     337.103 320.898 266.905  1.00112.15           C
ATOM  41928  CE1 HIS L 147     335.721 320.292 268.496  1.00118.95           C
ATOM  41929  NE2 HIS L 147     336.988 320.272 268.122  1.00120.41           N
ATOM  41930  N   CYS L 148     334.801 322.398 262.418  1.00 90.56           N
ATOM  41931  CA  CYS L 148     334.536 323.276 261.291  1.00 88.35           C
ATOM  41932  C   CYS L 148     335.420 322.848 260.130  1.00 93.31           C
ATOM  41933  O   CYS L 148     336.536 322.377 260.342  1.00 95.93           O
ATOM  41934  CB  CYS L 148     334.872 324.701 261.685  1.00 84.75           C
ATOM  41935  SG  CYS L 148     336.541 324.858 262.342  1.00 79.52           S
ATOM  41936  N   GLY L 149     334.935 323.001 258.906  1.00 95.38           N
ATOM  41937  CA  GLY L 149     335.735 322.645 257.740  1.00 98.14           C
ATOM  41938  C   GLY L 149     336.860 323.652 257.622  1.00101.01           C
ATOM  41939  O   GLY L 149     336.603 324.802 257.259  1.00104.12           O
ATOM  41940  N   CYS L 150     338.090 323.242 257.957  1.00 99.57           N
ATOM  41941  CA  CYS L 150     339.243 324.167 257.968  1.00 99.81           C
ATOM  41942  C   CYS L 150     340.562 323.546 257.510  1.00 98.81           C
ATOM  41943  O   CYS L 150     341.485 323.322 258.299  1.00 93.05           O
ATOM  41944  CB  CYS L 150     339.390 324.814 259.342  1.00 97.02           C
ATOM  41945  SG  CYS L 150     339.376 323.663 260.725  1.00 94.12           S
TER
HETATM63121 MG    MG E1001     295.718 292.507 293.803  1.00 58.72          MG
TER
HETATM63122 MG    MG V 201     294.595 288.583 291.518  1.00 85.44          MG
TER
HETATM63123 ZN    ZN D1001     283.981 265.709 279.324  1.00109.36          ZN
TER
HETATM63156 ZN    ZN L1000     337.686 325.976 263.586  1.00 31.11          ZN
HETATM63157 ZN    ZN L1001     340.645 325.701 261.809  1.00 38.33          ZN
HETATM63158 ZN    ZN L1002     340.121 322.858 263.346  1.00 15.24          ZN
TER
HETATM63159 ZN    ZN M1000     332.230 304.393 250.913  1.00 43.73          ZN
TER
HETATM63160 ZN    ZN N 401     334.845 288.168 279.963  1.00 74.70          ZN
HETATM63161 ZN    ZN N 402     347.697 291.810 270.128  1.00213.52          ZN
TER
END
"""

def main():
  for i, pdb_str in enumerate([pdb_str_1, pdb_str_2]):
    print (i)
    fn = 'tst_mcl_%d.pdb'%i
    with open(fn, 'w') as f:
      f.write(pdb_str)
    cmd = 'phenix.pdb_interpretation %s write_geo=true'%fn
    print (cmd)
    rc = easy_run.go(cmd)
    assert os.path.exists('%s.geo'%fn)
    assert not rc.return_code

if __name__ == '__main__':
  main()
  print('OK')
