// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{RenderNode, ffi};
use glib::{prelude::*, translate::*};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
    pub struct RenderReplay(Boxed<ffi::GskRenderReplay>);

    match fn {
        copy => |ptr| glib::gobject_ffi::g_boxed_copy(ffi::gsk_render_replay_get_type(), ptr as *mut _) as *mut ffi::GskRenderReplay,
        free => |ptr| glib::gobject_ffi::g_boxed_free(ffi::gsk_render_replay_get_type(), ptr as *mut _),
        type_ => || ffi::gsk_render_replay_get_type(),
    }
}

impl RenderReplay {
    #[doc(alias = "gsk_render_replay_new")]
    pub fn new() -> RenderReplay {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gsk_render_replay_new()) }
    }

    #[doc(alias = "gsk_render_replay_default")]
    #[allow(clippy::should_implement_trait)]
    pub fn default(&mut self, node: impl AsRef<RenderNode>) -> Option<RenderNode> {
        unsafe {
            from_glib_full(ffi::gsk_render_replay_default(
                self.to_glib_none_mut().0,
                node.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gsk_render_replay_filter_font")]
    pub fn filter_font(&mut self, font: &impl IsA<pango::Font>) -> pango::Font {
        unsafe {
            from_glib_full(ffi::gsk_render_replay_filter_font(
                self.to_glib_none_mut().0,
                font.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gsk_render_replay_filter_node")]
    pub fn filter_node(&mut self, node: impl AsRef<RenderNode>) -> Option<RenderNode> {
        unsafe {
            from_glib_full(ffi::gsk_render_replay_filter_node(
                self.to_glib_none_mut().0,
                node.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gsk_render_replay_filter_texture")]
    pub fn filter_texture(&mut self, texture: &impl IsA<gdk::Texture>) -> gdk::Texture {
        unsafe {
            from_glib_full(ffi::gsk_render_replay_filter_texture(
                self.to_glib_none_mut().0,
                texture.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gsk_render_replay_foreach_node")]
    pub fn foreach_node(&mut self, node: impl AsRef<RenderNode>) {
        unsafe {
            ffi::gsk_render_replay_foreach_node(
                self.to_glib_none_mut().0,
                node.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gsk_render_replay_set_font_filter")]
    pub fn set_font_filter(
        &mut self,
        filter: Option<Box_<dyn Fn(&RenderReplay, &pango::Font) -> pango::Font + 'static>>,
    ) {
        let filter_data: Box_<
            Option<Box_<dyn Fn(&RenderReplay, &pango::Font) -> pango::Font + 'static>>,
        > = Box_::new(filter);
        unsafe extern "C" fn filter_func(
            replay: *mut ffi::GskRenderReplay,
            font: *mut pango::ffi::PangoFont,
            user_data: glib::ffi::gpointer,
        ) -> *mut pango::ffi::PangoFont {
            unsafe {
                let replay = from_glib_borrow(replay);
                let font = from_glib_borrow(font);
                let callback = &*(user_data
                    as *mut Option<
                        Box_<dyn Fn(&RenderReplay, &pango::Font) -> pango::Font + 'static>,
                    >);
                if let Some(ref callback) = *callback {
                    callback(&replay, &font)
                } else {
                    panic!("cannot get closure...")
                }
                .to_glib_full()
            }
        }
        let filter = if filter_data.is_some() {
            Some(filter_func as _)
        } else {
            None
        };
        unsafe extern "C" fn user_destroy_func(data: glib::ffi::gpointer) {
            unsafe {
                let _callback = Box_::from_raw(
                    data as *mut Option<
                        Box_<dyn Fn(&RenderReplay, &pango::Font) -> pango::Font + 'static>,
                    >,
                );
            }
        }
        let destroy_call3 = Some(user_destroy_func as _);
        let super_callback0: Box_<
            Option<Box_<dyn Fn(&RenderReplay, &pango::Font) -> pango::Font + 'static>>,
        > = filter_data;
        unsafe {
            ffi::gsk_render_replay_set_font_filter(
                self.to_glib_none_mut().0,
                filter,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "gsk_render_replay_set_node_filter")]
    pub fn set_node_filter(
        &mut self,
        filter: Option<Box_<dyn Fn(&RenderReplay, &RenderNode) -> Option<RenderNode> + 'static>>,
    ) {
        let filter_data: Box_<
            Option<Box_<dyn Fn(&RenderReplay, &RenderNode) -> Option<RenderNode> + 'static>>,
        > = Box_::new(filter);
        unsafe extern "C" fn filter_func(
            replay: *mut ffi::GskRenderReplay,
            node: *mut ffi::GskRenderNode,
            user_data: glib::ffi::gpointer,
        ) -> *mut ffi::GskRenderNode {
            unsafe {
                let replay = from_glib_borrow(replay);
                let node = from_glib_borrow(node);
                let callback = &*(user_data
                    as *mut Option<
                        Box_<dyn Fn(&RenderReplay, &RenderNode) -> Option<RenderNode> + 'static>,
                    >);
                if let Some(ref callback) = *callback {
                    callback(&replay, &node)
                } else {
                    panic!("cannot get closure...")
                }
                .to_glib_full()
            }
        }
        let filter = if filter_data.is_some() {
            Some(filter_func as _)
        } else {
            None
        };
        unsafe extern "C" fn user_destroy_func(data: glib::ffi::gpointer) {
            unsafe {
                let _callback = Box_::from_raw(
                    data as *mut Option<
                        Box_<dyn Fn(&RenderReplay, &RenderNode) -> Option<RenderNode> + 'static>,
                    >,
                );
            }
        }
        let destroy_call3 = Some(user_destroy_func as _);
        let super_callback0: Box_<
            Option<Box_<dyn Fn(&RenderReplay, &RenderNode) -> Option<RenderNode> + 'static>>,
        > = filter_data;
        unsafe {
            ffi::gsk_render_replay_set_node_filter(
                self.to_glib_none_mut().0,
                filter,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "gsk_render_replay_set_node_foreach")]
    pub fn set_node_foreach(
        &mut self,
        foreach: Option<Box_<dyn Fn(&RenderReplay, &RenderNode) -> bool + 'static>>,
    ) {
        let foreach_data: Box_<Option<Box_<dyn Fn(&RenderReplay, &RenderNode) -> bool + 'static>>> =
            Box_::new(foreach);
        unsafe extern "C" fn foreach_func(
            replay: *mut ffi::GskRenderReplay,
            node: *mut ffi::GskRenderNode,
            user_data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            unsafe {
                let replay = from_glib_borrow(replay);
                let node = from_glib_borrow(node);
                let callback = &*(user_data
                    as *mut Option<Box_<dyn Fn(&RenderReplay, &RenderNode) -> bool + 'static>>);
                if let Some(ref callback) = *callback {
                    callback(&replay, &node)
                } else {
                    panic!("cannot get closure...")
                }
                .into_glib()
            }
        }
        let foreach = if foreach_data.is_some() {
            Some(foreach_func as _)
        } else {
            None
        };
        unsafe extern "C" fn user_destroy_func(data: glib::ffi::gpointer) {
            unsafe {
                let _callback = Box_::from_raw(
                    data as *mut Option<Box_<dyn Fn(&RenderReplay, &RenderNode) -> bool + 'static>>,
                );
            }
        }
        let destroy_call3 = Some(user_destroy_func as _);
        let super_callback0: Box_<
            Option<Box_<dyn Fn(&RenderReplay, &RenderNode) -> bool + 'static>>,
        > = foreach_data;
        unsafe {
            ffi::gsk_render_replay_set_node_foreach(
                self.to_glib_none_mut().0,
                foreach,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "gsk_render_replay_set_texture_filter")]
    pub fn set_texture_filter(
        &mut self,
        filter: Option<Box_<dyn Fn(&RenderReplay, &gdk::Texture) -> gdk::Texture + 'static>>,
    ) {
        let filter_data: Box_<
            Option<Box_<dyn Fn(&RenderReplay, &gdk::Texture) -> gdk::Texture + 'static>>,
        > = Box_::new(filter);
        unsafe extern "C" fn filter_func(
            replay: *mut ffi::GskRenderReplay,
            texture: *mut gdk::ffi::GdkTexture,
            user_data: glib::ffi::gpointer,
        ) -> *mut gdk::ffi::GdkTexture {
            unsafe {
                let replay = from_glib_borrow(replay);
                let texture = from_glib_borrow(texture);
                let callback = &*(user_data
                    as *mut Option<
                        Box_<dyn Fn(&RenderReplay, &gdk::Texture) -> gdk::Texture + 'static>,
                    >);
                if let Some(ref callback) = *callback {
                    callback(&replay, &texture)
                } else {
                    panic!("cannot get closure...")
                }
                .to_glib_full()
            }
        }
        let filter = if filter_data.is_some() {
            Some(filter_func as _)
        } else {
            None
        };
        unsafe extern "C" fn user_destroy_func(data: glib::ffi::gpointer) {
            unsafe {
                let _callback = Box_::from_raw(
                    data as *mut Option<
                        Box_<dyn Fn(&RenderReplay, &gdk::Texture) -> gdk::Texture + 'static>,
                    >,
                );
            }
        }
        let destroy_call3 = Some(user_destroy_func as _);
        let super_callback0: Box_<
            Option<Box_<dyn Fn(&RenderReplay, &gdk::Texture) -> gdk::Texture + 'static>>,
        > = filter_data;
        unsafe {
            ffi::gsk_render_replay_set_texture_filter(
                self.to_glib_none_mut().0,
                filter,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }
}

#[cfg(feature = "v4_22")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
impl Default for RenderReplay {
    fn default() -> Self {
        Self::new()
    }
}
