/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Ile-de-France for Mapael
* Equirectangular projection
* 
* @author CCM Benchmark Group
* @source http://fr.m.wikipedia.org/wiki/Fichier:France_location_map-Departements.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_11 : {
					width : 96.002411,
					height : 73.382225,
					getCoords : function (lat, lon) {
						var xfactor = 45.48385;
						var xoffset = -65.7919; 
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -65.97284;
						var yoffset = 3248.39348; 
						var y = (lat * yfactor) + yoffset;
						
						return {x : x, y : y};
					},
					elems : {
					    "department-95" : "m 11.93,0 c -1.36,0.63 -1.85,2.23 -1.96,3.63 -0.19,1.09 -0.45,2.2 -0.78,3.23 -0.43,1.02 -1.75,1.9 -1.36,3.12 0.78,0.37 1.82,-0.17 2.6,0.38 0.91,0.22 0.51,1.54 1.48,1.63 0.71,0.18 1.87,0.37 1.95,-0.64 0.61,-0.1 1.86,0.5 1.88,-0.53 0.55,-0.92 1.84,-0.32 2.41,0.26 0.44,0.23 1.08,0.57 0.59,1.14 -0.41,0.57 -0.26,1.87 0.58,1.85 0.41,-0.41 0.43,-1.14 1.03,-1.46 0.26,-0.35 0.73,-0.64 0.81,-0.03 0.44,1.05 1.6,1.29 2.62,1.29 0.94,-0.09 1.41,0.7 1.98,1.25 1,0.25 2.14,-0.06 3.05,-0.53 0.39,-0.5 0.96,0.42 1.39,-0.12 0.27,-0.44 0.72,-0.14 0.65,0.28 -0.09,0.79 -0.12,1.6 0.96,1.54 0.93,0.15 1.53,1.01 1.49,1.92 0.26,0.64 1.56,0.11 1.16,1.03 -0.3,1.11 -0.22,2.62 0.93,1.11 0.8,-0.91 2.07,-1.21 2.87,-2.07 -0.08,-0.66 0.67,-0.73 1.11,-0.45 0.56,0.4 1.12,0.13 1.59,-0.23 0.48,-0.16 0.83,-0.76 1.42,-0.38 0.73,0.38 1.34,1.11 2.27,0.94 0.79,0.24 1.63,0.03 2.15,-0.59 1.11,-0.61 1.96,-1.5 2.75,-2.46 0.61,-0.02 0.41,-0.57 0.05,-0.83 -0.18,-0.68 1.01,-0.39 1.2,-0.97 0.12,-0.56 1.08,-0.97 0.75,-1.56 -0.67,-0.42 0.54,-1.18 0.11,-1.79 -0.17,-0.75 -1.21,-0.81 -1.18,-1.67 0.01,-0.6 -0.95,-0.94 -0.97,-0.18 0.21,0.85 -0.78,0.7 -1.27,0.5 -0.38,-0.02 -1.01,-0.34 -0.47,-0.72 0.37,-0.67 -0.82,-0.89 -1.22,-1.24 -0.42,-0.38 -1.13,-0.08 -1.52,-0.31 -0.23,-1.29 -1.92,-0.52 -2.67,-1.25 -0.6,-0.33 -0.94,1.14 -1.31,0.12 -0.58,-0.64 -1.05,-2.13 -2.14,-1.81 -0.67,0.41 -0.38,1.63 -1.36,1.64 -0.77,0.1 -1.81,0.71 -2.49,0.19 -0.04,-0.44 0.89,-0.75 0.29,-1.22 -0.77,-0.53 -1.76,0.14 -2.52,0.37 -0.8,0.04 -0.35,-1.41 -1.39,-1.1 -0.57,-0.59 -1.79,0 -2.19,-0.74 0.14,-0.76 -0.76,-0.87 -1.23,-0.49 -1.07,0.51 -2.1,1.12 -3.06,1.78 -0.57,-0.21 -1.22,-0.36 -1.72,0.08 -1.16,0.25 -2.37,0.44 -3.49,0.72 -0.25,-0.44 -0.72,-0.81 -1.24,-0.47 -0.37,0.03 -1.01,0.63 -1.07,-0.01 -0.34,-0.41 -0.97,-0.37 -1.41,-0.67 -0.75,-0.27 -1.47,0.07 -2.14,0.32 -0.87,0 -0.85,-1.19 -1.56,-1.49 -0.42,-0.25 -0.43,-0.77 0.12,-0.81 0.79,-0.43 0.2,-1.51 -0.54,-1.52 z",
					    "department-78" : "m 6.36,10.08 c -0.71,0.14 -1.24,0.78 -2.04,0.68 -1.05,-0.1 -1.92,0.42 -2.64,1.13 -0.6,0.42 -1.34,-1.04 -1.67,0.05 -0.14,1.2 0.87,2.03 1.29,3.02 0.19,0.64 -1.17,1.4 -0.29,1.79 0.57,0.15 1.69,-0.61 1.9,0.21 -0.47,0.28 -1.23,1.16 -0.36,1.45 0.14,0.44 -0.23,1.15 0.21,1.49 0.06,0.68 1.23,0.34 1.4,1.07 0.11,0.44 -0.08,0.95 0.42,1.26 0.9,0.44 0.17,0.98 -0.05,1.6 0.11,0.5 0.91,0.2 1.12,0.71 0.37,0.5 0.31,1.24 0.89,1.62 -0.53,0.87 -0.43,2.05 -0.79,3.02 -0.01,0.64 0.49,1.13 0.56,1.74 0.52,0.4 1.6,0.64 1.56,1.45 -0.41,0.91 -1.33,1.58 -1.53,2.56 -0.67,0.47 0.28,0.92 0.73,0.98 0.5,0.53 -0.49,1.47 0.19,2.02 0.31,0.57 1.09,0.32 1.48,0.67 0.4,0.65 0.37,1.74 1.09,2.13 0.5,-0.1 0.92,-0.07 1.35,0.2 0.45,-0.06 1.13,0.11 0.85,0.71 -0.36,0.63 -0.71,1.59 0.25,1.88 0.6,0.27 1.74,-0.33 1.97,0.51 0.15,0.66 1.39,0.87 0.91,1.7 -0.53,1.67 0.3,3.45 0.98,4.9 0.63,-0.05 1.44,-0.09 1.63,0.68 0.72,1.23 2.96,1.47 3.67,0.16 -0.15,-0.4 -0.55,-0.83 -0.14,-1.27 0.94,-0.79 0.77,-2.15 1.53,-3.08 0.22,-0.32 0.8,-0.71 0.21,-1.04 -0.53,-0.26 -1.45,-0.99 -0.83,-1.59 1.14,-0.21 2.41,0.55 3.5,0.12 0.16,-0.97 0.9,-1.83 0.85,-2.85 0.18,-0.44 1.46,-0.47 0.88,-1.15 -0.69,-0.41 -0.82,-1.37 -1.63,-1.63 -0.35,-0.38 -0.29,-1.16 0.31,-1.18 0.49,-0.62 0.67,-1.65 1.64,-1.72 1.34,0.01 2.59,-1.59 1.99,-2.88 -0.37,-0.63 0.74,-0.68 1.14,-0.64 0.58,0.23 0.45,-0.61 0.97,-0.67 0.52,-0.33 1.13,-0.46 1.71,-0.41 0.46,-0.36 -0.3,-1.42 0.66,-1.06 0.37,0.09 1.47,0.03 1.01,-0.57 -0.4,-0.2 -0.77,-0.44 -0.89,-0.87 -0.34,-0.22 -0.93,-0.01 -0.98,-0.58 -0.08,-0.54 -0.55,-0.61 -0.97,-0.58 -0.72,-0.53 -0.87,-1.69 -0.43,-2.45 -0.09,-1.41 0.29,-3.11 1.73,-3.71 0.83,-0.57 0.16,-1.83 0.75,-2.54 -0.18,-0.68 -1.66,-0.13 -1.37,-1.05 -0,-0.84 -0.56,-1.7 -1.48,-1.66 -0.86,-0.06 -1.18,-0.9 -0.92,-1.63 -0.3,-0.45 -0.84,0.24 -1.27,-0.09 -0.68,-0.02 -1.11,0.7 -1.85,0.57 -0.73,0.1 -1.68,0.58 -2.14,-0.31 -0.78,-0.98 -2.12,-0.92 -3.23,-1.05 -0.65,-0.31 -0.94,-1.33 -1.61,-1.38 -0.55,0.43 -0.78,1.1 -1.04,1.66 -0.35,0.2 -1.08,0.49 -0.93,-0.22 -0.03,-0.49 -0.61,-0.74 -0.23,-1.26 0.35,-0.47 0.46,-1.27 -0.28,-1.38 -0.56,-0.16 -0.69,-0.95 -1.4,-0.85 -0.73,-0.09 -0.86,0.8 -1.23,1.16 -0.65,-0.03 -1.6,-0.3 -1.83,0.54 -0.82,0.33 -2.06,0.12 -2.61,-0.62 0.11,-1.11 -1.46,-1.45 -2.32,-1.31 -0.56,-0.09 -1.31,0.93 -1.64,0.11 -0.18,-0.19 -0.45,-0.3 -0.71,-0.28 z",
					    "department-75" : "m 41.03,21.96 c -1.27,-0.06 -2.46,0.68 -3.27,1.54 -0.47,-0.15 -0.85,0.06 -1.23,0.25 -0.65,0.03 -1.66,1.18 -0.69,1.52 0.81,0.18 0.93,1.2 1.8,1.35 1.65,0.28 3.42,1.43 5.04,0.39 1.03,-0.89 2.21,0.62 3.32,0.28 0.54,-0.43 0.45,-1.69 -0.46,-1.47 -0.48,-0.01 -1,0.18 -1.33,0.45 -0.34,-1.13 -0.06,-2.5 -0.93,-3.4 -0.12,-1.14 -1.17,-0.96 -2.05,-0.92 l -0.18,0 -0.03,3e-4 z",
					    "department-93" : "m 50.56,14.82 c -0.46,0.33 -1.14,0.34 -1.42,0.97 -0.75,1.19 -2.15,1.71 -3.14,2.62 -0.82,-0.03 -1.72,-0.07 -2.53,-0.25 -0.64,-0.37 -1.3,-1.34 -2.07,-0.64 -0.6,0.3 -1.08,1.1 -1.81,0.59 -0.35,-0.19 -1.46,-0.42 -1.19,0.3 0.56,0.53 2.05,0.32 2.05,1.33 -0.06,0.69 -1.13,1.35 -0.68,2.02 1.05,0.43 2.37,-0.21 3.34,0.37 0.27,0.54 0.5,1.08 0.89,1.55 0.18,0.57 -0.13,1.72 0.86,1.53 1.07,-0.15 2.16,-1.04 3.23,-0.34 1.04,0.72 2.32,1.35 3.05,2.37 -0.11,0.74 1.41,0.94 1.04,0.05 -0.24,-0.71 -0.92,-1.55 -0.78,-2.26 0.67,-0.23 -0.04,-0.79 -0.4,-0.87 0.27,-0.43 -0.26,-0.81 -0.29,-1.14 0.41,-0.57 1.31,-0.71 1.23,-1.58 -0.09,-0.8 0.8,-1.4 0.35,-2.19 -0.23,-0.84 -1.06,-1.46 -1.25,-2.26 0.77,-0.61 0.45,-1.99 -0.49,-2.17 z",
					    "department-94" : "m 46.91,24.73 c -0.49,0.07 -1.3,0.32 -1.34,0.88 0.31,0.21 0.98,0.04 0.93,0.64 0.02,0.59 -0.23,1.64 -1.05,1.16 -1.03,-0.16 -2.09,-1.01 -3.03,-0.14 -0.7,0.5 -1.59,0.2 -2.33,0.5 -0.4,1.12 0.01,2.46 -0.66,3.53 -0.23,0.79 0.87,0.44 1.11,1 0.42,0.39 0.99,0.13 1.33,-0.1 0.46,0.44 -0.1,1.74 0.84,1.68 0.59,-0.25 1.17,-0.38 1.79,-0.16 1.34,-0.05 2.64,-0.54 3.94,-0.71 0.51,0.63 0.39,1.61 1.15,2.11 0.31,0.19 0.6,0.29 0.75,0.66 0.59,0.31 1.27,-0.47 0.77,-1 -0.01,-0.93 1.56,-1.44 0.88,-2.44 0.5,-0.32 0.24,-1.11 0.85,-1.28 0.43,-0.58 -0.47,-0.6 -0.83,-0.71 -0.34,-0.52 0.66,-1.18 0.14,-1.69 0.12,-0.8 -1.11,-0.7 -1.2,-1.46 -1.03,-1.05 -2.26,-2.13 -3.71,-2.49 -0.1,-0.01 -0.2,-0.01 -0.31,0 z",
					    "department-92" : "m 38.29,18.77 c -2,0.52 -3.26,2.41 -5.07,3.32 -1.07,0.77 -1.1,2.2 -0.99,3.39 -0.4,0.4 -0.48,0.98 -0.25,1.53 0.01,0.71 0.73,0.52 1.15,0.65 0.16,0.65 0.67,1.01 1.28,1.14 0.25,0.33 0.49,0.67 0.86,0.85 0.32,0.72 0.72,1.57 1.66,1.53 0.78,-0.01 1.11,0.83 1.08,1.46 0.36,0.27 0.92,-0.2 1.18,0.31 0.73,-0.09 0.08,-1 0.1,-1.43 0.14,-0.72 0.7,-1.47 0.38,-2.22 -0.12,-0.62 0.28,-1.24 0.24,-1.78 -0.96,-0.79 -2.46,-0.33 -3.22,-1.42 -0.37,-0.47 -1.1,-0.68 -1.44,-1.08 0.22,-1.13 1.41,-1.83 2.5,-1.7 0.39,-0.7 1.58,-0.82 1.76,-1.68 -0.35,-0.89 1.37,-1.42 0.54,-2.3 -0.48,-0.39 -1.16,-0.56 -1.77,-0.58 z",
					    "department-91" : "m 34.3,30.57 c -0.69,0.1 -0.16,1.43 -1.02,1.13 -0.84,-0.09 -1.71,0.31 -2.03,1.08 -0.41,-0.13 -1.74,-0.1 -1.26,0.59 0.47,0.79 -0.25,1.87 -0.79,2.49 -0.73,0.67 -2.1,0.04 -2.5,1.19 -0.2,0.46 -0.39,1.02 -0.92,1.14 -0.32,0.66 0.65,0.74 0.92,1.11 -0.05,0.76 1.05,1.03 0.98,1.72 -0.03,0.71 -1.1,0.32 -1.01,1.08 0.03,0.88 -0.63,1.66 -0.8,2.51 -0.97,0.37 -2.02,0.21 -2.99,-0.02 -0.62,-0.12 -0.96,0.63 -0.37,0.94 0.36,0.45 1.07,0.52 1.46,0.78 0.27,0.76 -0.76,0.3 -0.95,0.83 -0.65,0.79 -0.86,1.82 -1.18,2.74 -0.64,0.3 -0.72,1.13 -0.08,1.51 0.31,0.3 0.21,0.81 0.53,1.07 0.11,0.67 -0.05,1.36 -0.46,1.85 0.21,0.73 1.31,0.22 1.83,0.58 0.7,0.17 -0.05,1.08 0.33,1.53 0.16,0.52 0.71,1.11 0.11,1.55 -0.57,0.81 0.16,1.57 -0.05,2.42 0.21,0.68 -1.13,0.6 -0.6,1.28 0.89,1.29 2.64,1.01 3.9,0.55 0.62,-0.55 1.75,0 2.26,-0.82 0.45,-0.44 0.7,0.07 1.02,0.28 0.52,0.16 1.64,0.25 1.45,-0.6 -0.14,-0.77 1.36,0.02 1.34,-0.84 0.28,-0.42 0.61,-1.29 1.14,-1.32 0.47,0.49 1.15,0.68 1.72,0.96 0.04,0.48 -0.01,1.47 0.56,1.44 0.24,-0.6 0.76,-0.77 1.29,-0.42 1.01,0.41 0.89,-1.65 1.93,-1.27 0.57,0.51 0.93,1.46 1.87,1.37 0.62,0.05 1.47,-0.25 1.2,-1.03 -0.31,-1.09 1.83,-0.3 1.6,-1.41 0.41,-0.42 -0.19,-1.21 0.55,-1.43 0.51,-0.51 1.62,-0.43 1.54,-1.36 0.34,-0.84 1.37,-0.08 1.82,-0.74 0.38,-0.28 1.5,0.02 0.81,-0.72 -0.26,-0.62 -0.99,-0.83 -1.35,-1.3 -0.11,-1.38 -0.22,-2.9 0.31,-4.2 0.18,-0.63 -0.38,-1.05 -0.5,-1.57 0.17,-0.57 0.21,-1.21 0.15,-1.78 0.5,-0.74 0.85,-1.57 0.83,-2.47 0.35,-0.51 1.41,-1.09 0.78,-1.79 -0.51,-0.19 -1.06,-0.89 -0.83,-1.4 0.6,-0.06 1.43,-0.62 1.06,-1.29 -0.75,-0.35 -0.08,-1.22 0.39,-1.49 0.62,0.23 1.65,-0.16 1.33,-0.94 -0.43,-0.52 -1.48,0.42 -1.61,-0.42 -0.38,-0.35 -0.91,-0.48 -1.06,-1.06 -0.36,-0.43 -0.26,-1.06 -0.62,-1.45 -0.79,0.27 -2.06,0.26 -2.61,1.03 -0.24,0.35 -0.47,-0.56 -0.85,-0.37 -0.43,0.24 -0.83,0.32 -1.23,0.03 -0.55,-0.04 -1.65,0.61 -1.71,-0.34 0.11,-0.48 -0.11,-1.26 -0.66,-0.8 -0.57,0.21 -0.86,-0.56 -1.34,-0.42 -0.28,0.27 -0.53,1.41 -1.06,0.93 -0.27,-0.41 -1.36,0.03 -1.22,-0.63 0.54,-0.61 -0.34,-1.32 -0.97,-1.24 -0.8,-0.21 -1.53,-0.76 -2.39,-0.74 z",
					    "department-77" : "m 74.17,7.94 c -0.67,0.27 -0.71,1.17 -0.32,1.68 -1.02,0.27 -2.2,-0.24 -3.18,0.06 0.12,0.6 -0.83,1.46 -1.07,0.59 0.15,-0.71 -0.65,-0.75 -1.06,-0.4 -0.61,0.64 -1.47,0.19 -2.2,0.16 -0.23,0.44 -0.85,0.32 -1.25,0.64 -0.46,0.35 -0.98,0.14 -1.14,-0.39 -0.51,-0.51 -1.32,-0.52 -1.88,-0.98 -1.1,-0.17 -1.02,1.48 -1.92,1.8 -0.63,0.51 -1.76,0.41 -1.93,-0.53 -0.46,-0.21 -1,1.16 -1.55,0.41 -0.13,-0.95 -1.04,-1.65 -1.89,-2.06 -0.56,-0.33 -1.1,-0.1 -1.49,0.31 -0.77,0.49 -1.63,1.3 -1.76,2.25 0.07,0.32 1.09,0.74 0.38,0.85 -0.82,0.33 -1.01,1.4 -1.92,1.63 -0.63,0.49 0.41,0.61 0.76,0.54 0.6,0.55 1.29,1.74 0.51,2.4 0.05,0.94 1.01,1.58 1.24,2.51 0.24,0.38 0.27,0.73 -0.1,0.98 -0.36,0.8 -0.24,1.85 -1.15,2.32 -0.49,0.38 0.16,0.78 -0.08,1.25 0.11,0.4 1.11,0.14 0.7,0.77 -0.81,0.83 0.44,1.84 0.41,2.77 0.19,0.83 0.24,1.74 -0.17,2.49 0.12,0.57 1.01,0.19 1.03,0.9 0.2,0.53 -0.64,0.4 -0.66,0.92 -0.41,0.58 0.12,1.37 -0.57,1.81 -0.52,0.46 -1.04,1.17 -0.46,1.79 0.24,0.58 0.71,1.49 -0.2,1.71 -0.57,0.06 -1.58,0.01 -1.48,0.89 0.05,0.39 0.67,0.59 0.29,1.01 -0.09,0.51 -0.44,0.82 -0.92,0.88 -0.35,0.58 0.29,0.96 0.68,1.23 0.52,0.88 -0.77,1.4 -0.88,2.17 0.04,0.26 0.62,0.37 0.2,0.6 -0.62,0.64 -0.84,1.49 -0.88,2.31 -0.44,0.7 0.16,1.29 0.28,1.94 -0.08,1.6 -0.73,3.32 -0.18,4.88 0.68,0.42 1.31,1.24 1.59,1.91 -0.65,0 -1.27,0.13 -1.77,0.53 -0.45,0.04 -1.31,-0.13 -1.09,0.63 -0.23,0.61 -1.29,0.52 -1.55,1.18 -0.49,-0.01 -0.68,0.37 -0.34,0.71 -0.29,0.38 -0.2,0.98 -0.33,1.32 -0.48,0.06 -1.83,-0.09 -1.49,0.75 0.58,0.98 1.31,1.98 0.94,3.18 -0.16,1.24 1.34,1.79 2.33,1.48 0.4,0.28 0.47,1.06 1.15,0.93 0.99,0.57 1.11,2.03 1.05,3.06 -0.76,0.56 0.1,1.97 -0.63,2.48 -0.51,-0.24 -1.33,-0.53 -1.48,0.29 -0.26,0.57 -1.54,1.71 -0.16,1.54 1.01,0.03 2.24,0.23 2.92,-0.7 0.61,-0.22 1.55,-0.35 1.95,0.25 0.96,0.45 1.97,-0.27 2.91,-0.16 0.55,0.61 1.28,1.17 2.17,0.86 1.04,-0.18 1.77,-1.03 2.73,-1.4 0.46,-0.45 -0.52,-0.82 -0.47,-1.15 0.97,-0.14 2.05,-0.3 3.04,-0.19 0.73,0.38 -0.34,1.11 -0.17,1.68 -0.09,0.9 0.96,0.76 1.43,0.36 0.99,-0.6 1.73,-1.72 3.03,-1.61 0.66,-0.06 1.69,-0.14 1.67,-1.01 0.3,-0.69 0.93,-1.1 1.52,-1.44 0.2,-0.66 0.9,-0.79 1.46,-0.82 0.8,-0.86 0.99,-2.19 1.93,-2.93 0.4,-0.69 -0.29,-1.18 -0.77,-1.48 0.1,-0.98 -0.76,-2.06 0.12,-2.88 0.66,-0.75 0.16,-2.17 1.19,-2.61 0.79,-0.17 1.61,0.04 2.35,0.2 0.48,-0.25 0.54,-1.04 1.23,-0.93 0.86,0.15 1.74,-0.8 2.5,-0.11 0.56,0.55 1.24,0.18 1.87,0.09 0.59,0.12 1.39,0.41 1.72,-0.3 0.79,-0.86 1.78,0.13 2.71,-0.01 0.74,-7e-4 1.83,-0.15 1.91,-1.05 0.4,-0.83 1.24,-0.41 1.8,-0.02 0.64,0.05 0.72,-1.01 0.55,-1.46 -0.48,-0.21 -1.44,-0.69 -0.92,-1.33 0.34,-0.6 0.44,-1.4 -0.05,-1.91 0.11,-0.45 -0.55,-0.79 -0.46,-1.11 0.53,-0.63 1.67,-0.51 2.07,-1.14 -0.08,-0.82 -0.82,-1.37 -1.09,-2.09 0.2,-0.7 1.2,-0.18 1.68,-0.19 0.67,-0.04 1.41,-0.54 1.74,-1.06 -0.05,-0.56 -0.87,-1.1 -0.6,-1.62 0.46,-0.65 1.18,-1.05 1.78,-1.48 0.09,-0.39 -0.07,-0.93 0.52,-1 0.36,-0.26 1.73,-0.29 1.36,-1.01 -0.35,-0.54 -1.2,-0.31 -1.35,-1.01 -0.49,-0.65 -1.34,-0.36 -1.86,0.06 -0.39,0.09 -1.39,0.46 -1.13,-0.31 -0.16,-0.9 -0.98,-2.23 0.26,-2.75 0.55,-0.33 0.68,-1.09 0.27,-1.53 -0.22,-0.64 0.53,-1.85 -0.25,-2.02 -0.61,0.15 -1.24,-0.18 -1.19,-0.84 -0.32,-0.59 -1.59,0.4 -1.5,-0.52 0.18,-0.47 0.03,-1.43 0.6,-1.62 0.52,0.11 1.71,-0.1 1.14,-0.85 -0.25,-0.57 -1.45,-0.23 -1.37,-0.92 0.14,-0.95 1.14,-0.06 1.7,-0.31 1,-0.07 2.38,-0.86 1.83,-2.04 -0.27,-0.68 -0.85,-0.04 -1.02,0.33 -0.39,0.07 -1.22,-0.16 -0.75,-0.67 0.35,-0.68 -0.68,-0.41 -0.89,-0.82 -0.49,-0.28 -1.16,0.13 -1.52,-0.44 -0.79,-0.15 -0.57,-1.28 -1.13,-1.74 -0.08,-0.48 0.51,-1.47 -0.3,-1.52 -0.74,0.13 -1.53,1.24 -2,0.21 -0.63,-0.47 -0.08,-1.69 -0.88,-1.92 -0.54,0.16 -1.61,0.92 -1.8,-0.04 -0.31,-0.77 -0.34,-2 -1.32,-2.14 -0.24,-0.5 -0.61,-0.89 -1.09,-1.15 -0.32,-1.06 -2.04,-0.8 -2.13,-1.93 0.21,-0.41 0.78,-0.64 0.77,-1.19 0.45,-0.35 0.16,-0.79 0.01,-1.15 0.09,-0.82 -1.29,-1.18 -0.87,-2.1 -0.14,-0.93 -1.42,-1.01 -2.18,-1.09 -0.63,0.03 -1.2,-0.36 -1.82,-0.37 z"
					}
				}
			}
		}
	);
})(jQuery);