/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.transform;

import com.github.ajalt.colormath.transform.EasingFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J0\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u001c\u0010\u0017\u001a\u00020\u0018*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0002R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/github/ajalt/colormath/transform/CubicBezierEasing;", "Lcom/github/ajalt/colormath/transform/EasingFunction;", "x1", "", "y1", "x2", "y2", "(DDDD)V", "ax", "ay", "bx", "by", "cx", "cy", "ease", "", "t", "findTFromX", "x", "sampleCurveX", "sampleCurveXDerivative", "sampleCurveY", "tangent", "approxEq", "", "b", "epsilon", "Companion", "colormath"})
final class CubicBezierEasing
implements EasingFunction {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;
    private final double cx;
    private final double cy;
    private final double bx;
    private final double by;
    private final double ax;
    private final double ay;
    @Deprecated
    public static final double EPSILON = 1.0E-7;
    @Deprecated
    public static final int NEWTON_ITERATIONS = 4;

    /*
     * Unable to fully structure code
     */
    public CubicBezierEasing(double x1, double y1, double x2, double y2) {
        super();
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        var9_5 = this.x1;
        v0 = 0.0 <= var9_5 ? var9_5 <= 1.0 : false;
        if (!v0) ** GOTO lbl-1000
        var9_5 = this.x2;
        v1 = 0.0 <= var9_5 ? var9_5 <= 1.0 : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        if (!v2) {
            $i$a$-require-CubicBezierEasing$1 = false;
            var10_7 = "Bezier x coordinates must be in the range [0, 1]";
            throw new IllegalArgumentException(var10_7.toString());
        }
        this.cx = 3.0 * this.x1;
        this.cy = 3.0 * this.y1;
        this.bx = 3.0 * (this.x2 - this.x1) - this.cx;
        this.by = 3.0 * (this.y2 - this.y1) - this.cy;
        this.ax = (double)true - this.cx - this.bx;
        this.ay = (double)true - this.cy - this.by;
    }

    private final double sampleCurveX(double t) {
        return ((this.ax * t + this.bx) * t + this.cx) * t;
    }

    private final double sampleCurveY(double t) {
        return ((this.ay * t + this.by) * t + this.cy) * t;
    }

    private final double sampleCurveXDerivative(double t) {
        return (3.0 * this.ax * t + 2.0 * this.bx) * t + this.cx;
    }

    private final double findTFromX(double x) {
        double t = x;
        for (int i = 0; i < 5; ++i) {
            double x2 = this.sampleCurveX(t);
            if (this.approxEq(x, x2, 1.0E-7)) {
                return t;
            }
            double dx = this.sampleCurveXDerivative(t);
            if (this.approxEq(dx, 0.0, 1.0E-6)) break;
            t -= (x2 - x) / dx;
        }
        double lo = 0.0;
        double hi = 1.0;
        t = x;
        if (t < lo) {
            return lo;
        }
        if (t > hi) {
            return hi;
        }
        while (lo < hi) {
            double x2 = this.sampleCurveX(t);
            if (this.approxEq(x2, x, 1.0E-7)) {
                return t;
            }
            if (x > x2) {
                lo = t;
            } else {
                hi = t;
            }
            t = (hi - lo) / 2.0 + lo;
        }
        return t;
    }

    @Override
    public float ease(float t) {
        double x = t;
        return (float)(x < 0.0 ? (this.x1 > 0.0 ? this.tangent(0.0, 0.0, this.x1, this.y1, x) : (this.x2 > 0.0 ? this.tangent(0.0, 0.0, this.x2, this.y2, x) : 0.0)) : (x > 1.0 ? (this.x2 < 1.0 ? this.tangent(this.x2, this.y2, 1.0, 1.0, x) : (this.x1 < 1.0 ? this.tangent(this.x1, this.y1, 1.0, 1.0, x) : 1.0)) : this.sampleCurveY(this.findTFromX(x))));
    }

    private final double tangent(double x1, double y1, double x2, double y2, double x) {
        return (y2 - y1) / (x2 - x1) * (x - x1) + y1;
    }

    private final boolean approxEq(double $this$approxEq, double b, double epsilon) {
        return Math.abs($this$approxEq - b) < epsilon;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/ajalt/colormath/transform/CubicBezierEasing$Companion;", "", "()V", "EPSILON", "", "NEWTON_ITERATIONS", "", "colormath"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

