/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.HueColor;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B)\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB'\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0005\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\n\u0012\b\b\u0002\u0010\u0007\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0005\u001a\u00020\n2\b\b\u0002\u0010\u0006\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0000H\u0016J\b\u0010%\u001a\u00020&H\u0016J\t\u0010'\u001a\u00020(H\u00d6\u0001J\b\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0007\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u0006\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006,"}, d2={"Lcom/github/ajalt/colormath/model/JzCzHz;", "Lcom/github/ajalt/colormath/Color;", "Lcom/github/ajalt/colormath/HueColor;", "l", "", "c", "h", "alpha", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "j", "", "(FFFF)V", "getAlpha", "()F", "getC", "getH", "getJ", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "getSpace", "()Lcom/github/ajalt/colormath/ColorSpace;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toArray", "", "toJzAzBz", "Lcom/github/ajalt/colormath/model/JzAzBz;", "toJzCzHz", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toString", "", "toXYZ", "Lcom/github/ajalt/colormath/model/XYZ;", "Companion", "colormath"})
public final class JzCzHz
implements Color,
HueColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float j;
    private final float c;
    private final float h;
    private final float alpha;
    @NotNull
    private static final List<ColorComponentInfo> components = ColorSpaceUtilsKt.polarComponentInfo("JCH");

    public JzCzHz(float j, float c, float h, float alpha) {
        this.j = j;
        this.c = c;
        this.h = h;
        this.alpha = alpha;
    }

    public /* synthetic */ JzCzHz(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    public final float getJ() {
        return this.j;
    }

    public final float getC() {
        return this.c;
    }

    @Override
    public float getH() {
        return this.h;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public JzCzHz(@NotNull Number l, @NotNull Number c, @NotNull Number h, @NotNull Number alpha) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(h, "h");
        Intrinsics.checkNotNullParameter(alpha, "alpha");
        this(l.floatValue(), c.floatValue(), h.floatValue(), alpha.floatValue());
    }

    public /* synthetic */ JzCzHz(Number number, Number number2, Number number3, Number number4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            number4 = Float.valueOf(1.0f);
        }
        this(number, number2, number3, number4);
    }

    @NotNull
    public ColorSpace<JzCzHz> getSpace() {
        return Companion;
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        return this.j == 0.0f ? RGB.Companion.invoke(0.0f, 0.0f, 0.0f, this.getAlpha()) : this.toJzAzBz().toSRGB();
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return this.toJzAzBz().toXYZ();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        void b;
        void b$iv;
        void c$iv;
        float f = this.c;
        float h$iv = this.getH();
        boolean $i$f$fromPolarModel = false;
        float hDegrees$iv = Float.isNaN(h$iv) ? 0.0f : InternalMathKt.degToRad(h$iv);
        void a$iv = c$iv * (float)Math.cos(hDegrees$iv);
        void var7_7 = b$iv = c$iv * (float)Math.sin(hDegrees$iv);
        void a = a$iv;
        boolean bl = false;
        return new JzAzBz(this.j, (float)a, (float)b, this.getAlpha());
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.j, this.c, this.getH(), this.getAlpha()};
        return fArray;
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return Color.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return Color.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return Color.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return Color.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return Color.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return Color.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return Color.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return Color.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return Color.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return Color.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return Color.DefaultImpls.toHPLuv(this);
    }

    public final float component1() {
        return this.j;
    }

    public final float component2() {
        return this.c;
    }

    public final float component3() {
        return this.getH();
    }

    public final float component4() {
        return this.getAlpha();
    }

    @NotNull
    public final JzCzHz copy(float j, float c, float h, float alpha) {
        return new JzCzHz(j, c, h, alpha);
    }

    public static /* synthetic */ JzCzHz copy$default(JzCzHz jzCzHz, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = jzCzHz.j;
        }
        if ((n & 2) != 0) {
            f2 = jzCzHz.c;
        }
        if ((n & 4) != 0) {
            f3 = jzCzHz.getH();
        }
        if ((n & 8) != 0) {
            f4 = jzCzHz.getAlpha();
        }
        return jzCzHz.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "JzCzHz(j=" + this.j + ", c=" + this.c + ", h=" + this.getH() + ", alpha=" + this.getAlpha() + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.j);
        result = result * 31 + Float.hashCode(this.c);
        result = result * 31 + Float.hashCode(this.getH());
        result = result * 31 + Float.hashCode(this.getAlpha());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JzCzHz)) {
            return false;
        }
        JzCzHz jzCzHz = (JzCzHz)other;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.j), (Object)Float.valueOf(jzCzHz.j))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.c), (Object)Float.valueOf(jzCzHz.c))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.getH()), (Object)Float.valueOf(jzCzHz.getH()))) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.getAlpha()), (Object)Float.valueOf(jzCzHz.getAlpha()));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/github/ajalt/colormath/model/JzCzHz$Companion;", "Lcom/github/ajalt/colormath/ColorSpace;", "Lcom/github/ajalt/colormath/model/JzCzHz;", "()V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "convert", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "colormath"})
    public static final class Companion
    implements ColorSpace<JzCzHz> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getName() {
            return "JzCzHz";
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return components;
        }

        @Override
        @NotNull
        public JzCzHz convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return color.toJzCzHz();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public JzCzHz create(@NotNull float[] components) {
            void p3;
            void p2;
            void p1;
            float f;
            Intrinsics.checkNotNullParameter(components, "components");
            ColorSpace $this$doCreate$iv = this;
            boolean $i$f$doCreate = false;
            ColorSpace $this$withValidComps$iv$iv = $this$doCreate$iv;
            boolean $i$f$withValidComps = false;
            int size$iv$iv = $this$withValidComps$iv$iv.getComponents().size();
            int n = size$iv$iv - 1;
            int n2 = components.length;
            if (!(n <= n2 ? n2 <= size$iv$iv : false)) {
                boolean bl = false;
                String string = "Invalid component array length: " + components.length + ", expected " + (size$iv$iv - 1) + " or " + size$iv$iv;
                throw new IllegalArgumentException(string.toString());
            }
            float[] it$iv = components;
            boolean bl = false;
            float f2 = components[0];
            float f3 = components[1];
            float f4 = components[2];
            int n3 = 3;
            float[] fArray = components;
            if (n3 <= ArraysKt.getLastIndex(fArray)) {
                f = fArray[n3];
            } else {
                int n4 = n3;
                float f5 = f4;
                float f6 = f3;
                float f7 = f2;
                boolean bl2 = false;
                float f8 = 1.0f;
                f2 = f7;
                f3 = f6;
                f4 = f5;
                f = f8;
            }
            float f9 = f;
            float f10 = f4;
            float f11 = f3;
            float p0 = f2;
            boolean bl3 = false;
            return (JzCzHz)((Color)new JzCzHz(p0, (float)p1, (float)p2, (float)p3));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

