/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;

public class CharsetMapping {
    public static final char UNMAPPABLE_DECODING = '\ufffd';
    public static final int UNMAPPABLE_ENCODING = 65533;
    char[] b2cSB;
    char[] b2cDB1;
    char[] b2cDB2;
    int b2Min;
    int b2Max;
    int b1MinDB1;
    int b1MaxDB1;
    int b1MinDB2;
    int b1MaxDB2;
    int dbSegSize;
    char[] c2b;
    char[] c2bIndex;
    char[] b2cSupp;
    char[] c2bSupp;
    Entry[] b2cComp;
    Entry[] c2bComp;
    static Comparator<Entry> comparatorBytes = new Comparator<Entry>(){

        @Override
        public int compare(Entry entry, Entry entry2) {
            return entry.bs - entry2.bs;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    };
    static Comparator<Entry> comparatorCP = new Comparator<Entry>(){

        @Override
        public int compare(Entry entry, Entry entry2) {
            return entry.cp - entry2.cp;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    };
    static Comparator<Entry> comparatorComp = new Comparator<Entry>(){

        @Override
        public int compare(Entry entry, Entry entry2) {
            int n = entry.cp - entry2.cp;
            if (n == 0) {
                n = entry.cp2 - entry2.cp2;
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    };
    private static final int MAP_SINGLEBYTE = 1;
    private static final int MAP_DOUBLEBYTE1 = 2;
    private static final int MAP_DOUBLEBYTE2 = 3;
    private static final int MAP_SUPPLEMENT = 5;
    private static final int MAP_SUPPLEMENT_C2B = 6;
    private static final int MAP_COMPOSITE = 7;
    private static final int MAP_INDEXC2B = 8;
    int off = 0;
    byte[] bb;

    public char decodeSingle(int n) {
        return this.b2cSB[n];
    }

    public char decodeDouble(int n, int n2) {
        if (n2 >= this.b2Min && n2 < this.b2Max) {
            n2 -= this.b2Min;
            if (n >= this.b1MinDB1 && n <= this.b1MaxDB1) {
                return this.b2cDB1[(n -= this.b1MinDB1) * this.dbSegSize + n2];
            }
            if (n >= this.b1MinDB2 && n <= this.b1MaxDB2) {
                return this.b2cDB2[(n -= this.b1MinDB2) * this.dbSegSize + n2];
            }
        }
        return '\ufffd';
    }

    public char[] decodeSurrogate(int n, char[] cArray) {
        int n2 = this.b2cSupp.length / 2;
        int n3 = Arrays.binarySearch(this.b2cSupp, 0, n2, (char)n);
        if (n3 >= 0) {
            Character.toChars(this.b2cSupp[n2 + n3] + 131072, cArray, 0);
            return cArray;
        }
        return null;
    }

    public char[] decodeComposite(Entry entry, char[] cArray) {
        int n = CharsetMapping.findBytes(this.b2cComp, entry);
        if (n >= 0) {
            cArray[0] = (char)this.b2cComp[n].cp;
            cArray[1] = (char)this.b2cComp[n].cp2;
            return cArray;
        }
        return null;
    }

    public int encodeChar(char c) {
        char c2 = this.c2bIndex[c >> 8];
        if (c2 == '\uffff') {
            return 65533;
        }
        return this.c2b[c2 + (c & 0xFF)];
    }

    public int encodeSurrogate(char c, char c2) {
        int n = Character.toCodePoint(c, c2);
        if (n < 131072 || n >= 196608) {
            return 65533;
        }
        int n2 = this.c2bSupp.length / 2;
        int n3 = Arrays.binarySearch(this.c2bSupp, 0, n2, (char)n);
        if (n3 >= 0) {
            return this.c2bSupp[n2 + n3];
        }
        return 65533;
    }

    public boolean isCompositeBase(Entry entry) {
        if (entry.cp <= 12791 && entry.cp >= 230) {
            return CharsetMapping.findCP(this.c2bComp, entry) >= 0;
        }
        return false;
    }

    public int encodeComposite(Entry entry) {
        int n = CharsetMapping.findComp(this.c2bComp, entry);
        if (n >= 0) {
            return this.c2bComp[n].bs;
        }
        return 65533;
    }

    public static CharsetMapping get(final InputStream inputStream) {
        return AccessController.doPrivileged(new PrivilegedAction<CharsetMapping>(){

            @Override
            public CharsetMapping run() {
                return new CharsetMapping().load(inputStream);
            }
        });
    }

    static int findBytes(Entry[] entryArray, Entry entry) {
        return Arrays.binarySearch(entryArray, 0, entryArray.length, entry, comparatorBytes);
    }

    static int findCP(Entry[] entryArray, Entry entry) {
        return Arrays.binarySearch(entryArray, 0, entryArray.length, entry, comparatorCP);
    }

    static int findComp(Entry[] entryArray, Entry entry) {
        return Arrays.binarySearch(entryArray, 0, entryArray.length, entry, comparatorComp);
    }

    private static final boolean readNBytes(InputStream inputStream, byte[] byArray, int n) throws IOException {
        int n2 = 0;
        while (n > 0) {
            int n3 = inputStream.read(byArray, n2, n);
            if (n3 == -1) {
                return false;
            }
            n -= n3;
            n2 += n3;
        }
        return true;
    }

    private char[] readCharArray() {
        int n = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)((this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF);
        }
        return cArray;
    }

    void readSINGLEBYTE() {
        char[] cArray = this.readCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\ufffd') continue;
            this.c2b[this.c2bIndex[c >> 8] + (c & 0xFF)] = (char)i;
        }
        this.b2cSB = cArray;
    }

    void readINDEXC2B() {
        char[] cArray = this.readCharArray();
        for (int i = cArray.length - 1; i >= 0; --i) {
            if (this.c2b != null || cArray[i] == '\uffffffff') continue;
            this.c2b = new char[cArray[i] + 256];
            Arrays.fill(this.c2b, '\ufffd');
            break;
        }
        this.c2bIndex = cArray;
    }

    char[] readDB(int n, int n2, int n3) {
        char[] cArray = this.readCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\ufffd') continue;
            int n4 = i / n3;
            int n5 = i % n3;
            int n6 = (n4 + n) * 256 + (n5 + n2);
            this.c2b[this.c2bIndex[c >> 8] + (c & 0xFF)] = (char)n6;
        }
        return cArray;
    }

    void readDOUBLEBYTE1() {
        this.b1MinDB1 = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b1MaxDB1 = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b2Min = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b2Max = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.dbSegSize = this.b2Max - this.b2Min + 1;
        this.b2cDB1 = this.readDB(this.b1MinDB1, this.b2Min, this.dbSegSize);
    }

    void readDOUBLEBYTE2() {
        this.b1MinDB2 = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b1MaxDB2 = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b2Min = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b2Max = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.dbSegSize = this.b2Max - this.b2Min + 1;
        this.b2cDB2 = this.readDB(this.b1MinDB2, this.b2Min, this.dbSegSize);
    }

    void readCOMPOSITE() {
        char[] cArray = this.readCharArray();
        int n = cArray.length / 3;
        this.b2cComp = new Entry[n];
        this.c2bComp = new Entry[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Entry entry = new Entry();
            entry.bs = cArray[n2++];
            entry.cp = cArray[n2++];
            entry.cp2 = cArray[n2++];
            this.b2cComp[i] = entry;
            this.c2bComp[i] = entry;
        }
        Arrays.sort(this.c2bComp, 0, this.c2bComp.length, comparatorComp);
    }

    CharsetMapping load(InputStream inputStream) {
        try {
            int n = (inputStream.read() & 0xFF) << 24 | (inputStream.read() & 0xFF) << 16 | (inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF;
            this.bb = new byte[n];
            this.off = 0;
            if (!CharsetMapping.readNBytes(inputStream, this.bb, n)) {
                throw new RuntimeException("Corrupted data file");
            }
            inputStream.close();
            block11: while (this.off < n) {
                int n2 = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
                switch (n2) {
                    case 8: {
                        this.readINDEXC2B();
                        continue block11;
                    }
                    case 1: {
                        this.readSINGLEBYTE();
                        continue block11;
                    }
                    case 2: {
                        this.readDOUBLEBYTE1();
                        continue block11;
                    }
                    case 3: {
                        this.readDOUBLEBYTE2();
                        continue block11;
                    }
                    case 5: {
                        this.b2cSupp = this.readCharArray();
                        continue block11;
                    }
                    case 6: {
                        this.c2bSupp = this.readCharArray();
                        continue block11;
                    }
                    case 7: {
                        this.readCOMPOSITE();
                        continue block11;
                    }
                }
                throw new RuntimeException("Corrupted data file");
            }
            this.bb = null;
            return this;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static class Entry {
        public int bs;
        public int cp;
        public int cp2;
    }
}

