/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.Messages;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.di.www.SlaveServerStatus;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.di.www.TransformationMap;

public class GetStatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/status";
    private static LogWriter log = LogWriter.getInstance();
    private TransformationMap transformationMap;
    private JobMap jobMap;

    public GetStatusServlet(TransformationMap transformationMap, JobMap jobMap) {
        this.transformationMap = transformationMap;
        this.jobMap = jobMap;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getContextPath().equals(CONTEXT_PATH)) {
            return;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("GetStatusServlet.StatusRequested"), new Object[0]);
        }
        response.setStatus(200);
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html");
        }
        PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
        String[] transNames = this.transformationMap.getTransformationNames();
        String[] jobNames = this.jobMap.getJobNames();
        if (useXML) {
            String status;
            String name;
            int i;
            out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            SlaveServerStatus serverStatus = new SlaveServerStatus();
            serverStatus.setStatusDescription("Online");
            for (i = 0; i < transNames.length; ++i) {
                name = transNames[i];
                Trans trans = this.transformationMap.getTransformation(name);
                status = trans.getStatus();
                SlaveServerTransStatus sstatus = new SlaveServerTransStatus(name, status);
                sstatus.setPaused(trans.isPaused());
                serverStatus.getTransStatusList().add(sstatus);
            }
            for (i = 0; i < jobNames.length; ++i) {
                name = jobNames[i];
                Job job = this.jobMap.getJob(name);
                status = job.getStatus();
                serverStatus.getJobStatusList().add(new SlaveServerJobStatus(name, status));
            }
            out.println(serverStatus.getXML());
        } else {
            out.println("<HTML>");
            out.println("<HEAD><TITLE>" + Messages.getString("GetStatusServlet.KettleSlaveServerStatus") + "</TITLE></HEAD>");
            out.println("<BODY>");
            out.println("<H1>" + Messages.getString("GetStatusServlet.TopStatus") + "</H1>");
            try {
                String status;
                String name;
                int i;
                out.println("<table border=\"1\">");
                out.print("<tr> <th>" + Messages.getString("GetStatusServlet.TransName") + "</th> <th>" + Messages.getString("GetStatusServlet.Status") + "</th> </tr>");
                for (i = 0; i < transNames.length; ++i) {
                    name = transNames[i];
                    Trans trans = this.transformationMap.getTransformation(name);
                    status = trans.getStatus();
                    out.print("<tr>");
                    out.print("<td><a href=\"/kettle/transStatus?name=" + URLEncoder.encode(name, "UTF-8") + "\">" + name + "</a></td>");
                    out.print("<td>" + status + "</td>");
                    out.print("</tr>");
                }
                out.print("</table><p>");
                out.println("<table border=\"1\">");
                out.print("<tr> <th>" + Messages.getString("GetStatusServlet.JobName") + "</th> <th>" + Messages.getString("GetStatusServlet.Status") + "</th> </tr>");
                for (i = 0; i < jobNames.length; ++i) {
                    name = jobNames[i];
                    Job job = this.jobMap.getJob(name);
                    status = job.getStatus();
                    out.print("<tr>");
                    out.print("<td><a href=\"/kettle/jobStatus?name=" + URLEncoder.encode(name, "UTF-8") + "\">" + name + "</a></td>");
                    out.print("<td>" + status + "</td>");
                    out.print("</tr>");
                }
                out.print("</table>");
            }
            catch (Exception ex) {
                out.println("<p>");
                out.println("<pre>");
                ex.printStackTrace(out);
                out.println("</pre>");
            }
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Status Handler";
    }
}

