/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.SPSUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.swing.Timer;

public class InvadersAction
extends AbstractArchitectAction {
    public InvadersAction(ArchitectFrame frame) {
        super(frame, "Architect Invaders", "Defend your data model against interplanetary attack");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Game game = new Game(this.getSession());
            game.start();
        }
        catch (SQLObjectException ex) {
            SPSUtils.showExceptionDialogNoReport((Component)this.getSession().getArchitectFrame(), (String)"FAIL", null, (Throwable)ex);
        }
    }

    private static class Game
    implements ActionListener,
    MouseListener {
        private final ArchitectSwingSession session;
        private final PlayPen playpen;
        private final Timer timer = new Timer(100, this);
        private final Random random = new Random();
        private final Dimension playfieldSize = new Dimension(640, 600);
        private final List<TablePane> baddies = new ArrayList<TablePane>();
        private final List<Bullet> poops = new ArrayList<Bullet>();
        private BaddyState baddyState = BaddyState.RIGHT;
        private static final int LINE_SPACING = 70;
        private static final int LINEFEED_SIZE = 50;
        private String legs = "/|\\";
        private static final int POOP_VELOCITY = 3;
        private TablePane mothership = null;
        private int lastMothershipAppearance = 500;
        private final List<TablePane> bases = new ArrayList<TablePane>();
        private boolean fireNextTurn = false;
        private Bullet bullet;
        private TablePane player;
        private static final int BULLET_VELOCITY = -19;
        private int score = 0;
        private static final int BADDY_ELIMINATION_SCORE = 100;
        private static final int MOTHERSHIP_ELIMINATION_SCORE = 10000;
        private static final int LIFE_BONUS_SCORE = 1000;
        private int messageTTL = 0;
        private TablePane message;

        Game(ArchitectSwingSession session) throws SQLObjectException {
            int x;
            this.session = session;
            this.playpen = session.getPlayPen();
            for (x = 0; x < 10; ++x) {
                for (int y = 0; y < 4; ++y) {
                    TablePane baddy = this.makeTable(x * (this.playfieldSize.width / 10), (y + 1) * 70, "Baddy", this.legs);
                    this.baddies.add(baddy);
                }
            }
            for (x = 0; x < 3; ++x) {
                TablePane base = this.makeTable((int)(10.0 + (double)x * ((double)this.playfieldSize.width / 3.0)), this.playfieldSize.height - 150, "Base", "Fortification----------", "Fortification-----", "Fortification");
                this.bases.add(base);
            }
            this.player = this.makeTable(this.playfieldSize.width / 2, this.playfieldSize.height - 50, "0", "Life 1", "Life 2", "Life 3");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (this.messageTTL > 0) {
                    --this.messageTTL;
                    return;
                }
                if (this.message != null) {
                    ((SQLTable)this.message.getModel()).getParent().removeChild((SPObject)this.message.getModel());
                }
                Iterator<Bullet> poopIt = this.poops.iterator();
                while (poopIt.hasNext()) {
                    Bullet poop = poopIt.next();
                    Point poopPosition = poop.getPosition();
                    Iterator<TablePane> baseIt = this.bases.iterator();
                    while (baseIt.hasNext()) {
                        TablePane base = baseIt.next();
                        if (!base.contains(poopPosition)) continue;
                        poopIt.remove();
                        poop.destroy();
                        if (!this.processBaseHit(base)) continue;
                        baseIt.remove();
                    }
                    if (!this.player.contains(poopPosition)) continue;
                    poopIt.remove();
                    poop.destroy();
                    this.endOfTurn();
                    return;
                }
                this.legs = this.legs == "/|\\" ? "|||" : "/|\\";
                BaddyState nextBaddyState = null;
                Iterator<TablePane> baddyIt = this.baddies.iterator();
                while (baddyIt.hasNext()) {
                    TablePane baddy = baddyIt.next();
                    if (this.bullet != null && baddy.contains(this.bullet.getPosition())) {
                        this.score += 100;
                        baddyIt.remove();
                        ((SQLTable)baddy.getModel()).getParent().removeChild((SPObject)baddy.getModel());
                        this.bullet.destroy();
                        this.bullet = null;
                        continue;
                    }
                    Rectangle bb = baddy.getBounds();
                    Iterator<TablePane> baseIt = this.bases.iterator();
                    while (baseIt.hasNext()) {
                        TablePane base = baseIt.next();
                        if (!bb.intersects(base.getBounds())) continue;
                        baddyIt.remove();
                        ((SQLTable)baddy.getModel()).getParent().removeChild((SPObject)baddy.getModel());
                        if (!this.processBaseHit(base)) continue;
                        baseIt.remove();
                    }
                    if (baddy.getBounds().intersects(this.player.getBounds())) {
                        this.endOfTurn();
                        return;
                    }
                    ((SQLTable)baddy.getModel()).getColumn(0).setName(this.legs);
                    if (this.baddyState == BaddyState.LEFT) {
                        baddy.setLocation(baddy.getX() - 1, baddy.getY());
                        if (baddy.getX() <= 0) {
                            nextBaddyState = BaddyState.RIGHT;
                        }
                    } else if (this.baddyState == BaddyState.RIGHT) {
                        baddy.setLocation(baddy.getX() + 1, baddy.getY());
                        if (baddy.getX() >= this.playfieldSize.width) {
                            nextBaddyState = BaddyState.LEFT;
                        }
                    }
                    if (this.poops.size() > 3 || this.random.nextInt(100) != 0) continue;
                    Bullet poop = new Bullet(baddy.getX() + baddy.getWidth() / 2, baddy.getY() + baddy.getHeight(), 3);
                    this.poops.add(poop);
                }
                if (nextBaddyState != null) {
                    for (TablePane baddy : this.baddies) {
                        baddy.setLocation(baddy.getX(), baddy.getY() + 50);
                    }
                    this.baddyState = nextBaddyState;
                }
                if (this.mothership != null) {
                    this.mothership.setLocation(this.mothership.getX() - 8, this.mothership.getY());
                    boolean hit = false;
                    if (this.bullet != null && this.mothership.contains(this.bullet.getPosition())) {
                        this.score += 10000;
                        hit = true;
                    }
                    if (hit || this.mothership.getX() < 0) {
                        ((SQLTable)this.mothership.getModel()).getParent().removeChild((SPObject)this.mothership.getModel());
                        this.mothership = null;
                    }
                } else if (this.lastMothershipAppearance < this.score && this.score % 1000 == 0) {
                    this.mothership = this.makeTable(this.playfieldSize.width, 20, "Mothership", new String[0]);
                }
                Point position = this.playpen.getMousePosition();
                if (position != null) {
                    this.player.setLocation(position.x, this.player.getY());
                }
                if (this.fireNextTurn) {
                    if (this.bullet == null) {
                        this.bullet = new Bullet(this.player.getX() + this.player.getWidth() / 2, this.player.getY(), -19);
                    }
                    this.fireNextTurn = false;
                }
                if (this.bullet != null) {
                    this.bullet.move();
                    if (this.bullet.getPosition().y < 0) {
                        this.bullet.destroy();
                        this.bullet = null;
                    }
                }
                Iterator<Bullet> it = this.poops.iterator();
                while (it.hasNext()) {
                    Bullet poop = it.next();
                    poop.move();
                    if (poop.getPosition().y <= this.playfieldSize.height) continue;
                    poop.destroy();
                    it.remove();
                }
                if (this.mothership == null && this.baddies.isEmpty()) {
                    this.winGame();
                    return;
                }
                ((SQLTable)this.player.getModel()).setName(String.valueOf(this.score));
            }
            catch (SQLObjectException ex) {
                this.stop();
                throw new SQLObjectRuntimeException(ex);
            }
            catch (ObjectDependentException ex) {
                this.stop();
                throw new RuntimeException(ex);
            }
        }

        private boolean processBaseHit(TablePane base) throws ObjectDependentException, SQLObjectException {
            SQLTable baseTable = (SQLTable)base.getModel();
            if (baseTable.getColumns().size() > 0) {
                baseTable.removeColumn(0);
                return false;
            }
            baseTable.getParent().removeChild((SPObject)baseTable);
            return true;
        }

        private void endOfTurn() throws SQLObjectException {
            SQLTable playerTable = (SQLTable)this.player.getModel();
            if (playerTable.getColumns().size() <= 1) {
                this.stop();
                if (!playerTable.getColumns().isEmpty()) {
                    playerTable.removeColumn(0);
                }
                this.message = this.makeTable(this.playfieldSize.width / 4, this.playfieldSize.height / 4, "Game Over", "Your Score: " + this.score);
                this.message.setMinimumSize(new Dimension(this.playfieldSize.width / 2, this.playfieldSize.height / 2));
                this.message.revalidate();
            } else {
                playerTable.removeColumn(playerTable.getColumns().size() - 1);
                this.messageTTL = 1000 / this.timer.getDelay();
                for (Bullet poop : this.poops) {
                    poop.destroy();
                }
                this.poops.clear();
            }
        }

        private void winGame() throws SQLObjectException {
            this.stop();
            SQLTable playerTable = (SQLTable)this.player.getModel();
            int lifeBonus = playerTable.getColumns().size() * 1000;
            this.score += lifeBonus;
            this.message = this.makeTable(this.playfieldSize.width / 4, this.playfieldSize.height / 4, "Game Over", "Bonus for remaining lives: " + lifeBonus, "Your Score: " + this.score);
            this.message.setMinimumSize(new Dimension(this.playfieldSize.width / 2, this.playfieldSize.height / 2));
            this.message.revalidate();
        }

        public void start() {
            this.playpen.addMouseListener(this);
            this.timer.start();
        }

        public void stop() {
            this.playpen.removeMouseListener(this);
            this.timer.stop();
        }

        private TablePane makeTable(int x, int y, String name, String ... columnNames) throws SQLObjectException {
            SQLTable t = new SQLTable();
            t.initFolders(true);
            t.setName(name);
            for (String cn : columnNames) {
                t.addColumn(new SQLColumn(t, cn, -7, 0, 0));
            }
            TablePane tp = new TablePane(t, this.playpen.getContentPane());
            tp.setMinimumSize(new Dimension(1, 0));
            this.session.getTargetDatabase().addChild((SQLObject)tp.getModel());
            this.playpen.addTablePane(tp, new Point(x, y));
            return tp;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.fireNextTurn = true;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        private class Bullet {
            private final int velocity;
            private final Relationship r;
            private final SQLTable top;
            private final SQLTable bot;
            private final TablePane tpTop;
            private final TablePane tpBot;

            Bullet(int startx, int starty, int velocity) throws SQLObjectException {
                this.velocity = velocity;
                this.top = new SQLTable();
                this.top.initFolders(true);
                this.top.setName("");
                this.tpTop = new TablePane(this.top, Game.this.playpen.getContentPane());
                this.tpTop.setMinimumSize(new Dimension(20, 0));
                Game.this.session.getTargetDatabase().addChild((SQLObject)this.tpTop.getModel());
                Game.this.playpen.addTablePane(this.tpTop, new Point(startx, starty));
                this.tpTop.revalidate();
                this.bot = new SQLTable();
                this.bot.initFolders(true);
                this.bot.setName("");
                this.tpBot = new TablePane(this.bot, Game.this.playpen.getContentPane());
                this.tpBot.setMinimumSize(new Dimension(20, 0));
                Game.this.session.getTargetDatabase().addChild((SQLObject)this.tpBot.getModel());
                Game.this.playpen.addTablePane(this.tpBot, new Point(this.tpTop.getX(), this.tpTop.getY() + this.tpTop.getHeight() + 30));
                SQLRelationship sr = SQLRelationship.createRelationship((SQLTable)this.top, (SQLTable)this.bot, (boolean)true);
                this.r = new Relationship(sr, Game.this.playpen.getContentPane());
                Game.this.playpen.addRelationship(this.r);
            }

            void destroy() {
                SQLDatabase db = Game.this.session.getTargetDatabase();
                try {
                    db.removeChild((SPObject)this.top);
                    db.removeChild((SPObject)this.bot);
                }
                catch (ObjectDependentException e) {
                    throw new RuntimeException(e);
                }
            }

            void move() {
                this.tpTop.setLocation(this.tpTop.getX(), this.tpTop.getY() + this.velocity);
                this.tpBot.setLocation(this.tpBot.getX(), this.tpBot.getY() + this.velocity);
            }

            Point getPosition() {
                if (this.velocity < 0) {
                    return new Point(this.tpTop.getX(), this.tpTop.getY() + this.tpTop.getHeight());
                }
                return new Point(this.tpBot.getX(), this.tpBot.getY());
            }
        }

        private static enum BaddyState {
            LEFT,
            RIGHT;

        }
    }
}

