/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.coverage;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.construct.MaximumInscribedCircle;
import org.locationtech.jts.coverage.CoverageUnion;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.PolygonExtracter;

public class CoverageGapFinder {
    private Geometry[] coverage;

    public static Geometry findGaps(Geometry[] coverage, double gapWidth) {
        CoverageGapFinder finder = new CoverageGapFinder(coverage);
        return finder.findGaps(gapWidth);
    }

    public CoverageGapFinder(Geometry[] coverage) {
        this.coverage = coverage;
    }

    public Geometry findGaps(double gapWidth) {
        Geometry union = CoverageUnion.union(this.coverage);
        List polygons = PolygonExtracter.getPolygons(union);
        ArrayList<LineString> gapLines = new ArrayList<LineString>();
        for (Polygon poly : polygons) {
            for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
                LinearRing hole = poly.getInteriorRingN(i);
                if (!this.isGap(hole, gapWidth)) continue;
                gapLines.add(this.copyLine(hole));
            }
        }
        return union.getFactory().buildGeometry(gapLines);
    }

    private LineString copyLine(LinearRing hole) {
        Coordinate[] pts = hole.getCoordinates();
        return hole.getFactory().createLineString(pts);
    }

    private boolean isGap(LinearRing hole, double gapWidth) {
        Polygon holePoly = hole.getFactory().createPolygon(hole);
        if (gapWidth <= 0.0) {
            return false;
        }
        double tolerance = gapWidth / 100.0;
        LineString line = MaximumInscribedCircle.getRadiusLine(holePoly, tolerance);
        double width = line.getLength() * 2.0;
        return width <= gapWidth;
    }
}

