/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.mutable.RedBlackTree;
import scala.collection.mutable.RedBlackTree$Node$;
import scala.collection.mutable.RedBlackTree$Tree$;
import scala.math.Ordering;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Null$;
import scala.runtime.Scala3RunTime$;

public final class RedBlackTree$
implements Serializable {
    public static final RedBlackTree$Tree$ Tree;
    public static final RedBlackTree$Node$ Node;
    public static final RedBlackTree$ MODULE$;

    private RedBlackTree$() {
    }

    static {
        MODULE$ = new RedBlackTree$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RedBlackTree$.class);
    }

    public boolean isRed(RedBlackTree.Node<?, ?> node) {
        return !(node == null) && node.red();
    }

    public boolean isBlack(RedBlackTree.Node<?, ?> node) {
        return node == null || !node.red();
    }

    public int size(RedBlackTree.Node<?, ?> node) {
        if (node == null) {
            return 0;
        }
        return 1 + this.size(node.left()) + this.size(node.right());
    }

    public int size(RedBlackTree.Tree<?, ?> tree) {
        return tree.size();
    }

    public boolean isEmpty(RedBlackTree.Tree<?, ?> tree) {
        return tree.root() == null;
    }

    public void clear(RedBlackTree.Tree<?, ?> tree) {
        tree.root_$eq(null);
        tree.size_$eq(0);
    }

    public <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$1) {
        RedBlackTree.Node<A, B> node = this.getNode(tree.root(), key, evidence$1);
        if (node == null) {
            return None$.MODULE$;
        }
        RedBlackTree.Node<A, B> node2 = node;
        return Some$.MODULE$.apply(node2.value());
    }

    private <A, B> RedBlackTree.Node<A, B> getNode(RedBlackTree.Node<A, B> node, A key, Ordering<A> ord) {
        while (true) {
            if (node == null) {
                return null;
            }
            int cmp = ord.compare(key, node.key());
            if (cmp < 0) {
                node = node.left();
                continue;
            }
            if (cmp <= 0) break;
            node = node.right();
        }
        return node;
    }

    public <A> boolean contains(RedBlackTree.Tree<A, ?> tree, A key, Ordering<A> evidence$1) {
        return !(this.getNode(tree.root(), key, evidence$1) == null);
    }

    public <A, B> Option<Tuple2<A, B>> min(RedBlackTree.Tree<A, B> tree) {
        RedBlackTree.Node<A, B> node = this.scala$collection$mutable$RedBlackTree$$$minNode(tree.root());
        if (node == null) {
            return None$.MODULE$;
        }
        RedBlackTree.Node<A, B> node2 = node;
        return Some$.MODULE$.apply(Tuple2$.MODULE$.apply(node2.key(), node2.value()));
    }

    public <A> Option<A> minKey(RedBlackTree.Tree<A, ?> tree) {
        RedBlackTree.Node<A, ?> node = this.scala$collection$mutable$RedBlackTree$$$minNode(tree.root());
        if (node == null) {
            return None$.MODULE$;
        }
        RedBlackTree.Node<A, ?> node2 = node;
        return Some$.MODULE$.apply(node2.key());
    }

    public <A, B> RedBlackTree.Node<A, B> scala$collection$mutable$RedBlackTree$$$minNode(RedBlackTree.Node<A, B> node) {
        if (node == null) {
            return null;
        }
        return this.minNodeNonNull(node);
    }

    public <A, B> RedBlackTree.Node<A, B> minNodeNonNull(RedBlackTree.Node<A, B> node) {
        while (!(node.left() == null)) {
            node = node.left();
        }
        return node;
    }

    public <A, B> Option<Tuple2<A, B>> max(RedBlackTree.Tree<A, B> tree) {
        RedBlackTree.Node<A, B> node = this.maxNode(tree.root());
        if (node == null) {
            return None$.MODULE$;
        }
        RedBlackTree.Node<A, B> node2 = node;
        return Some$.MODULE$.apply(Tuple2$.MODULE$.apply(node2.key(), node2.value()));
    }

    public <A> Option<A> maxKey(RedBlackTree.Tree<A, ?> tree) {
        RedBlackTree.Node<A, ?> node = this.maxNode(tree.root());
        if (node == null) {
            return None$.MODULE$;
        }
        RedBlackTree.Node<A, ?> node2 = node;
        return Some$.MODULE$.apply(node2.key());
    }

    private <A, B> RedBlackTree.Node<A, B> maxNode(RedBlackTree.Node<A, B> node) {
        if (node == null) {
            return null;
        }
        return this.maxNodeNonNull(node);
    }

    public <A, B> RedBlackTree.Node<A, B> maxNodeNonNull(RedBlackTree.Node<A, B> node) {
        while (!(node.right() == null)) {
            node = node.right();
        }
        return node;
    }

    public <A, B> Option<Tuple2<A, B>> minAfter(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> ord) {
        RedBlackTree.Node<A, B> node = this.scala$collection$mutable$RedBlackTree$$$minNodeAfter(tree.root(), key, ord);
        if (node == null) {
            return None$.MODULE$;
        }
        RedBlackTree.Node<A, B> node2 = node;
        return Some$.MODULE$.apply(Tuple2$.MODULE$.apply(node2.key(), node2.value()));
    }

    public <A> Option<A> minKeyAfter(RedBlackTree.Tree<A, ?> tree, A key, Ordering<A> ord) {
        RedBlackTree.Node<A, ?> node = this.scala$collection$mutable$RedBlackTree$$$minNodeAfter(tree.root(), key, ord);
        if (node == null) {
            return None$.MODULE$;
        }
        RedBlackTree.Node<A, ?> node2 = node;
        return Some$.MODULE$.apply(node2.key());
    }

    public <A, B> RedBlackTree.Node<A, B> scala$collection$mutable$RedBlackTree$$$minNodeAfter(RedBlackTree.Node<A, B> node, A key, Ordering<A> ord) {
        if (node == null) {
            return null;
        }
        RedBlackTree.Node<A, B> y = null;
        RedBlackTree.Node<A, B> x = node;
        int cmp = 1;
        while (!(x == null) && cmp != 0) {
            y = x;
            cmp = ord.compare(key, x.key());
            x = cmp < 0 ? x.left() : x.right();
        }
        if (cmp <= 0) {
            return y;
        }
        return this.scala$collection$mutable$RedBlackTree$$$successor(y);
    }

    public <A, B> Option<Tuple2<A, B>> maxBefore(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> ord) {
        RedBlackTree.Node<A, B> node = this.maxNodeBefore(tree.root(), key, ord);
        if (node == null) {
            return None$.MODULE$;
        }
        RedBlackTree.Node<A, B> node2 = node;
        return Some$.MODULE$.apply(Tuple2$.MODULE$.apply(node2.key(), node2.value()));
    }

    public <A> Option<A> maxKeyBefore(RedBlackTree.Tree<A, ?> tree, A key, Ordering<A> ord) {
        RedBlackTree.Node<A, ?> node = this.maxNodeBefore(tree.root(), key, ord);
        if (node == null) {
            return None$.MODULE$;
        }
        RedBlackTree.Node<A, ?> node2 = node;
        return Some$.MODULE$.apply(node2.key());
    }

    private <A, B> RedBlackTree.Node<A, B> maxNodeBefore(RedBlackTree.Node<A, B> node, A key, Ordering<A> ord) {
        if (node == null) {
            return null;
        }
        RedBlackTree.Node<A, B> y = null;
        RedBlackTree.Node<A, B> x = node;
        int cmp = 1;
        while (!(x == null) && cmp != 0) {
            y = x;
            cmp = ord.compare(key, x.key());
            x = cmp < 0 ? x.left() : x.right();
        }
        if (cmp > 0) {
            return y;
        }
        return this.predecessor(y);
    }

    public <A, B> void insert(RedBlackTree.Tree<A, B> tree, A key, B value, Ordering<A> ord) {
        RedBlackTree.Node<A, B> y = null;
        RedBlackTree.Node<A, B> x = tree.root();
        int cmp = 1;
        while (!(x == null) && cmp != 0) {
            y = x;
            cmp = ord.compare(key, x.key());
            x = cmp < 0 ? x.left() : x.right();
        }
        if (cmp == 0) {
            RedBlackTree.Node<A, B> x$proxy12 = y;
            if (x$proxy12 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy12.value_$eq(value);
            return;
        }
        RedBlackTree.Node<A, B> z = RedBlackTree$Node$.MODULE$.leaf(key, value, true, y);
        if (y == null) {
            tree.root_$eq(z);
        } else if (cmp < 0) {
            y.left_$eq(z);
        } else {
            y.right_$eq(z);
        }
        this.fixAfterInsert(tree, z);
        tree.size_$eq(tree.size() + 1);
    }

    private <A, B> void fixAfterInsert(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> node) {
        RedBlackTree.Node<A, B> z = node;
        while (this.isRed(z.parent())) {
            RedBlackTree.Node<A, B> x$proxy42;
            RedBlackTree.Node<A, B> x$proxy14 = z.parent();
            if (x$proxy14 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            RedBlackTree.Node<A, B> x$proxy15 = x$proxy14.parent();
            if (x$proxy15 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            if (z.parent() == x$proxy15.left()) {
                RedBlackTree.Node<A, B> x$proxy27;
                RedBlackTree.Node<A, B> x$proxy17 = z.parent();
                if (x$proxy17 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Node<A, B> x$proxy18 = x$proxy17.parent();
                if (x$proxy18 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Node<A, B> y = x$proxy18.right();
                if (this.isRed(y)) {
                    RedBlackTree.Node<A, B> x$proxy19 = z.parent();
                    if (x$proxy19 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    x$proxy19.red_$eq(false);
                    if (y == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    y.red_$eq(false);
                    RedBlackTree.Node<A, B> x$proxy20 = z.parent();
                    if (x$proxy20 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    RedBlackTree.Node<A, B> x$proxy21 = x$proxy20.parent();
                    if (x$proxy21 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    x$proxy21.red_$eq(true);
                    RedBlackTree.Node<A, B> x$proxy22 = z.parent();
                    if (x$proxy22 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    RedBlackTree.Node<A, B> x$proxy23 = x$proxy22.parent();
                    if (x$proxy23 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    z = x$proxy23;
                    continue;
                }
                RedBlackTree.Node<A, B> x$proxy24 = z.parent();
                if (x$proxy24 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (z == x$proxy24.right()) {
                    RedBlackTree.Node<A, B> x$proxy26 = z.parent();
                    if (x$proxy26 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    z = x$proxy26;
                    this.rotateLeft(tree, z);
                }
                if ((x$proxy27 = z.parent()) == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                x$proxy27.red_$eq(false);
                RedBlackTree.Node<A, B> x$proxy28 = z.parent();
                if (x$proxy28 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Node<A, B> x$proxy29 = x$proxy28.parent();
                if (x$proxy29 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                x$proxy29.red_$eq(true);
                RedBlackTree.Node<A, B> x$proxy30 = z.parent();
                if (x$proxy30 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Node<A, B> x$proxy31 = x$proxy30.parent();
                if (x$proxy31 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                this.rotateRight(tree, x$proxy31);
                continue;
            }
            RedBlackTree.Node<A, B> x$proxy32 = z.parent();
            if (x$proxy32 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            RedBlackTree.Node<A, B> x$proxy33 = x$proxy32.parent();
            if (x$proxy33 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            RedBlackTree.Node<A, B> y = x$proxy33.left();
            if (this.isRed(y)) {
                RedBlackTree.Node<A, B> x$proxy34 = z.parent();
                if (x$proxy34 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                x$proxy34.red_$eq(false);
                if (y == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                y.red_$eq(false);
                RedBlackTree.Node<A, B> x$proxy35 = z.parent();
                if (x$proxy35 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Node<A, B> x$proxy36 = x$proxy35.parent();
                if (x$proxy36 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                x$proxy36.red_$eq(true);
                RedBlackTree.Node<A, B> x$proxy37 = z.parent();
                if (x$proxy37 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                RedBlackTree.Node<A, B> x$proxy38 = x$proxy37.parent();
                if (x$proxy38 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                z = x$proxy38;
                continue;
            }
            RedBlackTree.Node<A, B> x$proxy39 = z.parent();
            if (x$proxy39 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            if (z == x$proxy39.left()) {
                RedBlackTree.Node<A, B> x$proxy41 = z.parent();
                if (x$proxy41 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                z = x$proxy41;
                this.rotateRight(tree, z);
            }
            if ((x$proxy42 = z.parent()) == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy42.red_$eq(false);
            RedBlackTree.Node<A, B> x$proxy43 = z.parent();
            if (x$proxy43 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            RedBlackTree.Node<A, B> x$proxy44 = x$proxy43.parent();
            if (x$proxy44 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy44.red_$eq(true);
            RedBlackTree.Node<A, B> x$proxy45 = z.parent();
            if (x$proxy45 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            RedBlackTree.Node<A, B> x$proxy46 = x$proxy45.parent();
            if (x$proxy46 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            this.rotateLeft(tree, x$proxy46);
        }
        RedBlackTree.Node<A, B> x$proxy47 = tree.root();
        if (x$proxy47 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        x$proxy47.red_$eq(false);
    }

    public <A, B> void delete(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> ord) {
        RedBlackTree.Node<A, B> z = this.getNode(tree.root(), key, ord);
        if (!(z == null)) {
            RedBlackTree.Node<A, B> y = z;
            boolean yIsRed = y.red();
            RedBlackTree.Node<A, B> x = null;
            RedBlackTree.Node<A, B> xParent = null;
            if (z.left() == null) {
                x = z.right();
                this.transplant(tree, z, z.right());
                xParent = z.parent();
            } else if (z.right() == null) {
                x = z.left();
                this.transplant(tree, z, z.left());
                xParent = z.parent();
            } else {
                y = this.minNodeNonNull(z.right());
                yIsRed = y.red();
                x = y.right();
                if (y.parent() == z) {
                    xParent = y;
                } else {
                    xParent = y.parent();
                    this.transplant(tree, y, y.right());
                    y.right_$eq(z.right());
                    RedBlackTree.Node<A, B> x$proxy51 = y.right();
                    if (x$proxy51 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    x$proxy51.parent_$eq(y);
                }
                this.transplant(tree, z, y);
                y.left_$eq(z.left());
                RedBlackTree.Node<A, B> x$proxy52 = y.left();
                if (x$proxy52 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                x$proxy52.parent_$eq(y);
                y.red_$eq(z.red());
            }
            if (!yIsRed) {
                this.fixAfterDelete(tree, x, xParent);
            }
            tree.size_$eq(tree.size() - 1);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private <A, B> void fixAfterDelete(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> node, RedBlackTree.Node<A, B> parent) {
        x = node;
        xParent = parent;
        while (x == tree.root() == false && this.isBlack(x)) {
            block55: {
                block54: {
                    x$proxy55 = xParent;
                    if (x$proxy55 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    if (!(x == x$proxy55.left())) break block54;
                    x$proxy57 = xParent;
                    if (x$proxy57 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    w = x$proxy57.right();
                    x$proxy58 = w;
                    if (x$proxy58 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    if (x$proxy58.red()) {
                        x$proxy59 = w;
                        if (x$proxy59 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        x$proxy59.red_$eq(false);
                        x$proxy60 = xParent;
                        if (x$proxy60 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        x$proxy60.red_$eq(true);
                        x$proxy61 = xParent;
                        if (x$proxy61 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        this.rotateLeft(tree, x$proxy61);
                        x$proxy62 = xParent;
                        if (x$proxy62 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        w = x$proxy62.right();
                    }
                    if ((x$proxy63 = w) == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    if (!this.isBlack(x$proxy63.left())) ** GOTO lbl-1000
                    x$proxy64 = w;
                    if (x$proxy64 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    if (this.isBlack(x$proxy64.right())) {
                        x$proxy65 = w;
                        if (x$proxy65 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        x$proxy65.red_$eq(true);
                        x = xParent;
                    } else lbl-1000:
                    // 2 sources

                    {
                        if ((x$proxy66 = w) == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        if (this.isBlack(x$proxy66.right())) {
                            x$proxy67 = w;
                            if (x$proxy67 == null) {
                                throw Scala3RunTime$.MODULE$.nnFail();
                            }
                            x$proxy68 = x$proxy67.left();
                            if (x$proxy68 == null) {
                                throw Scala3RunTime$.MODULE$.nnFail();
                            }
                            x$proxy68.red_$eq(false);
                            x$proxy69 = w;
                            if (x$proxy69 == null) {
                                throw Scala3RunTime$.MODULE$.nnFail();
                            }
                            x$proxy69.red_$eq(true);
                            x$proxy70 = w;
                            if (x$proxy70 == null) {
                                throw Scala3RunTime$.MODULE$.nnFail();
                            }
                            this.rotateRight(tree, x$proxy70);
                            x$proxy71 = xParent;
                            if (x$proxy71 == null) {
                                throw Scala3RunTime$.MODULE$.nnFail();
                            }
                            w = x$proxy71.right();
                        }
                        if ((x$proxy72 = w) == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        x$proxy73 = xParent;
                        if (x$proxy73 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        x$proxy72.red_$eq(x$proxy73.red());
                        x$proxy74 = xParent;
                        if (x$proxy74 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        x$proxy74.red_$eq(false);
                        x$proxy75 = w;
                        if (x$proxy75 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        x$proxy76 = x$proxy75.right();
                        if (x$proxy76 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        x$proxy76.red_$eq(false);
                        x$proxy77 = xParent;
                        if (x$proxy77 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        this.rotateLeft(tree, x$proxy77);
                        x = tree.root();
                    }
                    break block55;
                }
                x$proxy78 = xParent;
                if (x$proxy78 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                w = x$proxy78.left();
                x$proxy79 = w;
                if (x$proxy79 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (x$proxy79.red()) {
                    x$proxy80 = w;
                    if (x$proxy80 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    x$proxy80.red_$eq(false);
                    x$proxy81 = xParent;
                    if (x$proxy81 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    x$proxy81.red_$eq(true);
                    x$proxy82 = xParent;
                    if (x$proxy82 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    this.rotateRight(tree, x$proxy82);
                    x$proxy83 = xParent;
                    if (x$proxy83 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    w = x$proxy83.left();
                }
                if ((x$proxy84 = w) == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (!this.isBlack(x$proxy84.right())) ** GOTO lbl-1000
                x$proxy85 = w;
                if (x$proxy85 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (this.isBlack(x$proxy85.left())) {
                    x$proxy86 = w;
                    if (x$proxy86 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    x$proxy86.red_$eq(true);
                    x = xParent;
                } else lbl-1000:
                // 2 sources

                {
                    if ((x$proxy87 = w) == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    if (this.isBlack(x$proxy87.left())) {
                        x$proxy88 = w;
                        if (x$proxy88 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        x$proxy89 = x$proxy88.right();
                        if (x$proxy89 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        x$proxy89.red_$eq(false);
                        x$proxy90 = w;
                        if (x$proxy90 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        x$proxy90.red_$eq(true);
                        x$proxy91 = w;
                        if (x$proxy91 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        this.rotateLeft(tree, x$proxy91);
                        x$proxy92 = xParent;
                        if (x$proxy92 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        w = x$proxy92.left();
                    }
                    if ((x$proxy93 = w) == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    x$proxy94 = xParent;
                    if (x$proxy94 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    x$proxy93.red_$eq(x$proxy94.red());
                    x$proxy95 = xParent;
                    if (x$proxy95 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    x$proxy95.red_$eq(false);
                    x$proxy96 = w;
                    if (x$proxy96 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    x$proxy97 = x$proxy96.left();
                    if (x$proxy97 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    x$proxy97.red_$eq(false);
                    x$proxy98 = xParent;
                    if (x$proxy98 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    this.rotateRight(tree, x$proxy98);
                    x = tree.root();
                }
            }
            x$proxy99 = x;
            if (x$proxy99 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            xParent = x$proxy99.parent();
        }
        if (x == null == false) {
            x.red_$eq(false);
            return;
        }
    }

    public <A, B> RedBlackTree.Node<A, B> scala$collection$mutable$RedBlackTree$$$successor(RedBlackTree.Node<A, B> node) {
        if (!(node.right() == null)) {
            return this.minNodeNonNull(node.right());
        }
        RedBlackTree.Node<A, B> x = node;
        RedBlackTree.Node<A, B> y = x.parent();
        while (!(y == null)) {
            RedBlackTree.Node<A, B> x$proxy106 = y;
            if (x$proxy106 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            if (!(x == x$proxy106.right())) break;
            x = y;
            y = y.parent();
        }
        return y;
    }

    private <A, B> RedBlackTree.Node<A, B> predecessor(RedBlackTree.Node<A, B> node) {
        if (!(node.left() == null)) {
            return this.maxNodeNonNull(node.left());
        }
        RedBlackTree.Node<A, B> x = node;
        RedBlackTree.Node<A, B> y = x.parent();
        while (!(y == null) && x == y.left()) {
            x = y;
            y = y.parent();
        }
        return y;
    }

    private <A, B> void rotateLeft(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> x) {
        if (!(x == null)) {
            RedBlackTree.Node<A, B> x$proxy113 = x.right();
            if (x$proxy113 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            RedBlackTree.Node<A, B> y = x$proxy113;
            x.right_$eq(y.left());
            if (!(y.left() == null)) {
                y.left().parent_$eq(x);
            }
            y.parent_$eq(x.parent());
            if (x.parent() == null) {
                tree.root_$eq(y);
            } else {
                RedBlackTree.Node<A, B> x$proxy117 = x.parent();
                if (x$proxy117 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (x == x$proxy117.left()) {
                    x.parent().left_$eq(y);
                } else {
                    x.parent().right_$eq(y);
                }
            }
            y.left_$eq(x);
            x.parent_$eq(y);
            return;
        }
    }

    private <A, B> void rotateRight(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> x) {
        if (!(x == null)) {
            RedBlackTree.Node<A, B> x$proxy118 = x.left();
            if (x$proxy118 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            RedBlackTree.Node<A, B> y = x$proxy118;
            x.left_$eq(y.right());
            if (!(y.right() == null)) {
                y.right().parent_$eq(x);
            }
            y.parent_$eq(x.parent());
            if (x.parent() == null) {
                tree.root_$eq(y);
            } else if (x == x.parent().right()) {
                x.parent().right_$eq(y);
            } else {
                x.parent().left_$eq(y);
            }
            y.right_$eq(x);
            x.parent_$eq(y);
            return;
        }
    }

    private <A, B> void transplant(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> to, RedBlackTree.Node<A, B> from) {
        if (to.parent() == null) {
            tree.root_$eq(from);
        } else {
            RedBlackTree.Node<A, B> x$proxy123 = to.parent();
            if (x$proxy123 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            if (to == x$proxy123.left()) {
                to.parent().left_$eq(from);
            } else {
                to.parent().right_$eq(from);
            }
        }
        if (!(from == null)) {
            from.parent_$eq(to.parent());
            return;
        }
    }

    public <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        this.foreachNode(tree.root(), f);
    }

    private <A, B, U> void foreachNode(RedBlackTree.Node<A, B> node, Function1<Tuple2<A, B>, U> f) {
        if (!(node == null)) {
            this.foreachNodeNonNull(node, f);
            return;
        }
    }

    private <A, B, U> void foreachNodeNonNull(RedBlackTree.Node<A, B> node, Function1<Tuple2<A, B>, U> f) {
        while (true) {
            if (!(node.left() == null)) {
                this.foreachNodeNonNull(node.left(), f);
            }
            f.apply(Tuple2$.MODULE$.apply(node.key(), node.value()));
            if (!(!(node.right() == null))) break;
            node = node.right();
        }
    }

    public <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        RedBlackTree.Node<A, ?> r = tree.root();
        if (!(r == null)) {
            this.g$1(f, r);
            return;
        }
    }

    public <A, B, U> void foreachEntry(RedBlackTree.Tree<A, B> tree, Function2<A, B, U> f) {
        RedBlackTree.Node<A, B> r = tree.root();
        if (!(r == null)) {
            this.g$2(f, r);
            return;
        }
    }

    public <A, B> void transform(RedBlackTree.Tree<A, B> tree, Function2<A, B, B> f) {
        this.transformNode(tree.root(), f);
    }

    private <A, B, U> void transformNode(RedBlackTree.Node<A, B> node, Function2<A, B, B> f) {
        if (!(node == null)) {
            this.transformNodeNonNull(node, f);
            return;
        }
    }

    private <A, B, U> void transformNodeNonNull(RedBlackTree.Node<A, B> node, Function2<A, B, B> f) {
        while (true) {
            if (!(node.left() == null)) {
                this.transformNodeNonNull(node.left(), f);
            }
            node.value_$eq(f.apply(node.key(), node.value()));
            if (!(!(node.right() == null))) break;
            node = node.right();
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$1) {
        return new RedBlackTree.EntriesIterator<A, B>(tree, start, end, evidence$1);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> None$ iterator$default$3() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(RedBlackTree.Tree<A, ?> tree, Option<A> start, Option<A> end, Ordering<A> evidence$1) {
        return new RedBlackTree.KeysIterator(tree, start, end, evidence$1);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A> None$ keysIterator$default$3() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$1) {
        return new RedBlackTree.ValuesIterator<A, B>(tree, start, end, evidence$1);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> None$ valuesIterator$default$3() {
        return None$.MODULE$;
    }

    public <A, B> boolean isValid(RedBlackTree.Tree<A, B> tree, Ordering<A> evidence$1) {
        return this.isValidBST(tree.root(), evidence$1) && this.hasProperParentRefs(tree) && this.isValidRedBlackTree(tree) && this.size(tree.root()) == tree.size();
    }

    private <A, B> boolean hasProperParentRefs(RedBlackTree.Tree<A, B> tree) {
        if (tree.root() == null) {
            return true;
        }
        RedBlackTree.Node<A, B> x$proxy146 = tree.root();
        if (x$proxy146 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        return x$proxy146.parent() == null && this.hasProperParentRefs$1(tree.root());
    }

    private <A, B> boolean isValidBST(RedBlackTree.Node<A, B> node, Ordering<A> ord) {
        while (true) {
            if (node == null) {
                return true;
            }
            if (!(node.left() == null) && ord.compare(node.key(), node.left().key()) <= 0 || !(node.right() == null) && ord.compare(node.key(), node.right().key()) >= 0) {
                return false;
            }
            if (!this.isValidBST(node.left(), ord)) break;
            node = node.right();
        }
        return false;
    }

    private <A, B> boolean isValidRedBlackTree(RedBlackTree.Tree<A, B> tree) {
        return this.isBlack(tree.root()) && this.noRedAfterRed$1(tree.root()) && this.blackHeight$1(tree.root()) >= 0;
    }

    public <A> RedBlackTree.Tree<A, Null$> fromOrderedKeys(Iterator<A> xs, int size) {
        int maxUsedDepth = 32 - Integer.numberOfLeadingZeros(size);
        return new RedBlackTree.Tree(this.f$3(xs, maxUsedDepth, 1, size), size);
    }

    public <A, B> RedBlackTree.Tree<A, B> fromOrderedEntries(Iterator<Tuple2<A, B>> xs, int size) {
        int maxUsedDepth = 32 - Integer.numberOfLeadingZeros(size);
        return new RedBlackTree.Tree(this.f$4(xs, maxUsedDepth, 1, size), size);
    }

    public <A, B> RedBlackTree.Node<A, B> copyTree(RedBlackTree.Node<A, B> n) {
        if (n == null) {
            return null;
        }
        RedBlackTree.Node<A, B> c = new RedBlackTree.Node<A, B>(n.key(), n.value(), n.red(), this.copyTree(n.left()), this.copyTree(n.right()), null);
        if (c.left() != null) {
            c.left().parent_$eq(c);
        }
        if (c.right() != null) {
            c.right().parent_$eq(c);
        }
        return c;
    }

    private final void g$1(Function1 f$1, RedBlackTree.Node node) {
        while (true) {
            RedBlackTree.Node l;
            if (!((l = node.left()) == null)) {
                this.g$1(f$1, l);
            }
            f$1.apply(node.key());
            RedBlackTree.Node r = node.right();
            if (!(!(r == null))) break;
            node = r;
        }
    }

    private final void g$2(Function2 f$2, RedBlackTree.Node node) {
        while (true) {
            RedBlackTree.Node l;
            if (!((l = node.left()) == null)) {
                this.g$2(f$2, l);
            }
            f$2.apply(node.key(), node.value());
            RedBlackTree.Node r = node.right();
            if (!(!(r == null))) break;
            node = r;
        }
    }

    private final boolean hasProperParentRefs$1(RedBlackTree.Node node) {
        while (true) {
            if (node == null) {
                return true;
            }
            if (!(node.left() == null) && !(node.left().parent() == node) || !(node.right() == null) && !(node.right().parent() == node)) {
                return false;
            }
            if (!this.hasProperParentRefs$1(node.left())) break;
            node = node.right();
        }
        return false;
    }

    private final boolean noRedAfterRed$1(RedBlackTree.Node node) {
        while (true) {
            if (node == null) {
                return true;
            }
            if (node.red() && (this.isRed(node.left()) || this.isRed(node.right()))) {
                return false;
            }
            if (!this.noRedAfterRed$1(node.left())) break;
            node = node.right();
        }
        return false;
    }

    private final int blackHeight$1(RedBlackTree.Node node) {
        if (node == null) {
            return 1;
        }
        int lh = this.blackHeight$1(node.left());
        int rh = this.blackHeight$1(node.right());
        if (lh == -1 || lh != rh) {
            return -1;
        }
        if (this.isRed(node)) {
            return lh;
        }
        return lh + 1;
    }

    private final RedBlackTree.Node f$3(Iterator xs$1, int maxUsedDepth$1, int level, int size) {
        int n = size;
        if (0 == n) {
            return null;
        }
        if (1 == n) {
            return new RedBlackTree.Node(xs$1.next(), null, level == maxUsedDepth$1 && level != 1, null, null, null);
        }
        int n2 = n;
        int leftSize = (size - 1) / 2;
        RedBlackTree.Node left = this.f$3(xs$1, maxUsedDepth$1, level + 1, leftSize);
        Object x = xs$1.next();
        RedBlackTree.Node right = this.f$3(xs$1, maxUsedDepth$1, level + 1, size - 1 - leftSize);
        RedBlackTree.Node n3 = new RedBlackTree.Node(x, null, false, left, right, null);
        if (!(left == null)) {
            left.parent_$eq(n3);
        }
        if (right == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        right.parent_$eq(n3);
        return n3;
    }

    private final RedBlackTree.Node f$4(Iterator xs$2, int maxUsedDepth$2, int level, int size) {
        Tuple2 tuple2;
        Tuple2 $3$;
        int n = size;
        if (0 == n) {
            return null;
        }
        if (1 == n) {
            Tuple2 tuple22;
            Tuple2 $1$;
            Tuple2 tuple23 = $1$ = (tuple22 = (Tuple2)xs$2.next());
            Object k = tuple23._1();
            Object v = tuple23._2();
            return new RedBlackTree.Node(k, v, level == maxUsedDepth$2 && level != 1, null, null, null);
        }
        int n2 = n;
        int leftSize = (size - 1) / 2;
        RedBlackTree.Node left = this.f$4(xs$2, maxUsedDepth$2, level + 1, leftSize);
        Tuple2 tuple24 = $3$ = (tuple2 = (Tuple2)xs$2.next());
        Object k = tuple24._1();
        Object v = tuple24._2();
        RedBlackTree.Node right = this.f$4(xs$2, maxUsedDepth$2, level + 1, size - 1 - leftSize);
        RedBlackTree.Node n3 = new RedBlackTree.Node(k, v, false, left, right, null);
        if (!(left == null)) {
            left.parent_$eq(n3);
        }
        if (right == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        right.parent_$eq(n3);
        return n3;
    }
}

