/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec3(-0.03, -0.85, -0.94) - 0.0) => vec3(-0.03, -0.85, -0.94)
 * (vec3(-0.03, -0.85, -0.94) - -1.33) => vec3(1.3000001, 0.48000002, 0.39000005)
 * (vec3(-0.03, -0.85, -0.94) - 0.85) => vec3(-0.88, -1.7, -1.79)
 * (vec3(1.67, 0.66, 1.87) - 0.0) => vec3(1.67, 0.66, 1.87)
 * (vec3(1.67, 0.66, 1.87) - -1.33) => vec3(3.0, 1.99, 3.2)
 * (vec3(1.67, 0.66, 1.87) - 0.85) => vec3(0.81999993, -0.19, 1.02)
 */
#version 120

void main()
{
  float[distance((vec3(-0.03, -0.85, -0.94) - 0.0), vec3(-0.03, -0.85, -0.94)) <= 1.2676751e-05 ? 1 : -1] array0;
  float[distance((vec3(-0.03, -0.85, -0.94) - -1.33), vec3(1.3000001, 0.48000002, 0.39000005)) <= 1.4396181e-05 ? 1 : -1] array1;
  float[distance((vec3(-0.03, -0.85, -0.94) - 0.85), vec3(-0.88, -1.7, -1.79)) <= 2.6207823e-05 ? 1 : -1] array2;
  float[distance((vec3(1.67, 0.66, 1.87) - 0.0), vec3(1.67, 0.66, 1.87)) <= 2.5925663e-05 ? 1 : -1] array3;
  float[distance((vec3(1.67, 0.66, 1.87) - -1.33), vec3(3.0, 1.99, 3.2)) <= 4.8166483e-05 ? 1 : -1] array4;
  float[distance((vec3(1.67, 0.66, 1.87) - 0.85), vec3(0.81999993, -0.19, 1.02)) <= 1.3224598e-05 ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
