/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.usbserial.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.discovery.AbstractDiscoveryService;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.DiscoveryResultBuilder;
import org.openhab.core.config.discovery.DiscoveryService;
import org.openhab.core.config.discovery.usbserial.UsbSerialDeviceInformation;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscovery;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscoveryListener;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscoveryParticipant;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={DiscoveryService.class, UsbSerialDiscoveryService.class}, configurationPid={"discovery.usbserial"})
public class UsbSerialDiscoveryService
extends AbstractDiscoveryService
implements UsbSerialDiscoveryListener {
    private final Logger logger = LoggerFactory.getLogger(UsbSerialDiscoveryService.class);
    private static final String THING_PROPERTY_USB_VENDOR_ID = "usb_vendor_id";
    private static final String THING_PROPERTY_USB_PRODUCT_ID = "usb_product_id";
    private final Set<UsbSerialDiscoveryParticipant> discoveryParticipants = new CopyOnWriteArraySet<UsbSerialDiscoveryParticipant>();
    private final Set<UsbSerialDeviceInformation> previouslyDiscovered = new CopyOnWriteArraySet<UsbSerialDeviceInformation>();
    private final Set<UsbSerialDiscovery> usbSerialDiscoveries = new CopyOnWriteArraySet<UsbSerialDiscovery>();

    public UsbSerialDiscoveryService() {
        super(5);
    }

    @Activate
    protected void activate(@Nullable Map<String, Object> configProperties) {
        super.activate(configProperties);
    }

    @Modified
    protected void modified(@Nullable Map<String, Object> configProperties) {
        super.modified(configProperties);
    }

    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addUsbSerialDiscoveryParticipant(UsbSerialDiscoveryParticipant participant) {
        this.discoveryParticipants.add(participant);
        for (UsbSerialDeviceInformation usbSerialDeviceInformation : this.previouslyDiscovered) {
            DiscoveryResult result = participant.createResult(usbSerialDeviceInformation);
            if (result == null) continue;
            this.thingDiscovered(this.createDiscoveryResultWithUsbProperties(result, usbSerialDeviceInformation), FrameworkUtil.getBundle(participant.getClass()));
        }
    }

    protected void removeUsbSerialDiscoveryParticipant(UsbSerialDiscoveryParticipant participant) {
        this.discoveryParticipants.remove(participant);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addUsbSerialDiscovery(UsbSerialDiscovery usbSerialDiscovery) {
        this.usbSerialDiscoveries.add(usbSerialDiscovery);
        usbSerialDiscovery.registerDiscoveryListener(this);
        if (this.isBackgroundDiscoveryEnabled()) {
            usbSerialDiscovery.startBackgroundScanning();
        }
    }

    protected synchronized void removeUsbSerialDiscovery(UsbSerialDiscovery usbSerialDiscovery) {
        usbSerialDiscovery.stopBackgroundScanning();
        usbSerialDiscovery.unregisterDiscoveryListener(this);
        this.usbSerialDiscoveries.remove(usbSerialDiscovery);
        this.previouslyDiscovered.clear();
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        return this.discoveryParticipants.stream().flatMap(participant -> participant.getSupportedThingTypeUIDs().stream()).collect(Collectors.toSet());
    }

    protected void startScan() {
        this.usbSerialDiscoveries.forEach(UsbSerialDiscovery::doSingleScan);
    }

    protected void startBackgroundDiscovery() {
        this.usbSerialDiscoveries.forEach(UsbSerialDiscovery::startBackgroundScanning);
    }

    protected void stopBackgroundDiscovery() {
        this.usbSerialDiscoveries.forEach(UsbSerialDiscovery::stopBackgroundScanning);
    }

    @Override
    public void usbSerialDeviceDiscovered(UsbSerialDeviceInformation usbSerialDeviceInformation) {
        if (this.previouslyDiscovered.add(usbSerialDeviceInformation)) {
            this.logger.debug("Discovered new USB-Serial device: {}", (Object)usbSerialDeviceInformation);
        }
        for (UsbSerialDiscoveryParticipant participant : this.discoveryParticipants) {
            DiscoveryResult result = participant.createResult(usbSerialDeviceInformation);
            if (result == null) continue;
            this.thingDiscovered(this.createDiscoveryResultWithUsbProperties(result, usbSerialDeviceInformation));
        }
    }

    @Override
    public void usbSerialDeviceRemoved(UsbSerialDeviceInformation usbSerialDeviceInformation) {
        this.logger.debug("Discovered removal of USB-Serial device: {}", (Object)usbSerialDeviceInformation);
        this.previouslyDiscovered.remove(usbSerialDeviceInformation);
        for (UsbSerialDiscoveryParticipant participant : this.discoveryParticipants) {
            ThingUID thingUID = participant.getThingUID(usbSerialDeviceInformation);
            if (thingUID == null) continue;
            this.thingRemoved(thingUID);
        }
    }

    private DiscoveryResult createDiscoveryResultWithUsbProperties(DiscoveryResult result, UsbSerialDeviceInformation usbSerialDeviceInformation) {
        HashMap<String, Integer> resultProperties = new HashMap<String, Integer>(result.getProperties());
        resultProperties.put(THING_PROPERTY_USB_VENDOR_ID, usbSerialDeviceInformation.getVendorId());
        resultProperties.put(THING_PROPERTY_USB_PRODUCT_ID, usbSerialDeviceInformation.getProductId());
        return DiscoveryResultBuilder.create((ThingUID)result.getThingUID()).withProperties(resultProperties).withBridge(result.getBridgeUID()).withTTL(result.getTimeToLive()).withLabel(result.getLabel()).withRepresentationProperty(result.getRepresentationProperty()).build();
    }
}

