/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.snmp.mib;

import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.snmp.mib.FileUtils;
import org.logstash.snmp.mib.InvalidMibFileException;
import org.logstash.snmp.mib.MibReader;
import org.logstash.snmp.mib.OidData;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snmp4j.smi.OID;

class RubySnmpMibReader
implements MibReader {
    private static final Logger logger = LogManager.getLogger(RubySnmpMibReader.class);
    private static final LoadSettings LOAD_SETTINGS = LoadSettings.builder().build();
    static final String FILE_EXTENSION = "yaml";

    RubySnmpMibReader() {
    }

    @Override
    public void read(Collection<Path> paths, BiConsumer<OID, OidData> consumer) throws InvalidMibFileException {
        for (Path path : paths) {
            Map<String, String> configMap = this.loadYamlFile(path);
            String moduleName = FileUtils.getFileNameWithoutExtension(path);
            for (Map.Entry<String, String> entry : configMap.entrySet()) {
                OID oid;
                try {
                    oid = new OID(entry.getValue());
                }
                catch (RuntimeException e) {
                    logger.warn("The MIB file `{}` has an invalid OID value `{}`. Skipping", (Object)path, (Object)entry.getValue());
                    continue;
                }
                consumer.accept(oid, new OidData("node", entry.getKey(), moduleName));
            }
        }
    }

    private Map<String, String> loadYamlFile(Path file) {
        Load yaml = new Load(LOAD_SETTINGS);
        try {
            return (Map)yaml.loadFromReader((Reader)Files.newBufferedReader(file));
        }
        catch (Exception e) {
            throw new InvalidMibFileException(String.format("Error reading MIB file: %s", file), e);
        }
    }
}

