/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler2;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.AttributeKeyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.ExemplarStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.ExponentialHistogramBucketsStatelessMarshaler;
import io.opentelemetry.proto.metrics.v1.internal.ExponentialHistogramDataPoint;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramPointData;
import java.io.IOException;
import java.util.List;

final class ExponentialHistogramDataPointStatelessMarshaler
implements StatelessMarshaler<ExponentialHistogramPointData> {
    static final ExponentialHistogramDataPointStatelessMarshaler INSTANCE = new ExponentialHistogramDataPointStatelessMarshaler();

    private ExponentialHistogramDataPointStatelessMarshaler() {
    }

    public void writeTo(Serializer output, ExponentialHistogramPointData point, MarshalerContext context) throws IOException {
        output.serializeFixed64(ExponentialHistogramDataPoint.START_TIME_UNIX_NANO, point.getStartEpochNanos());
        output.serializeFixed64(ExponentialHistogramDataPoint.TIME_UNIX_NANO, point.getEpochNanos());
        output.serializeFixed64(ExponentialHistogramDataPoint.COUNT, point.getCount());
        output.serializeDouble(ExponentialHistogramDataPoint.SUM, point.getSum());
        if (point.hasMin()) {
            output.serializeDoubleOptional(ExponentialHistogramDataPoint.MIN, point.getMin());
        }
        if (point.hasMax()) {
            output.serializeDoubleOptional(ExponentialHistogramDataPoint.MAX, point.getMax());
        }
        output.serializeSInt32(ExponentialHistogramDataPoint.SCALE, point.getScale());
        output.serializeFixed64(ExponentialHistogramDataPoint.ZERO_COUNT, point.getZeroCount());
        output.serializeMessageWithContext(ExponentialHistogramDataPoint.POSITIVE, (Object)point.getPositiveBuckets(), (StatelessMarshaler)ExponentialHistogramBucketsStatelessMarshaler.INSTANCE, context);
        output.serializeMessageWithContext(ExponentialHistogramDataPoint.NEGATIVE, (Object)point.getNegativeBuckets(), (StatelessMarshaler)ExponentialHistogramBucketsStatelessMarshaler.INSTANCE, context);
        output.serializeRepeatedMessageWithContext(ExponentialHistogramDataPoint.EXEMPLARS, point.getExemplars(), (StatelessMarshaler)ExemplarStatelessMarshaler.INSTANCE, context);
        output.serializeRepeatedMessageWithContext(ExponentialHistogramDataPoint.ATTRIBUTES, point.getAttributes(), (StatelessMarshaler2)AttributeKeyValueStatelessMarshaler.INSTANCE, context);
    }

    public int getBinarySerializedSize(ExponentialHistogramPointData point, MarshalerContext context) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)ExponentialHistogramDataPoint.START_TIME_UNIX_NANO, (long)point.getStartEpochNanos());
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)ExponentialHistogramDataPoint.TIME_UNIX_NANO, (long)point.getEpochNanos());
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)ExponentialHistogramDataPoint.COUNT, (long)point.getCount());
        size += MarshalerUtil.sizeDouble((ProtoFieldInfo)ExponentialHistogramDataPoint.SUM, (double)point.getSum());
        if (point.hasMin()) {
            size += MarshalerUtil.sizeDoubleOptional((ProtoFieldInfo)ExponentialHistogramDataPoint.MIN, (double)point.getMin());
        }
        if (point.hasMax()) {
            size += MarshalerUtil.sizeDoubleOptional((ProtoFieldInfo)ExponentialHistogramDataPoint.MAX, (double)point.getMax());
        }
        size += MarshalerUtil.sizeSInt32((ProtoFieldInfo)ExponentialHistogramDataPoint.SCALE, (int)point.getScale());
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)ExponentialHistogramDataPoint.ZERO_COUNT, (long)point.getZeroCount());
        size += StatelessMarshalerUtil.sizeMessageWithContext((ProtoFieldInfo)ExponentialHistogramDataPoint.POSITIVE, (Object)point.getPositiveBuckets(), (StatelessMarshaler)ExponentialHistogramBucketsStatelessMarshaler.INSTANCE, (MarshalerContext)context);
        size += StatelessMarshalerUtil.sizeMessageWithContext((ProtoFieldInfo)ExponentialHistogramDataPoint.NEGATIVE, (Object)point.getNegativeBuckets(), (StatelessMarshaler)ExponentialHistogramBucketsStatelessMarshaler.INSTANCE, (MarshalerContext)context);
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)ExponentialHistogramDataPoint.EXEMPLARS, (List)point.getExemplars(), (StatelessMarshaler)ExemplarStatelessMarshaler.INSTANCE, (MarshalerContext)context);
        return size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)ExponentialHistogramDataPoint.ATTRIBUTES, (Attributes)point.getAttributes(), (StatelessMarshaler2)AttributeKeyValueStatelessMarshaler.INSTANCE, (MarshalerContext)context);
    }
}

