/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.constants;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class DnsRootServer {
    private static final Map<Character, Inet4Address> IPV4_ROOT_SERVER_MAP = new HashMap<Character, Inet4Address>();
    private static final Map<Character, Inet6Address> IPV6_ROOT_SERVER_MAP = new HashMap<Character, Inet6Address>();
    protected static final Inet4Address[] IPV4_ROOT_SERVERS = new Inet4Address[]{DnsRootServer.rootServerInet4Address('a', 198, 41, 0, 4), DnsRootServer.rootServerInet4Address('b', 192, 228, 79, 201), DnsRootServer.rootServerInet4Address('c', 192, 33, 4, 12), DnsRootServer.rootServerInet4Address('d', 199, 7, 91, 13), DnsRootServer.rootServerInet4Address('e', 192, 203, 230, 10), DnsRootServer.rootServerInet4Address('f', 192, 5, 5, 241), DnsRootServer.rootServerInet4Address('g', 192, 112, 36, 4), DnsRootServer.rootServerInet4Address('h', 198, 97, 190, 53), DnsRootServer.rootServerInet4Address('i', 192, 36, 148, 17), DnsRootServer.rootServerInet4Address('j', 192, 58, 128, 30), DnsRootServer.rootServerInet4Address('k', 193, 0, 14, 129), DnsRootServer.rootServerInet4Address('l', 199, 7, 83, 42), DnsRootServer.rootServerInet4Address('m', 202, 12, 27, 33)};
    protected static final Inet6Address[] IPV6_ROOT_SERVERS = new Inet6Address[]{DnsRootServer.rootServerInet6Address('a', 8193, 1283, 47678, 0, 0, 0, 2, 48), DnsRootServer.rootServerInet6Address('b', 8193, 1280, 132, 0, 0, 0, 0, 11), DnsRootServer.rootServerInet6Address('c', 8193, 1280, 2, 0, 0, 0, 0, 12), DnsRootServer.rootServerInet6Address('d', 8193, 1280, 45, 0, 0, 0, 0, 13), DnsRootServer.rootServerInet6Address('f', 8193, 1280, 47, 0, 0, 0, 0, 15), DnsRootServer.rootServerInet6Address('h', 8193, 1280, 1, 0, 0, 0, 0, 83), DnsRootServer.rootServerInet6Address('i', 8193, 2046, 0, 0, 0, 0, 0, 83), DnsRootServer.rootServerInet6Address('j', 8193, 1283, 3111, 0, 0, 0, 2, 48), DnsRootServer.rootServerInet6Address('l', 8193, 1280, 3, 0, 0, 0, 0, 66), DnsRootServer.rootServerInet6Address('m', 8193, 3523, 0, 0, 0, 0, 0, 53)};

    private static Inet4Address rootServerInet4Address(char rootServerId, int addr0, int addr1, int addr2, int addr3) {
        Inet4Address inetAddress;
        String name = rootServerId + ".root-servers.net";
        try {
            inetAddress = (Inet4Address)InetAddress.getByAddress(name, new byte[]{(byte)addr0, (byte)addr1, (byte)addr2, (byte)addr3});
            IPV4_ROOT_SERVER_MAP.put(Character.valueOf(rootServerId), inetAddress);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return inetAddress;
    }

    private static Inet6Address rootServerInet6Address(char rootServerId, int addr0, int addr1, int addr2, int addr3, int addr4, int addr5, int addr6, int addr7) {
        Inet6Address inetAddress;
        String name = rootServerId + ".root-servers.net";
        try {
            inetAddress = (Inet6Address)InetAddress.getByAddress(name, new byte[]{(byte)(addr0 >> 8), (byte)addr0, (byte)(addr1 >> 8), (byte)addr1, (byte)(addr2 >> 8), (byte)addr2, (byte)(addr3 >> 8), (byte)addr3, (byte)(addr4 >> 8), (byte)addr4, (byte)(addr5 >> 8), (byte)addr5, (byte)(addr6 >> 8), (byte)addr6, (byte)(addr7 >> 8), (byte)addr7});
            IPV6_ROOT_SERVER_MAP.put(Character.valueOf(rootServerId), inetAddress);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return inetAddress;
    }

    public static Inet4Address getRandomIpv4RootServer(Random random) {
        return IPV4_ROOT_SERVERS[random.nextInt(IPV4_ROOT_SERVERS.length)];
    }

    public static Inet6Address getRandomIpv6RootServer(Random random) {
        return IPV6_ROOT_SERVERS[random.nextInt(IPV6_ROOT_SERVERS.length)];
    }

    public static Inet4Address getIpv4RootServerById(char id) {
        return IPV4_ROOT_SERVER_MAP.get(Character.valueOf(id));
    }

    public static Inet6Address getIpv6RootServerById(char id) {
        return IPV6_ROOT_SERVER_MAP.get(Character.valueOf(id));
    }
}

