/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftAbstractResampler;

public final class SoftSincResampler
extends SoftAbstractResampler {
    float[][][] sinc_table;
    int sinc_scale_size = 100;
    int sinc_table_fsize = 800;
    int sinc_table_size = 30;
    int sinc_table_center = this.sinc_table_size / 2;

    public SoftSincResampler() {
        this.sinc_table = new float[this.sinc_scale_size][this.sinc_table_fsize][];
        for (int i = 0; i < this.sinc_scale_size; ++i) {
            float f = (float)(1.0 / (1.0 + Math.pow(i, 1.1) / 10.0));
            for (int j = 0; j < this.sinc_table_fsize; ++j) {
                this.sinc_table[i][j] = SoftSincResampler.sincTable(this.sinc_table_size, (float)(-j) / (float)this.sinc_table_fsize, f);
            }
        }
    }

    public static double sinc(double d) {
        return d == 0.0 ? 1.0 : Math.sin(Math.PI * d) / (Math.PI * d);
    }

    public static float[] wHanning(int n, float f) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = (float)(-0.5 * Math.cos(Math.PI * 2 * (double)((float)i + f) / (double)n) + 0.5);
        }
        return fArray;
    }

    public static float[] sincTable(int n, float f, float f2) {
        int n2 = n / 2;
        float[] fArray = SoftSincResampler.wHanning(n, f);
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            fArray[n3] = (float)((double)fArray[n3] * (SoftSincResampler.sinc(((float)(-n2 + i) + f) * f2) * (double)f2));
        }
        return fArray;
    }

    @Override
    public int getPadding() {
        return this.sinc_table_size / 2 + 2;
    }

    @Override
    public void interpolate(float[] fArray, float[] fArray2, float f, float[] fArray3, float f2, float[] fArray4, int[] nArray, int n) {
        float f3 = fArray3[0];
        float f4 = fArray2[0];
        int n2 = nArray[0];
        float f5 = f;
        int n3 = n;
        int n4 = this.sinc_scale_size - 1;
        if (f2 == 0.0f) {
            int n5 = (int)((f3 - 1.0f) * 10.0f);
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 > n4) {
                n5 = n4;
            }
            float[][] fArray5 = this.sinc_table[n5];
            while (f4 < f5 && n2 < n3) {
                int n6 = (int)f4;
                float[] fArray6 = fArray5[(int)((f4 - (float)n6) * (float)this.sinc_table_fsize)];
                int n7 = n6 - this.sinc_table_center;
                float f6 = 0.0f;
                int n8 = 0;
                while (n8 < this.sinc_table_size) {
                    f6 += fArray[n7] * fArray6[n8];
                    ++n8;
                    ++n7;
                }
                fArray4[n2++] = f6;
                f4 += f3;
            }
        } else {
            while (f4 < f5 && n2 < n3) {
                int n9 = (int)f4;
                int n10 = (int)((f3 - 1.0f) * 10.0f);
                if (n10 < 0) {
                    n10 = 0;
                } else if (n10 > n4) {
                    n10 = n4;
                }
                float[][] fArray7 = this.sinc_table[n10];
                float[] fArray8 = fArray7[(int)((f4 - (float)n9) * (float)this.sinc_table_fsize)];
                int n11 = n9 - this.sinc_table_center;
                float f7 = 0.0f;
                int n12 = 0;
                while (n12 < this.sinc_table_size) {
                    f7 += fArray[n11] * fArray8[n12];
                    ++n12;
                    ++n11;
                }
                fArray4[n2++] = f7;
                f4 += f3;
                f3 += f2;
            }
        }
        fArray2[0] = f4;
        nArray[0] = n2;
        fArray3[0] = f3;
    }
}

