/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic.impl;

import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticFix;
import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.architect.ddl.critic.impl.Messages;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CommentCritic
extends CriticAndSettings {
    private final int maxTableCommentLength;
    private final int maxColumnCommentLength;
    private final String platformName;

    @Constructor
    public CommentCritic(@ConstructorParameter(propertyName="platformName") String platformName, @ConstructorParameter(propertyName="maxTableCommentLength") int maxLengthTable, @ConstructorParameter(propertyName="maxColumnCommentLength") int maxLengthColumn) {
        super(platformName, Messages.getString("CommentCritic.name"));
        this.platformName = platformName;
        this.maxColumnCommentLength = maxLengthColumn;
        this.maxTableCommentLength = maxLengthTable;
    }

    @Override
    public List<Criticism> criticize(final Object so) {
        if (!(so instanceof SQLTable) && !(so instanceof SQLColumn)) {
            return Collections.emptyList();
        }
        String remarks = null;
        int maxLength = 0;
        if (so instanceof SQLTable) {
            remarks = ((SQLTable)so).getRemarks();
            maxLength = this.getMaxTableCommentLength();
        } else if (so instanceof SQLColumn) {
            remarks = ((SQLColumn)so).getRemarks();
            maxLength = this.getMaxColumnCommentLength();
        }
        ArrayList<Criticism> criticisms = new ArrayList<Criticism>();
        if (remarks != null && remarks.length() > maxLength && maxLength > 0) {
            criticisms.add(new Criticism(so, "Comment too long for " + this.getPlatformName(), this, new CriticFix("Truncate comment to " + maxLength + " characters", CriticFix.FixType.QUICK_FIX){

                @Override
                public void apply() {
                    SQLColumn col;
                    if (so instanceof SQLTable) {
                        SQLTable tbl = (SQLTable)so;
                        if (tbl.getRemarks() != null && tbl.getRemarks().length() > CommentCritic.this.getMaxTableCommentLength()) {
                            tbl.setRemarks(tbl.getRemarks().substring(CommentCritic.this.getMaxTableCommentLength()));
                        }
                    } else if (so instanceof SQLColumn && (col = (SQLColumn)so).getRemarks() != null && col.getRemarks().length() > CommentCritic.this.getMaxColumnCommentLength()) {
                        col.setRemarks(col.getRemarks().substring(CommentCritic.this.getMaxColumnCommentLength()));
                    }
                }
            }));
        }
        return criticisms;
    }

    @Accessor
    public int getMaxTableCommentLength() {
        return this.maxTableCommentLength;
    }

    @Accessor
    public int getMaxColumnCommentLength() {
        return this.maxColumnCommentLength;
    }

    @Accessor
    public String getPlatformName() {
        return this.platformName;
    }
}

