/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public final class SQLServerDataSourceObjectFactory
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws SQLException {
        try {
            Reference reference = (Reference)object;
            RefAddr refAddr = reference.get("class");
            if (null == refAddr) {
                throw new SQLException(SQLServerException.getErrString("R_invalidDataSourceReference"));
            }
            String string = (String)refAddr.getContent();
            if (null == string) {
                throw new SQLException(SQLServerException.getErrString("R_invalidDataSourceReference"));
            }
            if (string.equals("com.microsoft.sqlserver.jdbc.SQLServerDataSource") || string.equals("com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource") || string.equals("com.microsoft.sqlserver.jdbc.SQLServerXADataSource")) {
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                SQLServerDataSource sQLServerDataSource = (SQLServerDataSource)obj;
                sQLServerDataSource.initializeFromReference(reference);
                return obj;
            }
            throw new SQLException(SQLServerException.getErrString("R_invalidDataSourceReference"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(SQLServerException.getErrString("R_invalidDataSourceReference"));
        }
        catch (InstantiationException instantiationException) {
            throw new SQLException(SQLServerException.getErrString("R_invalidDataSourceReference"));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(SQLServerException.getErrString("R_invalidDataSourceReference"));
        }
    }
}

