/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.testutil;

import ca.sqlpower.testutil.MockJDBCDatabaseMetaData;
import ca.sqlpower.testutil.MockJDBCResultSet;
import ca.sqlpower.testutil.MockJDBCStatement;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MockJDBCConnection
implements Connection {
    private static final Logger logger = Logger.getLogger(MockJDBCConnection.class);
    private boolean autoCommit;
    private boolean readOnly;
    private String currentCatalog;
    private int transactionIsolation;
    private String url;
    private Properties properties;
    private MockJDBCDatabaseMetaData metaData;
    private Map<String, MockJDBCResultSet> resultSets = new TreeMap<String, MockJDBCResultSet>();

    public MockJDBCConnection(String url, Properties properties) {
        this.url = url;
        this.properties = properties;
        this.metaData = new MockJDBCDatabaseMetaData(this);
    }

    String getURL() {
        return this.url;
    }

    Properties getProperties() {
        return this.properties;
    }

    public void registerResultSet(String regex, MockJDBCResultSet rs) {
        this.resultSets.put(regex, rs);
    }

    public void setProperty(String key, String value) {
        logger.debug((Object)("Changing property '" + key + "': '" + this.properties.getProperty(key) + "' -> '" + value + "'"));
        this.properties.setProperty(key, value);
    }

    MockJDBCResultSet resultsForQuery(String sql) {
        for (Map.Entry<String, MockJDBCResultSet> entry : this.resultSets.entrySet()) {
            System.out.println("Comparing \"" + sql + "\" against \"" + entry.getKey() + "\"");
            Pattern p = Pattern.compile(entry.getKey(), 34);
            if (!p.matcher(sql).matches()) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new MockJDBCStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.getMetaData().getCatalogTerm() == null) {
            throw new SQLException("This Mock Database doesn't have catalogs");
        }
        this.currentCatalog = catalog;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.currentCatalog;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.transactionIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.transactionIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        MockJDBCStatement stmt = new MockJDBCStatement(this);
        stmt.setFetchDirection(resultSetType);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new MockJDBCStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }
}

