/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DBConnectionSpec;
import ca.sqlpower.sql.DBConnectionSpecServer;
import ca.sqlpower.sql.DatabaseListReadException;
import java.io.InputStream;
import java.rmi.Naming;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DBCSSourceSupport {
    public static Collection getListUsingRMI(String host) throws DatabaseListReadException {
        Collection databases = null;
        DBConnectionSpecServer obj = null;
        try {
            obj = (DBConnectionSpecServer)Naming.lookup("//" + host + "/DBConnectionSpecServer");
            databases = obj.getAvailableDatabases();
        }
        catch (Exception e) {
            throw new DatabaseListReadException(e);
        }
        return databases;
    }

    public static Collection getListUsingXMLStream(InputStream xmlStream) throws DatabaseListReadException {
        return DBCSSourceSupport.getDBSpecsFromInputStream(xmlStream);
    }

    public static Collection getDBSpecsFromInputStream(InputStream xmlStream) throws DatabaseListReadException {
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document d = db.parse(xmlStream);
            NodeList databaseList = d.getElementsByTagName("database");
            LinkedList<DBConnectionSpec> dbcsList = new LinkedList<DBConnectionSpec>();
            for (int i = 0; i < databaseList.getLength(); ++i) {
                Element databaseNode = (Element)databaseList.item(i);
                String databaseName = databaseNode.getAttribute("name");
                dbcsList.add(DBCSSourceSupport.makeSpecFromDBNode(databaseNode));
            }
            return dbcsList;
        }
        catch (Exception e) {
            throw new DatabaseListReadException(e);
        }
    }

    protected static DBConnectionSpec makeSpecFromDBNode(Element dbElem) {
        if (!dbElem.getNodeName().equals("database")) {
            throw new IllegalArgumentException("This method only supports nodes of type 'database'.");
        }
        DBConnectionSpec spec = new DBConnectionSpec();
        spec.setName(dbElem.getAttributes().getNamedItem("name").getNodeValue());
        spec.setSeqNo(Integer.parseInt(dbElem.getAttributes().getNamedItem("seqNo").getNodeValue()));
        Node singleLoginAttr = dbElem.getAttributes().getNamedItem("singleLogin");
        if (singleLoginAttr != null) {
            spec.setSingleLogin(Boolean.valueOf(singleLoginAttr.getNodeValue()));
        } else {
            spec.setSingleLogin(false);
        }
        NodeList databaseProperties = dbElem.getChildNodes();
        for (int j = 0; j < databaseProperties.getLength(); ++j) {
            Node databaseProperty = databaseProperties.item(j);
            if (databaseProperty.getNodeType() != 1) continue;
            databaseProperty.normalize();
            if (databaseProperty.getNodeName().equals("display-name")) {
                spec.setDisplayName(databaseProperty.getFirstChild().getNodeValue());
                continue;
            }
            if (databaseProperty.getNodeName().equals("driver-class")) {
                spec.setDriverClass(databaseProperty.getFirstChild().getNodeValue());
                continue;
            }
            if (databaseProperty.getNodeName().equals("url")) {
                spec.setUrl(databaseProperty.getFirstChild().getNodeValue());
                continue;
            }
            if (databaseProperty.getNodeName().equals("user")) {
                if (databaseProperty.getFirstChild() == null) continue;
                spec.setUser(databaseProperty.getFirstChild().getNodeValue());
                continue;
            }
            if (!databaseProperty.getNodeName().equals("pass") || databaseProperty.getFirstChild() == null) continue;
            spec.setPass(databaseProperty.getFirstChild().getNodeValue());
        }
        return spec;
    }
}

