/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.component.dsl.Publisher;
import org.apache.aries.component.dsl.internal.OSGiImpl;
import org.apache.aries.component.dsl.internal.OSGiResultImpl;
import org.apache.aries.component.dsl.internal.UpdateSupport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

public class ConfigurationsOSGiImpl
extends OSGiImpl<Dictionary<String, ?>> {
    public ConfigurationsOSGiImpl(String factoryPid) {
        super((BundleContext bundleContext, Publisher<T> op) -> {
            ConcurrentHashMap<String, Configuration> configurations = new ConcurrentHashMap<String, Configuration>();
            ConcurrentHashMap<String, Object> terminators = new ConcurrentHashMap<String, Object>();
            AtomicBoolean closed = new AtomicBoolean();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ServiceRegistration serviceRegistration = bundleContext.registerService(ConfigurationListener.class, configurationEvent -> {
                String incomingFactoryPid = configurationEvent.getFactoryPid();
                if (incomingFactoryPid == null || !factoryPid.equals(incomingFactoryPid)) {
                    return;
                }
                try {
                    countDownLatch.await(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    return;
                }
                String pid = configurationEvent.getPid();
                if (configurationEvent.getType() == 2) {
                    configurations.remove(pid);
                    ConfigurationsOSGiImpl.signalLeave(pid, terminators);
                } else {
                    Configuration configuration = ConfigurationsOSGiImpl.getConfiguration(bundleContext, configurationEvent);
                    Dictionary properties = configuration.getProperties();
                    configurations.compute(pid, (__, old) -> {
                        if (old == null || configuration.getChangeCount() != old.getChangeCount()) {
                            return configuration;
                        }
                        return old;
                    });
                    UpdateSupport.runUpdate(() -> {
                        ConfigurationsOSGiImpl.signalLeave(pid, terminators);
                        terminators.put(pid, op.apply(properties));
                    });
                    if (closed.get()) {
                        ConfigurationsOSGiImpl.signalLeave(pid, terminators);
                    }
                }
            }, new Hashtable());
            ServiceReference serviceReference = bundleContext.getServiceReference(ConfigurationAdmin.class);
            if (serviceReference != null) {
                Configuration[] configuration;
                for (Configuration c : configuration = ConfigurationsOSGiImpl.getConfigurations(bundleContext, factoryPid, (ServiceReference<ConfigurationAdmin>)serviceReference)) {
                    configurations.put(c.getPid(), c);
                    terminators.put(c.getPid(), op.apply(c.getProperties()));
                }
            }
            countDownLatch.countDown();
            return new OSGiResultImpl(() -> {
                closed.set(true);
                serviceRegistration.unregister();
                for (Runnable runnable : terminators.values()) {
                    if (runnable == null) continue;
                    runnable.run();
                }
            });
        });
    }

    private static Configuration getConfiguration(BundleContext bundleContext, ConfigurationEvent configurationEvent) {
        String pid = configurationEvent.getPid();
        String factoryPid = configurationEvent.getFactoryPid();
        ServiceReference reference = configurationEvent.getReference();
        return ConfigurationsOSGiImpl.getConfiguration(bundleContext, pid, factoryPid, (ServiceReference<ConfigurationAdmin>)reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Configuration getConfiguration(BundleContext bundleContext, String pid, String factoryPid, ServiceReference<ConfigurationAdmin> reference) {
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(reference);
        try {
            Configuration[] configurations = configurationAdmin.listConfigurations("(&(service.pid=" + pid + ")(service.factoryPid=" + factoryPid + "))");
            if (configurations == null || configurations.length == 0) {
                Configuration configuration = null;
                return configuration;
            }
            Configuration configuration = configurations[0];
            return configuration;
        }
        catch (Exception e) {
            Configuration configuration = null;
            return configuration;
        }
        finally {
            bundleContext.ungetService(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Configuration[] getConfigurations(BundleContext bundleContext, String factoryPid, ServiceReference<ConfigurationAdmin> serviceReference) {
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(serviceReference);
        try {
            Configuration[] configurations = configurationAdmin.listConfigurations("(&(service.pid=*)(service.factoryPid=" + factoryPid + "))");
            if (configurations == null) {
                Configuration[] configurationArray = new Configuration[]{};
                return configurationArray;
            }
            Configuration[] configurationArray = configurations;
            return configurationArray;
        }
        catch (Exception e) {
            Configuration[] configurationArray = new Configuration[]{};
            return configurationArray;
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }

    private static void signalLeave(String factoryPid, ConcurrentHashMap<String, Runnable> terminators) {
        Runnable runnable = terminators.remove(factoryPid);
        if (runnable != null) {
            runnable.run();
        }
    }
}

